/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.videoplayer;

import android.content.Context;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.lansosdk.box.LSOLog;
import com.lansosdk.videoplayer.IMediaDataSource;
import com.lansosdk.videoplayer.LXPlayerCompletionListener;
import com.lansosdk.videoplayer.OnLSOPlayeFrameUpdateListener;
import com.lansosdk.videoplayer.OnLSOPlayerBufferingUpdateListener;
import com.lansosdk.videoplayer.OnLSOPlayerErrorListener;
import com.lansosdk.videoplayer.OnLSOPlayerExactlySeekCompleteListener;
import com.lansosdk.videoplayer.OnLSOPlayerInfoListener;
import com.lansosdk.videoplayer.OnLSOPlayerSeekCompleteListener;
import com.lansosdk.videoplayer.OnLSOPlayerVideoSizeChangedListener;
import com.lansosdk.videoplayer.PlayerPreparedListener;
import com.lansosdk.videoplayer.VideoPlayer$OnControlMessageListener;
import com.lansosdk.videoplayer.VideoPlayer$OnNativeInvokeListener;
import com.lansosdk.videoplayer.a;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoPlayer {
    int MEDIA_INFO_UNKNOWN = 1;
    static int MEDIA_INFO_STARTED_AS_NEXT = 2;
    static int MEDIA_INFO_VIDEO_RENDERING_START = 3;
    static int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700;
    static int MEDIA_INFO_BUFFERING_START = 701;
    static int MEDIA_INFO_BUFFERING_END = 702;
    static int MEDIA_INFO_NETWORK_BANDWIDTH = 703;
    static int MEDIA_INFO_BAD_INTERLEAVING = 800;
    static int MEDIA_INFO_NOT_SEEKABLE = 801;
    static int MEDIA_INFO_METADATA_UPDATE = 802;
    static int MEDIA_INFO_TIMED_TEXT_ERROR = 900;
    static int MEDIA_INFO_UNSUPPORTED_SUBTITLE = 901;
    static int MEDIA_INFO_SUBTITLE_TIMED_OUT = 902;
    static int MEDIA_INFO_VIDEO_ROTATION_CHANGED = 10001;
    static int MEDIA_INFO_AUDIO_RENDERING_START = 10002;
    static int MEDIA_INFO_MEDIA_ACCURATE_SEEK_COMPLETE = 10100;
    static int MEDIA_ERROR_UNKNOWN = 1;
    static int MEDIA_ERROR_SERVER_DIED = 100;
    static int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200;
    static int MEDIA_ERROR_IO = -1004;
    static int MEDIA_ERROR_MALFORMED = -1007;
    static int MEDIA_ERROR_UNSUPPORTED = -1010;
    static int MEDIA_ERROR_TIMED_OUT = -110;
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_TIMED_TEXT = 99;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    private static final int VIDEOEDIT_EVENT_COMPLETE = 8001;
    protected static final int MEDIA_SET_VIDEO_SAR = 10001;
    protected static final int LANSONG_FRAME_UPDATE = 80001;
    public static final int LOG_UNKNOWN = 0;
    public static final int LOG_DEFAULT = 1;
    public static final int LOG_VERBOSE = 2;
    public static final int LOG_DEBUG = 3;
    public static final int LOG_INFO = 4;
    public static final int LOG_WARN = 5;
    public static final int LOG_ERROR = 6;
    public static final int LOG_FATAL = 7;
    public static final int LOG_SILENT = 8;
    public static final int OPT_CATEGORY_FORMAT = 1;
    public static final int OPT_CATEGORY_CODEC = 2;
    public static final int OPT_CATEGORY_SWS = 3;
    public static final int OPT_CATEGORY_PLAYER = 4;
    public static final int SDL_FCC_YV12 = 842094169;
    public static final int SDL_FCC_RV16 = 909203026;
    public static final int SDL_FCC_RV32 = 842225234;
    public static final int PROP_FLOAT_VIDEO_DECODE_FRAMES_PER_SECOND = 10001;
    public static final int PROP_FLOAT_VIDEO_OUTPUT_FRAMES_PER_SECOND = 10002;
    public static final int FFP_PROP_FLOAT_PLAYBACK_RATE = 10003;
    public static final int FFP_PROP_INT64_SELECTED_VIDEO_STREAM = 20001;
    public static final int FFP_PROP_INT64_SELECTED_AUDIO_STREAM = 20002;
    private long mNativeMediaPlayer;
    private long mNativeMediaDataSource;
    private int mNativeSurfaceTexture;
    private int mListenerContext;
    private SurfaceHolder mSurfaceHolder;
    private a mEventHandler;
    private PowerManager.WakeLock mWakeLock = null;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mVideoSarNum;
    private int mVideoSarDen;
    private String mDataSource;
    private static volatile boolean mIsNativeInitialized = false;
    private PlayerPreparedListener mOnPreparedListener;
    private LXPlayerCompletionListener mOnCompletionListener;
    private OnLSOPlayerBufferingUpdateListener mOnBufferingUpdateListener;
    private OnLSOPlayerSeekCompleteListener mOnSeekCompleteListener;
    private OnLSOPlayerExactlySeekCompleteListener mOnExactlySeekCompleteListener;
    private OnLSOPlayerVideoSizeChangedListener mOnVideoSizeChangedListener;
    private OnLSOPlayerErrorListener mOnErrorListener;
    private OnLSOPlayerInfoListener mOnInfoListener;
    private OnLSOPlayeFrameUpdateListener mOnPlayeFrameUpdateListener;
    public AtomicBoolean isPrepared = new AtomicBoolean(false);
    private VideoPlayer$OnControlMessageListener mOnControlMessageListener;
    private VideoPlayer$OnNativeInvokeListener mOnNativeInvokeListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initNativeOnce() {
        Class<VideoPlayer> clazz = VideoPlayer.class;
        synchronized (VideoPlayer.class) {
            if (!mIsNativeInitialized) {
                VideoPlayer.native_init();
                mIsNativeInitialized = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public final void setOnPreparedListener(PlayerPreparedListener playerPreparedListener) {
        this.mOnPreparedListener = playerPreparedListener;
    }

    public final void setOnCompletionListener(LXPlayerCompletionListener lXPlayerCompletionListener) {
        this.mOnCompletionListener = lXPlayerCompletionListener;
    }

    public final void setOnBufferingUpdateListener(OnLSOPlayerBufferingUpdateListener onLSOPlayerBufferingUpdateListener) {
        this.mOnBufferingUpdateListener = onLSOPlayerBufferingUpdateListener;
    }

    public final void setOnSeekCompleteListener(OnLSOPlayerSeekCompleteListener onLSOPlayerSeekCompleteListener) {
        this.mOnSeekCompleteListener = onLSOPlayerSeekCompleteListener;
    }

    public final void setOnExactlySeekCompleteListener(OnLSOPlayerExactlySeekCompleteListener onLSOPlayerExactlySeekCompleteListener) {
        this.mOnExactlySeekCompleteListener = onLSOPlayerExactlySeekCompleteListener;
    }

    public void setOnPlayerFrameUpdateListener(OnLSOPlayeFrameUpdateListener onLSOPlayeFrameUpdateListener) {
        this.mOnPlayeFrameUpdateListener = onLSOPlayeFrameUpdateListener;
    }

    public final void setOnVideoSizeChangedListener(OnLSOPlayerVideoSizeChangedListener onLSOPlayerVideoSizeChangedListener) {
        this.mOnVideoSizeChangedListener = onLSOPlayerVideoSizeChangedListener;
    }

    public final void setOnErrorListener(OnLSOPlayerErrorListener onLSOPlayerErrorListener) {
        this.mOnErrorListener = onLSOPlayerErrorListener;
    }

    public final void setOnInfoListener(OnLSOPlayerInfoListener onLSOPlayerInfoListener) {
        this.mOnInfoListener = onLSOPlayerInfoListener;
    }

    protected final void notifyOnPrepared() {
        if (this.mOnPreparedListener != null) {
            this.mOnPreparedListener.onPrepared(this);
        }
    }

    protected final void notifyFrameUpdate(int n2) {
        if (this.mOnPlayeFrameUpdateListener != null) {
            this.mOnPlayeFrameUpdateListener.onFrameUpdate(this, n2);
        }
    }

    protected final void notifyOnCompletion() {
        if (this.mOnCompletionListener != null) {
            this.mOnCompletionListener.onCompletion(this);
        }
    }

    protected final void notifyOnBufferingUpdate(int n2) {
        if (this.mOnBufferingUpdateListener != null) {
            this.mOnBufferingUpdateListener.onBufferingUpdate(this, n2);
        }
    }

    protected final void notifyOnSeekComplete() {
        if (this.mOnSeekCompleteListener != null) {
            this.mOnSeekCompleteListener.onSeekComplete(this);
        }
    }

    protected final void notifyOnExactlySeekComplete() {
        if (this.mOnExactlySeekCompleteListener != null) {
            this.mOnExactlySeekCompleteListener.onExactlySeekComplete(this);
        }
    }

    protected final void notifyOnVideoSizeChanged(int n2, int n3, int n4, int n5) {
        if (this.mOnVideoSizeChangedListener != null) {
            this.mOnVideoSizeChangedListener.onVideoSizeChanged(this, n2, n3, n4, n5);
        }
    }

    protected final boolean notifyOnError(int n2, int n3) {
        return this.mOnErrorListener != null && this.mOnErrorListener.onError(this, n2, n3);
    }

    protected final boolean notifyOnInfo(int n2, int n3) {
        return this.mOnInfoListener != null && this.mOnInfoListener.onInfo(this, n2, n3);
    }

    public VideoPlayer() {
        this.initPlayer();
    }

    private void initPlayer() {
        VideoPlayer.initNativeOnce();
        Looper looper = Looper.myLooper();
        if (looper != null) {
            this.mEventHandler = new a(this, looper);
        } else {
            looper = Looper.getMainLooper();
            if (looper != null) {
                this.mEventHandler = new a(this, looper);
            } else {
                LSOLog.e("Unable to obtain the thread Looper, may not be able to send listener");
                this.mEventHandler = null;
            }
        }
        this.native_setup(new WeakReference<VideoPlayer>(this));
    }

    private native void _setVideoSurface(Surface var1);

    public void setDisplay(SurfaceHolder object) {
        this.mSurfaceHolder = object;
        object = object != null ? object.getSurface() : null;
        this._setVideoSurface((Surface)object);
        this.updateSurfaceScreenOn();
    }

    public void setSurface(Surface surface) {
        if (this.mScreenOnWhilePlaying && surface != null) {
            LSOLog.e("setScreenOnWhilePlaying(true) is ineffective for Surface");
        }
        this.mSurfaceHolder = null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, null);
    }

    public void setDataSource(Context context, Uri uri, Map<String, String> map) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String string = uri.getScheme();
        if ("file".equals(string)) {
            this.setDataSource(uri.getPath());
            return;
        }
        if ("content".equals(string) && "settings".equals(uri.getAuthority()) && (uri = RingtoneManager.getActualDefaultRingtoneUri((Context)context, (int)RingtoneManager.getDefaultType((Uri)uri))) == null) {
            throw new FileNotFoundException("Failed to resolve default ringtone");
        }
        string = null;
        try {
            string = context.getContentResolver().openAssetFileDescriptor(uri, "r");
            if (string == null) {
                return;
            }
            if (string.getDeclaredLength() < 0L) {
                this.setDataSource(string.getFileDescriptor());
            } else {
                this.setDataSource(string.getFileDescriptor(), string.getStartOffset(), string.getDeclaredLength());
            }
            return;
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (string != null) {
                string.close();
            }
        }
        this.setDataSource(uri.toString(), map);
    }

    public void setDataSource(String string) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mDataSource = string;
        this._setDataSource(string, null, null);
    }

    public void setDataSource(String string, Map<String, String> object) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        if (object != null && !object.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : object.entrySet()) {
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append(":");
                if (!TextUtils.isEmpty((CharSequence)((String)entry.getValue()))) {
                    stringBuilder.append((String)entry.getValue());
                }
                stringBuilder.append("\r\n");
                this.setOption(1, "headers", stringBuilder.toString());
            }
        }
        this.setDataSource(string);
    }

    public void setDataSource(FileDescriptor fileDescriptor) throws IOException, IllegalArgumentException, IllegalStateException {
        if (Build.VERSION.SDK_INT < 12) {
            int n2;
            try {
                Field field = fileDescriptor.getClass().getDeclaredField("descriptor");
                field.setAccessible(true);
                n2 = field.getInt(fileDescriptor);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            this._setDataSourceFd(n2);
            return;
        }
        fileDescriptor = ParcelFileDescriptor.dup((FileDescriptor)fileDescriptor);
        try {
            this._setDataSourceFd(fileDescriptor.getFd());
            return;
        }
        finally {
            fileDescriptor.close();
        }
    }

    private void setDataSource(FileDescriptor fileDescriptor, long l2, long l3) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(fileDescriptor);
    }

    public void setDataSource(IMediaDataSource iMediaDataSource) throws IllegalArgumentException, SecurityException, IllegalStateException {
        this._setDataSource(iMediaDataSource);
    }

    private native void _setDataSource(String var1, String[] var2, String[] var3) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    private native void _setDataSourceFd(int var1) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    private native void _setDataSource(IMediaDataSource var1) throws IllegalArgumentException, SecurityException, IllegalStateException;

    public String getDataSource() {
        return this.mDataSource;
    }

    public void prepareAsync() throws IllegalStateException {
        this._prepareAsync();
    }

    public native void _prepareAsync() throws IllegalStateException;

    public void start() throws IllegalStateException {
        this.stayAwake(true);
        this._start();
    }

    private native void _start() throws IllegalStateException;

    public void stop() throws IllegalStateException {
        this.stayAwake(false);
        this._stop();
    }

    private native void _stop() throws IllegalStateException;

    public void pause() throws IllegalStateException {
        this.stayAwake(false);
        LSOLog.d("native pause...");
        this._pause();
    }

    private native void _pause() throws IllegalStateException;

    public void setExactlySeekEnable(boolean bl2) {
        bl2 = bl2;
        this._setAccurateSeekEnable(bl2 ? 1 : 0, 5000);
    }

    public void setSpeed(float f2) {
        this._setSpeed(f2);
    }

    public void setAudioPitch(float f2) {
        this._setAudioPitch(f2);
    }

    public long getCurrentFramePosition() {
        return this.getCurrentVideoFramePts();
    }

    private native long getCurrentVideoFramePts();

    private native void _setAccurateSeekEnable(int var1, int var2);

    private native void _setSpeed(float var1);

    private native void _setAudioPitch(float var1);

    private native void _seekback100() throws IllegalStateException;

    private native void _seekfront100() throws IllegalStateException;

    public void setWakeMode(Context context, int n2) {
        boolean bl2 = false;
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                bl2 = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        context = (PowerManager)context.getSystemService("power");
        this.mWakeLock = context.newWakeLock(n2 | 0x20000000, VideoPlayer.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (bl2) {
            this.mWakeLock.acquire();
        }
    }

    public void setScreenOnWhilePlaying(boolean bl2) {
        if (this.mScreenOnWhilePlaying != bl2) {
            this.mScreenOnWhilePlaying = bl2;
            this.updateSurfaceScreenOn();
        }
    }

    private void stayAwake(boolean bl2) {
        if (this.mWakeLock != null) {
            if (bl2 && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!bl2 && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = bl2;
        this.updateSurfaceScreenOn();
    }

    private void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying && this.mStayAwake);
        }
    }

    public void selectTrack(int n2) {
        this._setStreamSelected(n2, true);
    }

    public void deselectTrack(int n2) {
        this._setStreamSelected(n2, false);
    }

    private native void _setStreamSelected(int var1, boolean var2);

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public int getVideoSarNum() {
        return this.mVideoSarNum;
    }

    public int getVideoSarDen() {
        return this.mVideoSarDen;
    }

    public native boolean isPlaying();

    public native void seekTo(long var1) throws IllegalStateException;

    public native long getCurrentPosition();

    public native long setLanSongPosition();

    public native long getDuration();

    public void release() {
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.resetListeners();
        this._release();
    }

    private native void _release();

    public void reset() {
        this.stayAwake(false);
        this._reset();
        this.mEventHandler.removeCallbacksAndMessages(null);
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
    }

    private native void _reset();

    public void setLooping(boolean bl2) {
        bl2 = !bl2;
        this.setOption(4, "loop", (long)bl2);
        this._setLoopCount(bl2 ? 1 : 0);
    }

    private native void _setLoopCount(int var1);

    public boolean isLooping() {
        return this._getLoopCount() != 1;
    }

    private native int _getLoopCount();

    public float getVideoOutputFramesPerSecond() {
        return this._getPropertyFloat(10002, 0.0f);
    }

    public float getVideoDecodeFramesPerSecond() {
        return this._getPropertyFloat(10001, 0.0f);
    }

    private native float _getPropertyFloat(int var1, float var2);

    private native void _setPropertyFloat(int var1, float var2);

    private native long _getPropertyLong(int var1, long var2);

    private native void _setPropertyLong(int var1, long var2);

    public native void setVolume(float var1, float var2);

    public native int getAudioSessionId();

    public void setLogEnabled(boolean bl2) {
    }

    public boolean isPlayable() {
        return true;
    }

    private native String _getVideoCodecInfo();

    private native String _getAudioCodecInfo();

    public void setOption(int n2, String string, String string2) {
        this._setOption(n2, string, string2);
    }

    public void setOption(int n2, String string, long l2) {
        this._setOption(n2, string, l2);
    }

    private native void _setOption(int var1, String var2, String var3);

    private native void _setOption(int var1, String var2, long var3);

    public Bundle getMediaMeta() {
        return this._getMediaMeta();
    }

    private native Bundle _getMediaMeta();

    public static String getColorFormatName(int n2) {
        return VideoPlayer._getColorFormatName(n2);
    }

    private static native String _getColorFormatName(int var0);

    private static native void native_init();

    private native void native_setup(Object var1);

    private native void native_finalize();

    private native void native_message_loop(Object var1);

    protected void finalize() throws Throwable {
        super.finalize();
        this.native_finalize();
    }

    private static void postEventFromNative(Object object, int n2, int n3, int n4, Object object2) {
        if (object == null) {
            return;
        }
        if ((object = (VideoPlayer)((WeakReference)object).get()) == null) {
            return;
        }
        if (n2 == 1) {
            ((VideoPlayer)object).isPrepared.set(true);
        }
        if (n2 == 200 && n3 == MEDIA_INFO_STARTED_AS_NEXT) {
            ((VideoPlayer)object).start();
        }
        if (((VideoPlayer)object).mEventHandler != null) {
            Message message = ((VideoPlayer)object).mEventHandler.obtainMessage(n2, n3, n4, object2);
            ((VideoPlayer)object).mEventHandler.sendMessage(message);
        }
    }

    public void setOnControlMessageListener(VideoPlayer$OnControlMessageListener videoPlayer$OnControlMessageListener) {
        this.mOnControlMessageListener = videoPlayer$OnControlMessageListener;
    }

    public void setOnNativeInvokeListener(VideoPlayer$OnNativeInvokeListener videoPlayer$OnNativeInvokeListener) {
        this.mOnNativeInvokeListener = videoPlayer$OnNativeInvokeListener;
    }

    private static boolean onNativeInvoke(Object object, int n2, Bundle bundle) {
        if (object == null || !(object instanceof WeakReference)) {
            throw new IllegalStateException("<null weakThiz>.onNativeInvoke()");
        }
        if ((object = (VideoPlayer)((WeakReference)object).get()) == null) {
            throw new IllegalStateException("<null weakPlayer>.onNativeInvoke()");
        }
        VideoPlayer$OnNativeInvokeListener videoPlayer$OnNativeInvokeListener = ((VideoPlayer)object).mOnNativeInvokeListener;
        if (videoPlayer$OnNativeInvokeListener != null && videoPlayer$OnNativeInvokeListener.onNativeInvoke(n2, bundle)) {
            return true;
        }
        switch (n2) {
            case 65536: {
                object = ((VideoPlayer)object).mOnControlMessageListener;
                if (object == null) {
                    return false;
                }
                n2 = bundle.getInt("segment_index", -1);
                if (n2 < 0) {
                    throw new InvalidParameterException("onNativeInvoke(invalid segment index)");
                }
                if ((object = object.onControlResolveSegmentUrl(n2)) == null) {
                    throw new RuntimeException(new IOException("onNativeInvoke() = <NULL newUrl>"));
                }
                bundle.putString("url", (String)object);
                return true;
            }
        }
        return false;
    }

    public void resetListeners() {
        this.mOnPreparedListener = null;
        this.mOnBufferingUpdateListener = null;
        this.mOnCompletionListener = null;
        this.mOnSeekCompleteListener = null;
        this.mOnVideoSizeChangedListener = null;
        this.mOnErrorListener = null;
        this.mOnInfoListener = null;
    }

    public static native void native_profileBegin(String var0);

    public static native void native_profileEnd();

    public static native void native_setLogLevel(int var0);

    static /* synthetic */ long access$000(VideoPlayer videoPlayer) {
        return videoPlayer.mNativeMediaPlayer;
    }

    static /* synthetic */ void access$100(VideoPlayer videoPlayer, boolean bl2) {
        videoPlayer.stayAwake(bl2);
    }

    static /* synthetic */ int access$202(VideoPlayer videoPlayer, int n2) {
        videoPlayer.mVideoWidth = n2;
        return videoPlayer.mVideoWidth;
    }

    static /* synthetic */ int access$302(VideoPlayer videoPlayer, int n2) {
        videoPlayer.mVideoHeight = n2;
        return videoPlayer.mVideoHeight;
    }

    static /* synthetic */ int access$200(VideoPlayer videoPlayer) {
        return videoPlayer.mVideoWidth;
    }

    static /* synthetic */ int access$300(VideoPlayer videoPlayer) {
        return videoPlayer.mVideoHeight;
    }

    static /* synthetic */ int access$400(VideoPlayer videoPlayer) {
        return videoPlayer.mVideoSarNum;
    }

    static /* synthetic */ int access$500(VideoPlayer videoPlayer) {
        return videoPlayer.mVideoSarDen;
    }

    static /* synthetic */ int access$402(VideoPlayer videoPlayer, int n2) {
        videoPlayer.mVideoSarNum = n2;
        return videoPlayer.mVideoSarNum;
    }

    static /* synthetic */ int access$502(VideoPlayer videoPlayer, int n2) {
        videoPlayer.mVideoSarDen = n2;
        return videoPlayer.mVideoSarDen;
    }
}

