/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.box;

import com.lansosdk.box.LSOLog;
import java.io.File;

public class BoxMediaInfo {
    public final String filePath;
    public final String fileName;
    public final String fileSuffix;
    public final long fileLength;
    public int vHeight;
    public int vWidth;
    public int vCodecHeight;
    public int vCodecWidth;
    public int vBitRate;
    public int vTotalFrames;
    public float vDuration;
    public float vFrameRate;
    public float vRotateAngle;
    public boolean vHasBFrame;
    public String vCodecName;
    public String vPixelFmt;
    public int aSampleRate;
    public int aChannels;
    public int aTotalFrames;
    public int aBitRate;
    public int aMaxBitRate;
    public float aDuration;
    public String aCodecName;
    private boolean getSuccess = false;
    private boolean isPngFile;

    public BoxMediaInfo(String object) {
        this.filePath = object;
        this.fileName = this.getFileNameFromPath((String)object);
        this.fileSuffix = this.getFileSuffix((String)object);
        if (object != null) {
            this.fileLength = ((File)(object = new File((String)object))).exists() ? ((File)object).length() : 0L;
            this.isPngFile = "png".equalsIgnoreCase(this.fileSuffix);
            return;
        }
        this.fileLength = 0L;
    }

    protected long getAudioDurationUs() {
        return (long)(this.aDuration * 1000.0f * 1000.0f);
    }

    public static boolean isSupport(String string) {
        if (BoxMediaInfo.fileExist(string)) {
            return new BoxMediaInfo(string).prepare();
        }
        LSOLog.i("video:" + string + " not support");
        return false;
    }

    private static boolean fileExist(String string) {
        if (string == null) {
            return false;
        }
        return new File(string).exists();
    }

    public boolean prepare() {
        if (BoxMediaInfo.fileExist(this.filePath)) {
            BoxMediaInfo boxMediaInfo = this;
            if (boxMediaInfo.nativePrepare(boxMediaInfo.filePath, false) >= 0) {
                this.getSuccess = true;
                return this.isSupport();
            }
            LSOLog.e("media info prepare media is failed:" + this.filePath);
            return false;
        }
        LSOLog.e("info prepare error . file is may be not exist:" + this.filePath);
        return false;
    }

    public void release() {
        this.getSuccess = false;
    }

    public int getWidth() {
        if (this.getSuccess) {
            if (this.vRotateAngle == 90.0f || this.vRotateAngle == 270.0f) {
                return this.vHeight;
            }
            return this.vWidth;
        }
        return 0;
    }

    public int getHeight() {
        if (this.getSuccess) {
            if (this.vRotateAngle == 90.0f || this.vRotateAngle == 270.0f) {
                return this.vWidth;
            }
            return this.vHeight;
        }
        return 0;
    }

    public boolean hasAudio() {
        if (this.aBitRate > 0) {
            if (this.aChannels == 0) {
                return false;
            }
            return this.aCodecName != null && !this.aCodecName.isEmpty() && this.aDuration != 0.0f;
        }
        return false;
    }

    protected static String checkFileReturnString(String object) {
        object = new BoxMediaInfo((String)object);
        ((BoxMediaInfo)object).prepare();
        return ((BoxMediaInfo)object).toString();
    }

    public boolean hasVideo() {
        if (this.isPngFile && this.vWidth > 0 && this.vHeight > 0) {
            return true;
        }
        if (this.vBitRate > 0 || this.vWidth > 0 || this.vHeight > 0) {
            if (this.vHeight == 0 || this.vWidth == 0) {
                return false;
            }
            if (this.vCodecHeight == 0 || this.vCodecWidth == 0) {
                return false;
            }
            if (this.vCodecName == null || this.vCodecName.isEmpty()) {
                return false;
            }
            return !(this.vDuration < 0.0f) || !"mp4".equalsIgnoreCase(this.fileSuffix) && !"mov".equalsIgnoreCase(this.fileSuffix) && !"flv".equalsIgnoreCase(this.fileSuffix);
        }
        return false;
    }

    public boolean isSupport() {
        return this.hasAudio() || this.hasVideo();
    }

    public boolean isPortVideo() {
        return this.getHeight() > this.getWidth();
    }

    public long getDurationUs() {
        if (this.vDuration > 0.0f) {
            return (long)(this.vDuration * 1000.0f * 1000.0f);
        }
        if (this.aDuration > 0.0f) {
            return (long)(this.aDuration * 1000.0f * 1000.0f);
        }
        return 1000000L;
    }

    public long getFrameIntervalUs() {
        if (this.vFrameRate > 0.0f) {
            return (long)(1000000.0f / this.vFrameRate);
        }
        return 40000L;
    }

    public String toString() {
        String string = "file name:" + this.filePath + "\n";
        string = string + "fileName:" + this.fileName + "\n";
        string = string + "fileSuffix:" + this.fileSuffix + "\n";
        string = string + "vHeight:" + this.vHeight + "\n";
        string = string + "vWidth:" + this.vWidth + "\n";
        string = string + "vCodecHeight:" + this.vCodecHeight + "\n";
        string = string + "vCodecWidth:" + this.vCodecWidth + "\n";
        string = string + "vBitRate:" + this.vBitRate + "\n";
        string = string + "vTotalFrames:" + this.vTotalFrames + "\n";
        string = string + "vDuration:" + this.vDuration + "\n";
        string = string + "vFrameRate:" + this.vFrameRate + "\n";
        string = string + "vRotateAngle:" + this.vRotateAngle + "\n";
        string = string + "vHasBFrame:" + this.vHasBFrame + "\n";
        string = string + "vCodecName:" + this.vCodecName + "\n";
        string = string + "vPixelFmt:" + this.vPixelFmt + "\n";
        string = string + "aSampleRate:" + this.aSampleRate + "\n";
        string = string + "aChannels:" + this.aChannels + "\n";
        string = string + "aTotalFrames:" + this.aTotalFrames + "\n";
        string = string + "aBitRate:" + this.aBitRate + "\n";
        string = string + "aMaxBitRate:" + this.aMaxBitRate + "\n";
        string = string + "aDuration:" + this.aDuration + "\n";
        return string + "aCodecName:" + this.aCodecName + "\n";
    }

    public native int nativePrepare(String var1, boolean var2);

    public native int nativePrepare2(String var1, boolean var2);

    private void setVideoCodecName(String string) {
        this.vCodecName = string;
    }

    private void setVideoPixelFormat(String string) {
        this.vPixelFmt = string;
    }

    private void setAudioCodecName(String string) {
        this.aCodecName = string;
    }

    private String getFileNameFromPath(String string) {
        if (string == null) {
            return "";
        }
        int n2 = string.lastIndexOf(47);
        if (n2 >= 0) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    private String getFileSuffix(String string) {
        if (string == null) {
            return "";
        }
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            return string.substring(n2 + 1);
        }
        return "";
    }

    public static void checkFileLSDELETE(String string) {
        if (string == null) {
            string = "\u6587\u4ef6\u540d\u4e3a\u7a7a\u6307\u9488, null";
        } else {
            File file = new File(string);
            if (!file.exists()) {
                string = "\u6587\u4ef6\u4e0d\u5b58\u5728,".concat(String.valueOf(string));
            } else if (file.isDirectory()) {
                string = "\u60a8\u8bbe\u7f6e\u7684\u8def\u5f84\u662f\u4e00\u4e2a\u6587\u4ef6\u5939,".concat(String.valueOf(string));
            } else if (file.length() == 0L) {
                string = "\u6587\u4ef6\u5b58\u5728,\u4f46\u6587\u4ef6\u7684\u5927\u5c0f\u4e3a0\u5b57\u8282(\u53ef\u80fd\u60a8\u53ea\u521b\u5efa\u6587\u4ef6,\u4f46\u6ca1\u6709\u8fdb\u884c\u5404\u79cd\u8c03\u7528\u8bbe\u7f6e\u5bfc\u81f4\u7684.).".concat(String.valueOf(string));
            } else {
                BoxMediaInfo boxMediaInfo = new BoxMediaInfo(string);
                if (boxMediaInfo.fileSuffix.equals("pcm") || boxMediaInfo.fileSuffix.equals("yuv")) {
                    String string2 = "\u6587\u4ef6\u8def\u5f84:" + boxMediaInfo.filePath + "\n";
                    string2 = string2 + "\u6587\u4ef6\u540d:" + boxMediaInfo.fileName + "\n";
                    string2 = string2 + "\u6587\u4ef6\u540e\u7f00:" + boxMediaInfo.fileSuffix + "\n";
                    string2 = string2 + "\u6587\u4ef6\u5927\u5c0f(\u5b57\u8282):" + file.length() + "\n";
                    string = "\u6587\u4ef6\u5b58\u5728,\u4f46\u6587\u4ef6\u7684\u540e\u7f00\u53ef\u80fd\u8868\u793a\u662f\u88f8\u6570\u636e,\u6211\u4eec\u7684SDK\u9700\u8981\u591a\u5a92\u4f53\u683c\u5f0f\u7684\u540e\u7f00\u662fmp4/mp3/wav/aac/m4a/mov/gif\u5e38\u89c1\u683c\u5f0f";
                    string = string + string2;
                } else if (boxMediaInfo.prepare()) {
                    string = "\u6587\u4ef6\u5185\u7684\u4fe1\u606f\u662f:\n";
                    String string3 = "\u6587\u4ef6\u8def\u5f84:" + boxMediaInfo.filePath + "\n";
                    string3 = string3 + "\u6587\u4ef6\u540d:" + boxMediaInfo.fileName + "\n";
                    string3 = string3 + "\u6587\u4ef6\u540e\u7f00:" + boxMediaInfo.fileSuffix + "\n";
                    string3 = string3 + "\u6587\u4ef6\u5927\u5c0f(\u5b57\u8282):" + file.length() + "\n";
                    if (boxMediaInfo.hasVideo()) {
                        string3 = string3 + "\u89c6\u9891\u4fe1\u606f-----:\n";
                        string3 = string3 + "\u5bbd\u5ea6:" + boxMediaInfo.vWidth + "\n";
                        string3 = string3 + "\u9ad8\u5ea6:" + boxMediaInfo.vHeight + "\n";
                        string3 = string3 + "\u7f16\u7801\u5bbd\u5ea6:" + boxMediaInfo.vCodecWidth + "\n";
                        string3 = string3 + "\u7f16\u7801\u9ad8\u5ea6:" + boxMediaInfo.vCodecHeight + "\n";
                        string3 = string3 + "\u65f6\u957f:" + boxMediaInfo.vDuration + "\n";
                        string3 = string3 + "\u5e27\u7387:" + boxMediaInfo.vFrameRate + "\n";
                        string3 = string3 + "\u7801\u7387:" + boxMediaInfo.vBitRate + "\n";
                        string3 = string3 + "\u603b\u5e27\u6570:" + boxMediaInfo.vTotalFrames + "\n";
                        string3 = string3 + "\u65cb\u8f6c\u89d2\u5ea6:" + boxMediaInfo.vRotateAngle + "\n";
                        string3 = string3 + "\u7f16\u7801\u5668\u540d\u5b57:" + boxMediaInfo.vCodecName + "\n";
                        string3 = string3 + "\u662f\u5426\u6709B\u5e27:" + boxMediaInfo.vHasBFrame + "\n";
                        string3 = string3 + "\u50cf\u7d20\u683c\u5f0f:" + boxMediaInfo.vPixelFmt + "\n";
                    } else {
                        string3 = string3 + "<\u65e0\u89c6\u9891\u4fe1\u606f>\n";
                    }
                    if (boxMediaInfo.hasAudio()) {
                        string3 = string3 + "\u97f3\u9891\u4fe1\u606f-----:\n";
                        string3 = string3 + "\u91c7\u6837\u7387:" + boxMediaInfo.aSampleRate + "\n";
                        string3 = string3 + "\u901a\u9053\u6570:" + boxMediaInfo.aChannels + "\n";
                        string3 = string3 + "\u7801\u7387:" + boxMediaInfo.aBitRate + "\n";
                        string3 = string3 + "\u65f6\u957f:" + boxMediaInfo.aDuration + "\n";
                        string3 = string3 + "\u7f16\u7801\u5668:" + boxMediaInfo.aCodecName + "\n";
                    } else {
                        string3 = string3 + "<\u65e0\u97f3\u9891\u4fe1\u606f>\n";
                    }
                    string = string + string3;
                } else {
                    string = "\u6587\u4ef6\u5b58\u5728, \u4f46MediaInfo.prepare\u83b7\u53d6\u5a92\u4f53\u4fe1\u606f\u5931\u8d25,\u8bf7\u67e5\u770b\u4e0b \u6587\u4ef6\u662f\u5426\u662f\u97f3\u9891\u6216\u89c6\u9891, \u6216\u8bb8\u6f14\u793a\u5de5\u7a0bAPP\u540d\u5b57\u4e0d\u662f\u6211\u4eecdemo\u4e2d\u7684\u540d\u5b57:".concat(String.valueOf(string));
                }
            }
        }
        LSOLog.i("\u5f53\u524d\u6587\u4ef6\u7684\u97f3\u89c6\u9891\u4fe1\u606f\u662f:".concat(String.valueOf(string)));
    }
}

