/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.LanSongFilter;

import com.lansosdk.LanSongFilter.LanSongFilter;
import com.lansosdk.box.bZ;

public class LanSongWhiteBalanceFilter
extends LanSongFilter {
    public static final String WHITE_BALANCE_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n \nuniform lowp float temperature;\nuniform lowp float tint;\n\nconst lowp vec3 warmFilter = vec3(0.93, 0.54, 0.0);\n\nconst mediump mat3 RGBtoYIQ = mat3(0.299, 0.587, 0.114, 0.596, -0.274, -0.322, 0.212, -0.523, 0.311);\nconst mediump mat3 YIQtoRGB = mat3(1.0, 0.956, 0.621, 1.0, -0.272, -0.647, 1.0, -1.105, 1.702);\n\nvoid main()\n{\n\tlowp vec4 source = texture2D(inputImageTexture, textureCoordinate);\n\t\n\tmediump vec3 yiq = RGBtoYIQ * source.rgb; //adjusting tint\n\tyiq.b = clamp(yiq.b + tint*0.5226*0.1, -0.5226, 0.5226);\n\tlowp vec3 rgb = YIQtoRGB * yiq;\n\n\tlowp vec3 processed = vec3(\n\t\t(rgb.r < 0.5 ? (2.0 * rgb.r * warmFilter.r) : (1.0 - 2.0 * (1.0 - rgb.r) * (1.0 - warmFilter.r))), //adjusting temperature\n\t\t(rgb.g < 0.5 ? (2.0 * rgb.g * warmFilter.g) : (1.0 - 2.0 * (1.0 - rgb.g) * (1.0 - warmFilter.g))), \n\t\t(rgb.b < 0.5 ? (2.0 * rgb.b * warmFilter.b) : (1.0 - 2.0 * (1.0 - rgb.b) * (1.0 - warmFilter.b))));\n\n\tgl_FragColor = vec4(mix(rgb, processed, temperature), source.a);\n}";
    private int a;
    private float b;
    private int c;
    private float d;
    public float minTintValue = -200.0f;
    public float defaultTintValue = 0.0f;
    public float maxTintValue = 200.0f;
    public float minTemperatureValue = 0.0f;
    public float defaultTemperatureValue = 5000.0f;
    public float maxTemperatureValue = 15000.0f;

    public LanSongWhiteBalanceFilter() {
        this(5000.0f, 0.0f);
    }

    public LanSongWhiteBalanceFilter(float f2, float f3) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nattribute vec4 inputTextureCoordinate2;\n \nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n    textureCoordinate2 = inputTextureCoordinate2.xy;\n}", WHITE_BALANCE_FRAGMENT_SHADER);
        this.b = f2;
        this.d = f3;
    }

    @Override
    public String getFragmentShader() {
        return WHITE_BALANCE_FRAGMENT_SHADER;
    }

    @Override
    public void onInit(int n2) {
        super.onInit(n2);
        this.a = bZ.glGetUniformLocation((int)this.getProgram(), (String)"temperature");
        this.c = bZ.glGetUniformLocation((int)this.getProgram(), (String)"tint");
        LanSongWhiteBalanceFilter lanSongWhiteBalanceFilter = this;
        lanSongWhiteBalanceFilter.setTemperature(lanSongWhiteBalanceFilter.b);
        LanSongWhiteBalanceFilter lanSongWhiteBalanceFilter2 = this;
        lanSongWhiteBalanceFilter2.setTint(lanSongWhiteBalanceFilter2.d);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.a = bZ.glGetUniformLocation((int)this.getProgram(), (String)"temperature");
        this.c = bZ.glGetUniformLocation((int)this.getProgram(), (String)"tint");
        LanSongWhiteBalanceFilter lanSongWhiteBalanceFilter = this;
        lanSongWhiteBalanceFilter.setTemperature(lanSongWhiteBalanceFilter.b);
        LanSongWhiteBalanceFilter lanSongWhiteBalanceFilter2 = this;
        lanSongWhiteBalanceFilter2.setTint(lanSongWhiteBalanceFilter2.d);
    }

    public void setTemperature(float f2) {
        this.b = f2;
        LanSongWhiteBalanceFilter lanSongWhiteBalanceFilter = this;
        lanSongWhiteBalanceFilter.setFloat(lanSongWhiteBalanceFilter.a, this.b < 5000.0f ? (float)(4.0E-4 * ((double)this.b - 5000.0)) : (float)(6.0E-5 * ((double)this.b - 5000.0)));
    }

    public void setTint(float f2) {
        this.d = f2;
        LanSongWhiteBalanceFilter lanSongWhiteBalanceFilter = this;
        lanSongWhiteBalanceFilter.setFloat(lanSongWhiteBalanceFilter.c, (float)((double)this.d / 100.0));
    }

    public float getTemperature() {
        return this.b;
    }

    public float getTint() {
        return this.d;
    }
}

