/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.LanSongFilter;

import com.lansosdk.LanSongFilter.LanSong3x3TextureSamplingFilter;
import com.lansosdk.box.bZ;

public class LanSongToonFilter
extends LanSong3x3TextureSamplingFilter {
    public static final String TOON_FRAGMENT_SHADER = "varying vec2 textureCoordinate;\nvarying vec2 leftTextureCoordinate;\nvarying vec2 rightTextureCoordinate;\n\nvarying vec2 topTextureCoordinate;\nvarying vec2 topLeftTextureCoordinate;\nvarying vec2 topRightTextureCoordinate;\n\nvarying vec2 bottomTextureCoordinate;\nvarying vec2 bottomLeftTextureCoordinate;\nvarying vec2 bottomRightTextureCoordinate;\n\n\nuniform mediump float intensity;\nuniform mediump float threshold;\nuniform mediump float quantizationLevels;\n\nconst highp vec3 W = vec3(0.2125, 0.7154, 0.0721);\n\nvoid main()\n{\nvec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n\nfloat bottomLeftIntensity = texture2D(inputImageTexture, bottomLeftTextureCoordinate).r;\nfloat topRightIntensity = texture2D(inputImageTexture, topRightTextureCoordinate).r;\nfloat topLeftIntensity = texture2D(inputImageTexture, topLeftTextureCoordinate).r;\nfloat bottomRightIntensity = texture2D(inputImageTexture, bottomRightTextureCoordinate).r;\nfloat leftIntensity = texture2D(inputImageTexture, leftTextureCoordinate).r;\nfloat rightIntensity = texture2D(inputImageTexture, rightTextureCoordinate).r;\nfloat bottomIntensity = texture2D(inputImageTexture, bottomTextureCoordinate).r;\nfloat topIntensity = texture2D(inputImageTexture, topTextureCoordinate).r;\nfloat h = -topLeftIntensity - 2.0 * topIntensity - topRightIntensity + bottomLeftIntensity + 2.0 * bottomIntensity + bottomRightIntensity;\nfloat v = -bottomLeftIntensity - 2.0 * leftIntensity - topLeftIntensity + bottomRightIntensity + 2.0 * rightIntensity + topRightIntensity;\n\nfloat mag = length(vec2(h, v));\n\nvec3 posterizedImageColor = floor((textureColor.rgb * quantizationLevels) + 0.5) / quantizationLevels;\n\nfloat thresholdTest = 1.0 - step(threshold, mag);\n\ngl_FragColor = vec4(posterizedImageColor * thresholdTest, textureColor.a);\n}\n";
    private float a;
    private int b;
    private float c;
    private int d;

    public LanSongToonFilter() {
        this(0.2f, 10.0f);
    }

    public LanSongToonFilter(float f2, float f3) {
        super(TOON_FRAGMENT_SHADER);
        this.a = f2;
        this.c = f3;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"threshold");
        this.d = bZ.glGetUniformLocation((int)this.getProgram(), (String)"quantizationLevels");
    }

    @Override
    public void onInit(int n2) {
        super.onInit(n2);
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"threshold");
        this.d = bZ.glGetUniformLocation((int)this.getProgram(), (String)"quantizationLevels");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        LanSongToonFilter lanSongToonFilter = this;
        lanSongToonFilter.setThreshold(lanSongToonFilter.a);
        LanSongToonFilter lanSongToonFilter2 = this;
        lanSongToonFilter2.setQuantizationLevels(lanSongToonFilter2.c);
    }

    public void setThreshold(float f2) {
        this.a = f2;
        LanSongToonFilter lanSongToonFilter = this;
        lanSongToonFilter.setFloat(lanSongToonFilter.b, f2);
    }

    public float getThreshold() {
        return this.a;
    }

    public void setQuantizationLevels(float f2) {
        this.c = f2;
        LanSongToonFilter lanSongToonFilter = this;
        lanSongToonFilter.setFloat(lanSongToonFilter.d, f2);
    }

    public float getQuantizationLevels() {
        return this.c;
    }
}

