/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.LanSongFilter;

import android.content.Context;
import com.lansosdk.LanSongFilter.LanSongFilter;
import com.lansosdk.box.bZ;

public class LanSongSketchFilter
extends LanSongFilter {
    private int a;
    private int b;
    private Context c;

    public LanSongSketchFilter(Context context) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nattribute vec4 inputTextureCoordinate2;\n \nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n    textureCoordinate2 = inputTextureCoordinate2.xy;\n}", "varying highp vec2 textureCoordinate;\nuniform vec2 singleStepOffset;\nuniform float strength;\n\nconst highp vec3 W = vec3(0.299,0.587,0.114);\n\n\nvoid main()\n{ \n\tfloat threshold = 0.0;\n\t//pic1\n\tvec4 oralColor = texture2D(inputImageTexture, textureCoordinate);\n\t\n\t//pic2\n\tvec3 maxValue = vec3(0.,0.,0.);\n\t\n\tfor(int i = -2;i<=2; i++)\n\t{\n\t\tfor(int j = -2; j<=2; j++)\n\t\t{\n\t\t\tvec4 tempColor = texture2D(inputImageTexture, textureCoordinate+singleStepOffset*vec2(i,j));\n\t\t\tmaxValue.r = max(maxValue.r,tempColor.r);\n\t\t\tmaxValue.g = max(maxValue.g,tempColor.g);\n\t\t\tmaxValue.b = max(maxValue.b,tempColor.b);\n\t\t\tthreshold += dot(tempColor.rgb, W);\n\t\t}\n\t}\n\t//pic3\n\tfloat gray1 = dot(oralColor.rgb, W);\n\t\n\t//pic4\n\tfloat gray2 = dot(maxValue, W);\n\t\n\t//pic5\n\tfloat contour = gray1 / gray2;\n\t\n\tthreshold = threshold / 25.;\n\tfloat alpha = max(strength,gray1>threshold?1.0:(gray1/threshold));\n\t\n\tfloat result = contour * alpha + (1.0-alpha)*gray1;\n\t\n\tgl_FragColor = vec4(vec3(result,result,result), oralColor.w);\n}");
        this.c = context;
    }

    @Override
    public void onInit(int n2) {
        super.onInit(n2);
        this.a = bZ.glGetUniformLocation((int)this.getProgram(), (String)"singleStepOffset");
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"strength");
        LanSongSketchFilter lanSongSketchFilter = this;
        lanSongSketchFilter.setFloat(lanSongSketchFilter.b, 0.5f);
    }

    @Override
    public void onOutputSizeChanged(int n2, int n3) {
        super.onOutputSizeChanged(n2, n3);
        LanSongSketchFilter lanSongSketchFilter = this;
        float f2 = n3;
        float f3 = n2;
        lanSongSketchFilter.setFloatVec2(lanSongSketchFilter.a, new float[]{1.0f / f3, 1.0f / f2});
    }
}

