/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.LanSongFilter;

import com.lansosdk.LanSongFilter.LanSongFilter;
import com.lansosdk.box.bZ;

public class LanSongSharpenFilter
extends LanSongFilter {
    public static final String kLanSongSharpenVertexShaderString = " attribute vec4 position;\n     attribute vec4 inputTextureCoordinate;\n\n     uniform float imageWidthFactor;\n     uniform float imageHeightFactor;\n     uniform float sharpness;\n\n     varying vec2 textureCoordinate;\n     varying vec2 leftTextureCoordinate;\n     varying vec2 rightTextureCoordinate;\n     varying vec2 topTextureCoordinate;\n     varying vec2 bottomTextureCoordinate;\n\n     varying float centerMultiplier;\n     varying float edgeMultiplier;\n\n     void main()\n{\ngl_Position = position;\n\nvec2 widthStep = vec2(imageWidthFactor, 0.0);\nvec2 heightStep = vec2(0.0, imageHeightFactor);\n\ntextureCoordinate = inputTextureCoordinate.xy;\nleftTextureCoordinate = inputTextureCoordinate.xy - widthStep;\nrightTextureCoordinate = inputTextureCoordinate.xy + widthStep;\ntopTextureCoordinate = inputTextureCoordinate.xy + heightStep;\nbottomTextureCoordinate = inputTextureCoordinate.xy - heightStep;\n\ncenterMultiplier = 1.0 + 4.0 * sharpness;\nedgeMultiplier = sharpness;\n}\n";
    public static final String kLanSongSharpenFragmentShaderString = " precision highp float;\n\n     varying highp vec2 textureCoordinate;\n     varying highp vec2 leftTextureCoordinate;\n     varying highp vec2 rightTextureCoordinate;\n     varying highp vec2 topTextureCoordinate;\n     varying highp vec2 bottomTextureCoordinate;\n\n     varying highp float centerMultiplier;\n     varying highp float edgeMultiplier;\n\n\n     void main()\n {\n mediump vec3 textureColor = texture2D(inputImageTexture, textureCoordinate).rgb;\n mediump vec3 leftTextureColor = texture2D(inputImageTexture, leftTextureCoordinate).rgb;\n mediump vec3 rightTextureColor = texture2D(inputImageTexture, rightTextureCoordinate).rgb;\n mediump vec3 topTextureColor = texture2D(inputImageTexture, topTextureCoordinate).rgb;\n mediump vec3 bottomTextureColor = texture2D(inputImageTexture, bottomTextureCoordinate).rgb;\n\n gl_FragColor = vec4((textureColor * centerMultiplier - (leftTextureColor * edgeMultiplier + rightTextureColor * edgeMultiplier + topTextureColor * edgeMultiplier + bottomTextureColor * edgeMultiplier)), texture2D(inputImageTexture, bottomTextureCoordinate).w);\n }\n";
    private int a;
    private int b;
    private int c;
    public float minValue;
    public float maxValue;
    public float defaultValue;
    private float d;

    public LanSongSharpenFilter() {
        super(kLanSongSharpenVertexShaderString, kLanSongSharpenFragmentShaderString);
    }

    @Override
    public String getFragmentShader() {
        return kLanSongSharpenFragmentShaderString;
    }

    @Override
    public void onInit(int n2) {
        super.onInit(n2);
        this.a = bZ.glGetUniformLocation((int)this.getProgram(), (String)"sharpness");
        this.d = 0.0f;
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"imageWidthFactor");
        this.c = bZ.glGetUniformLocation((int)this.getProgram(), (String)"imageHeightFactor");
        this.minValue = -4.0f;
        this.maxValue = 4.0f;
        this.defaultValue = 0.0f;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.a = bZ.glGetUniformLocation((int)this.getProgram(), (String)"sharpness");
        this.d = 0.0f;
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"imageWidthFactor");
        this.c = bZ.glGetUniformLocation((int)this.getProgram(), (String)"imageHeightFactor");
        this.minValue = -4.0f;
        this.maxValue = 4.0f;
        this.defaultValue = 0.0f;
    }

    @Override
    public void onOutputSizeChanged(int n2, int n3) {
        super.onOutputSizeChanged(n2, n3);
        LanSongSharpenFilter lanSongSharpenFilter = this;
        lanSongSharpenFilter.setFloat(lanSongSharpenFilter.b, 1.0f / (float)n2);
        LanSongSharpenFilter lanSongSharpenFilter2 = this;
        lanSongSharpenFilter2.setFloat(lanSongSharpenFilter2.c, 1.0f / (float)n2);
    }

    public void setSharpness(float f2) {
        this.d = f2;
        LanSongSharpenFilter lanSongSharpenFilter = this;
        lanSongSharpenFilter.setFloat(lanSongSharpenFilter.a, f2);
    }
}

