/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.LanSongFilter;

import com.lansosdk.LanSongFilter.LanSongFilter;
import com.lansosdk.box.bZ;

public class LanSongSaturationFilter
extends LanSongFilter {
    public static final String SATURATION_FRAGMENT_SHADER = " varying highp vec2 textureCoordinate;\n \n uniform lowp float saturation;\n \n // Values from \"Graphics Shaders: Theory and Practice\" by Bailey and Cunningham\n const mediump vec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);\n \n void main()\n {\n    lowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n    lowp float luminance = dot(textureColor.rgb, luminanceWeighting);\n    lowp vec3 greyScaleColor = vec3(luminance);\n    \n    gl_FragColor = vec4(mix(greyScaleColor, textureColor.rgb, saturation), textureColor.w);\n     \n }";
    private int a;
    private float b;
    public float minValue = 0.0f;
    public float defaultValue = 1.0f;
    public float maxValue = 2.0f;

    public LanSongSaturationFilter() {
        this(1.0f);
    }

    public LanSongSaturationFilter(float f2) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nattribute vec4 inputTextureCoordinate2;\n \nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n    textureCoordinate2 = inputTextureCoordinate2.xy;\n}", SATURATION_FRAGMENT_SHADER);
        this.b = f2;
    }

    @Override
    public String getFragmentShader() {
        return SATURATION_FRAGMENT_SHADER;
    }

    @Override
    public void onInit(int n2) {
        super.onInit(n2);
        this.a = bZ.glGetUniformLocation((int)this.getProgram(), (String)"saturation");
    }

    @Override
    public void onInit() {
        super.onInit();
        this.a = bZ.glGetUniformLocation((int)this.getProgram(), (String)"saturation");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        LanSongSaturationFilter lanSongSaturationFilter = this;
        lanSongSaturationFilter.setSaturation(lanSongSaturationFilter.b);
    }

    public void setSaturation(float f2) {
        this.b = f2;
        LanSongSaturationFilter lanSongSaturationFilter = this;
        lanSongSaturationFilter.setFloat(lanSongSaturationFilter.a, this.b);
    }

    public float getSaturation() {
        return this.b;
    }
}

