/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.LanSongFilter;

import com.lansosdk.LanSongFilter.LanSongFilter;
import com.lansosdk.box.bZ;

public class LanSongHueFilter
extends LanSongFilter {
    public static final String HUE_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform mediump float hueAdjust;\nconst highp vec4 kRGBToYPrime = vec4 (0.299, 0.587, 0.114, 0.0);\nconst highp vec4 kRGBToI = vec4 (0.595716, -0.274453, -0.321263, 0.0);\nconst highp vec4 kRGBToQ = vec4 (0.211456, -0.522591, 0.31135, 0.0);\n\nconst highp vec4 kYIQToR = vec4 (1.0, 0.9563, 0.6210, 0.0);\nconst highp vec4 kYIQToG = vec4 (1.0, -0.2721, -0.6474, 0.0);\nconst highp vec4 kYIQToB = vec4 (1.0, -1.1070, 1.7046, 0.0);\n\nvoid main ()\n{\n    // Sample the input pixel\n    highp vec4 color = texture2D(inputImageTexture, textureCoordinate);\n\n    // Convert to YIQ\n    highp float YPrime = dot (color, kRGBToYPrime);\n    highp float I = dot (color, kRGBToI);\n    highp float Q = dot (color, kRGBToQ);\n\n    // Calculate the hue and chroma\n    highp float hue = atan (Q, I);\n    highp float chroma = sqrt (I * I + Q * Q);\n\n    // Make the user's adjustments\n    hue += (-hueAdjust); //why negative rotation?\n\n    // Convert back to YIQ\n    Q = chroma * sin (hue);\n    I = chroma * cos (hue);\n\n    // Convert back to RGB\n    highp vec4 yIQ = vec4 (YPrime, I, Q, 0.0);\n    color.r = dot (yIQ, kYIQToR);\n    color.g = dot (yIQ, kYIQToG);\n    color.b = dot (yIQ, kYIQToB);\n\n    // Save the result\n    gl_FragColor = color;\n}\n";
    private float a;
    private int b;
    public float minValue = 0.0f;
    public float maxValue = 360.0f;
    public float defaultValue = 90.0f;

    public LanSongHueFilter() {
        this(90.0f);
    }

    public LanSongHueFilter(float f2) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nattribute vec4 inputTextureCoordinate2;\n \nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n    textureCoordinate2 = inputTextureCoordinate2.xy;\n}", HUE_FRAGMENT_SHADER);
        this.a = f2;
    }

    @Override
    public String getFragmentShader() {
        return HUE_FRAGMENT_SHADER;
    }

    @Override
    public void onInit(int n2) {
        super.onInit(n2);
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"hueAdjust");
    }

    @Override
    public void onInit() {
        super.onInit();
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"hueAdjust");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        LanSongHueFilter lanSongHueFilter = this;
        lanSongHueFilter.setHue(lanSongHueFilter.a);
    }

    public void setHue(float f2) {
        this.a = f2;
        f2 = this.a % 360.0f * (float)Math.PI / 180.0f;
        LanSongHueFilter lanSongHueFilter = this;
        lanSongHueFilter.setFloat(lanSongHueFilter.b, f2);
    }

    public float getHue() {
        return this.a;
    }
}

