/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.LanSongFilter;

import com.lansosdk.LanSongFilter.LanSongTwoInputFilter;
import com.lansosdk.box.bZ;

public class LanSongChromaKeyBlendFilter
extends LanSongTwoInputFilter {
    public static final String CHROMA_KEY_BLEND_FRAGMENT_SHADER = " varying highp vec2 textureCoordinate;\n varying highp vec2 textureCoordinate2;\n\n uniform float thresholdSensitivity;\n uniform float smoothing;\n uniform vec3 colorToReplace;\n uniform sampler2D inputImageTexture2;\n \n void main()\n {\n     vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n     vec4 textureColor2 = texture2D(inputImageTexture2, textureCoordinate2);\n     \n     float maskY = 0.2989 * colorToReplace.r + 0.5866 * colorToReplace.g + 0.1145 * colorToReplace.b;\n     float maskCr = 0.7132 * (colorToReplace.r - maskY);\n     float maskCb = 0.5647 * (colorToReplace.b - maskY);\n     \n     float Y = 0.2989 * textureColor.r + 0.5866 * textureColor.g + 0.1145 * textureColor.b;\n     float Cr = 0.7132 * (textureColor.r - Y);\n     float Cb = 0.5647 * (textureColor.b - Y);\n     \n     float blendValue = 1.0 - smoothstep(thresholdSensitivity, thresholdSensitivity + smoothing, distance(vec2(Cr, Cb), vec2(maskCr, maskCb)));\n     gl_FragColor = mix(textureColor, textureColor2, blendValue);\n }";
    private int a;
    private int b;
    private int c;
    private float d = 0.1f;
    private float e = 0.3f;
    private float[] f = new float[]{0.0f, 1.0f, 0.0f};

    public LanSongChromaKeyBlendFilter() {
        super(CHROMA_KEY_BLEND_FRAGMENT_SHADER);
    }

    @Override
    public void onInit(int n2) {
        super.onInit(n2);
        this.a = bZ.glGetUniformLocation((int)this.getProgram(), (String)"thresholdSensitivity");
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"smoothing");
        this.c = bZ.glGetUniformLocation((int)this.getProgram(), (String)"colorToReplace");
    }

    @Override
    public void onInit() {
        super.onInit();
        this.a = bZ.glGetUniformLocation((int)this.getProgram(), (String)"thresholdSensitivity");
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"smoothing");
        this.c = bZ.glGetUniformLocation((int)this.getProgram(), (String)"colorToReplace");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        LanSongChromaKeyBlendFilter lanSongChromaKeyBlendFilter = this;
        lanSongChromaKeyBlendFilter.setSmoothing(lanSongChromaKeyBlendFilter.d);
        LanSongChromaKeyBlendFilter lanSongChromaKeyBlendFilter2 = this;
        lanSongChromaKeyBlendFilter2.setThresholdSensitivity(lanSongChromaKeyBlendFilter2.e);
        LanSongChromaKeyBlendFilter lanSongChromaKeyBlendFilter3 = this;
        lanSongChromaKeyBlendFilter3.setColorToReplace(lanSongChromaKeyBlendFilter3.f[0], this.f[1], this.f[2]);
    }

    public void setSmoothing(float f2) {
        this.d = f2;
        LanSongChromaKeyBlendFilter lanSongChromaKeyBlendFilter = this;
        lanSongChromaKeyBlendFilter.setFloat(lanSongChromaKeyBlendFilter.b, this.d);
    }

    public void setThresholdSensitivity(float f2) {
        this.e = f2;
        LanSongChromaKeyBlendFilter lanSongChromaKeyBlendFilter = this;
        lanSongChromaKeyBlendFilter.setFloat(lanSongChromaKeyBlendFilter.a, this.e);
    }

    public void setColorToReplace(float f2, float f3, float f4) {
        this.f = new float[]{f2, f3, f4};
        LanSongChromaKeyBlendFilter lanSongChromaKeyBlendFilter = this;
        lanSongChromaKeyBlendFilter.setFloatVec3(lanSongChromaKeyBlendFilter.c, this.f);
    }

    public float getThresholdSensitivity() {
        return this.e;
    }

    public float getSmoothing() {
        return this.d;
    }

    public float[] getColorToReplace() {
        return this.f;
    }
}

