/**
  * Win32 UTF-8 wrapper
  *
  * ----
  *
  * Redefinition of Windows message IDs as an enum for debugger visibility.
  */

typedef enum MESSAGEID {
#undef WM_NULL
       WM_NULL = 0x0000,
#undef WM_CREATE
       WM_CREATE = 0x0001,
#undef WM_DESTROY
       WM_DESTROY = 0x0002,
#undef WM_MOVE
       WM_MOVE = 0x0003,
#undef WM_SIZE
       WM_SIZE = 0x0005,

#undef WM_ACTIVATE
       WM_ACTIVATE = 0x0006,

#undef WM_SETFOCUS
       WM_SETFOCUS = 0x0007,
#undef WM_KILLFOCUS
       WM_KILLFOCUS = 0x0008,
#undef WM_ENABLE
       WM_ENABLE = 0x000A,
#undef WM_SETREDRAW
       WM_SETREDRAW = 0x000B,
#undef WM_SETTEXT
       WM_SETTEXT = 0x000C,
#undef WM_GETTEXT
       WM_GETTEXT = 0x000D,
#undef WM_GETTEXTLENGTH
       WM_GETTEXTLENGTH = 0x000E,
#undef WM_PAINT
       WM_PAINT = 0x000F,
#undef WM_CLOSE
       WM_CLOSE = 0x0010,
#undef WM_QUERYENDSESSION
       WM_QUERYENDSESSION = 0x0011,
#undef WM_QUIT
       WM_QUIT = 0x0012,
#undef WM_QUERYOPEN
       WM_QUERYOPEN = 0x0013,
#undef WM_ERASEBKGND
       WM_ERASEBKGND = 0x0014,
#undef WM_SYSCOLORCHANGE
       WM_SYSCOLORCHANGE = 0x0015,
#undef WM_ENDSESSION
       WM_ENDSESSION = 0x0016,
#undef WM_SHOWWINDOW
       WM_SHOWWINDOW = 0x0018,
#undef WM_WININICHANGE
       WM_WININICHANGE = 0x001A,
#undef WM_SETTINGCHANGE
       WM_SETTINGCHANGE = WM_WININICHANGE,

#undef WM_DEVMODECHANGE
       WM_DEVMODECHANGE = 0x001B,
#undef WM_ACTIVATEAPP
       WM_ACTIVATEAPP = 0x001C,
#undef WM_FONTCHANGE
       WM_FONTCHANGE = 0x001D,
#undef WM_TIMECHANGE
       WM_TIMECHANGE = 0x001E,
#undef WM_CANCELMODE
       WM_CANCELMODE = 0x001F,
#undef WM_SETCURSOR
       WM_SETCURSOR = 0x0020,
#undef WM_MOUSEACTIVATE
       WM_MOUSEACTIVATE = 0x0021,
#undef WM_CHILDACTIVATE
       WM_CHILDACTIVATE = 0x0022,
#undef WM_QUEUESYNC
       WM_QUEUESYNC = 0x0023,

#undef WM_GETMINMAXINFO
       WM_GETMINMAXINFO = 0x0024,

#undef WM_PAINTICON
       WM_PAINTICON = 0x0026,
#undef WM_ICONERASEBKGND
       WM_ICONERASEBKGND = 0x0027,
#undef WM_NEXTDLGCTL
       WM_NEXTDLGCTL = 0x0028,
#undef WM_SPOOLERSTATUS
       WM_SPOOLERSTATUS = 0x002A,
#undef WM_DRAWITEM
       WM_DRAWITEM = 0x002B,
#undef WM_MEASUREITEM
       WM_MEASUREITEM = 0x002C,
#undef WM_DELETEITEM
       WM_DELETEITEM = 0x002D,
#undef WM_VKEYTOITEM
       WM_VKEYTOITEM = 0x002E,
#undef WM_CHARTOITEM
       WM_CHARTOITEM = 0x002F,
#undef WM_SETFONT
       WM_SETFONT = 0x0030,
#undef WM_GETFONT
       WM_GETFONT = 0x0031,
#undef WM_SETHOTKEY
       WM_SETHOTKEY = 0x0032,
#undef WM_GETHOTKEY
       WM_GETHOTKEY = 0x0033,
#undef WM_QUERYDRAGICON
       WM_QUERYDRAGICON = 0x0037,
#undef WM_COMPAREITEM
       WM_COMPAREITEM = 0x0039,
#undef WM_GETOBJECT
       WM_GETOBJECT = 0x003D,
#undef WM_COMPACTING
       WM_COMPACTING = 0x0041,
#undef WM_COMMNOTIFY
       WM_COMMNOTIFY = 0x0044, // no longer suported
#undef WM_WINDOWPOSCHANGING
       WM_WINDOWPOSCHANGING = 0x0046,
#undef WM_WINDOWPOSCHANGED
       WM_WINDOWPOSCHANGED = 0x0047,

#undef WM_POWER
       WM_POWER = 0x0048,

#undef WM_COPYDATA
       WM_COPYDATA = 0x004A,
#undef WM_CANCELJOURNAL
       WM_CANCELJOURNAL = 0x004B,

// If WM_NOTIFY isn't defined, Richedit.h redefines the NMHDR structure.
//#undef WM_NOTIFY
//       WM_NOTIFY = 0x004E,
#undef WM_INPUTLANGCHANGEREQUEST
       WM_INPUTLANGCHANGEREQUEST = 0x0050,
#undef WM_INPUTLANGCHANGE
       WM_INPUTLANGCHANGE = 0x0051,
#undef WM_TCARD
       WM_TCARD = 0x0052,
#undef WM_HELP
       WM_HELP = 0x0053,
#undef WM_USERCHANGED
       WM_USERCHANGED = 0x0054,
#undef WM_NOTIFYFORMAT
       WM_NOTIFYFORMAT = 0x0055,

#undef WM_CONTEXTMENU
       WM_CONTEXTMENU = 0x007B,
#undef WM_STYLECHANGING
       WM_STYLECHANGING = 0x007C,
#undef WM_STYLECHANGED
       WM_STYLECHANGED = 0x007D,
#undef WM_DISPLAYCHANGE
       WM_DISPLAYCHANGE = 0x007E,
#undef WM_GETICON
       WM_GETICON = 0x007F,
#undef WM_SETICON
       WM_SETICON = 0x0080,

#undef WM_NCCREATE
       WM_NCCREATE = 0x0081,
#undef WM_NCDESTROY
       WM_NCDESTROY = 0x0082,
#undef WM_NCCALCSIZE
       WM_NCCALCSIZE = 0x0083,
#undef WM_NCHITTEST
       WM_NCHITTEST = 0x0084,
#undef WM_NCPAINT
       WM_NCPAINT = 0x0085,
#undef WM_NCACTIVATE
       WM_NCACTIVATE = 0x0086,
#undef WM_GETDLGCODE
       WM_GETDLGCODE = 0x0087,
#undef WM_SYNCPAINT
       WM_SYNCPAINT = 0x0088,
#undef WM_NCMOUSEMOVE
       WM_NCMOUSEMOVE = 0x00A0,
#undef WM_NCLBUTTONDOWN
       WM_NCLBUTTONDOWN = 0x00A1,
#undef WM_NCLBUTTONUP
       WM_NCLBUTTONUP = 0x00A2,
#undef WM_NCLBUTTONDBLCLK
       WM_NCLBUTTONDBLCLK = 0x00A3,
#undef WM_NCRBUTTONDOWN
       WM_NCRBUTTONDOWN = 0x00A4,
#undef WM_NCRBUTTONUP
       WM_NCRBUTTONUP = 0x00A5,
#undef WM_NCRBUTTONDBLCLK
       WM_NCRBUTTONDBLCLK = 0x00A6,
#undef WM_NCMBUTTONDOWN
       WM_NCMBUTTONDOWN = 0x00A7,
#undef WM_NCMBUTTONUP
       WM_NCMBUTTONUP = 0x00A8,
#undef WM_NCMBUTTONDBLCLK
       WM_NCMBUTTONDBLCLK = 0x00A9,

#undef WM_NCXBUTTONDOWN
       WM_NCXBUTTONDOWN = 0x00AB,
#undef WM_NCXBUTTONUP
       WM_NCXBUTTONUP = 0x00AC,
#undef WM_NCXBUTTONDBLCLK
       WM_NCXBUTTONDBLCLK = 0x00AD,

       // Edit control messages
#undef EM_GETSEL
       EM_GETSEL = 0x00B0,
#undef EM_SETSEL
       EM_SETSEL = 0x00B1,
#undef EM_GETRECT
       EM_GETRECT = 0x00B2,
#undef EM_SETRECT
       EM_SETRECT = 0x00B3,
#undef EM_SETRECTNP
       EM_SETRECTNP = 0x00B4,
#undef EM_SCROLL
       EM_SCROLL = 0x00B5,
#undef EM_LINESCROLL
       EM_LINESCROLL = 0x00B6,
#undef EM_SCROLLCARET
       EM_SCROLLCARET = 0x00B7,
#undef EM_GETMODIFY
       EM_GETMODIFY = 0x00B8,
#undef EM_SETMODIFY
       EM_SETMODIFY = 0x00B9,
#undef EM_GETLINECOUNT
       EM_GETLINECOUNT = 0x00BA,
#undef EM_LINEINDEX
       EM_LINEINDEX = 0x00BB,
#undef EM_SETHANDLE
       EM_SETHANDLE = 0x00BC,
#undef EM_GETHANDLE
       EM_GETHANDLE = 0x00BD,
#undef EM_GETTHUMB
       EM_GETTHUMB = 0x00BE,
#undef EM_LINELENGTH
       EM_LINELENGTH = 0x00C1,
#undef EM_REPLACESEL
       EM_REPLACESEL = 0x00C2,
#undef EM_GETLINE
       EM_GETLINE = 0x00C4,
#undef EM_LIMITTEXT
       EM_LIMITTEXT = 0x00C5,
#undef EM_CANUNDO
       EM_CANUNDO = 0x00C6,
#undef EM_UNDO
       EM_UNDO = 0x00C7,
#undef EM_FMTLINES
       EM_FMTLINES = 0x00C8,
#undef EM_LINEFROMCHAR
       EM_LINEFROMCHAR = 0x00C9,
#undef EM_SETTABSTOPS
       EM_SETTABSTOPS = 0x00CB,
#undef EM_SETPASSWORDCHAR
       EM_SETPASSWORDCHAR = 0x00CC,
#undef EM_EMPTYUNDOBUFFER
       EM_EMPTYUNDOBUFFER = 0x00CD,
#undef EM_GETFIRSTVISIBLELINE
       EM_GETFIRSTVISIBLELINE = 0x00CE,
#undef EM_SETREADONLY
       EM_SETREADONLY = 0x00CF,
#undef EM_SETWORDBREAKPROC
       EM_SETWORDBREAKPROC = 0x00D0,
#undef EM_GETWORDBREAKPROC
       EM_GETWORDBREAKPROC = 0x00D1,
#undef EM_GETPASSWORDCHAR
       EM_GETPASSWORDCHAR = 0x00D2,
#undef EM_SETMARGINS
       EM_SETMARGINS = 0x00D3,
#undef EM_GETMARGINS
       EM_GETMARGINS = 0x00D4,
#undef EM_SETLIMITTEXT
       EM_SETLIMITTEXT = EM_LIMITTEXT,
#undef EM_GETLIMITTEXT
       EM_GETLIMITTEXT = 0x00D5,
#undef EM_POSFROMCHAR
       EM_POSFROMCHAR = 0x00D6,
#undef EM_CHARFROMPOS
       EM_CHARFROMPOS = 0x00D7,
#undef EM_SETIMESTATUS
       EM_SETIMESTATUS = 0x00D8,
#undef EM_GETIMESTATUS
       EM_GETIMESTATUS = 0x00D9,

       // Scroll bar messages
#undef SBM_SETPOS
       SBM_SETPOS = 0x00E0,
#undef SBM_GETPOS
       SBM_GETPOS = 0x00E1,
#undef SBM_SETRANGE
       SBM_SETRANGE = 0x00E2,
#undef SBM_GETRANGE
       SBM_GETRANGE = 0x00E3,
#undef SBM_ENABLE_ARROWS
       SBM_ENABLE_ARROWS = 0x00E4,
#undef SBM_SETRANGEREDRAW
       SBM_SETRANGEREDRAW = 0x00E6,
#undef SBM_SETSCROLLINFO
       SBM_SETSCROLLINFO = 0x00E9,
#undef SBM_GETSCROLLINFO
       SBM_GETSCROLLINFO = 0x00EA,
#undef SBM_GETSCROLLBARINFO
       SBM_GETSCROLLBARINFO = 0x00EB,

#undef BM_GETCHECK
       BM_GETCHECK = 0x00F0,
#undef BM_SETCHECK
       BM_SETCHECK = 0x00F1,
#undef BM_GETSTATE
       BM_GETSTATE = 0x00F2,
#undef BM_SETSTATE
       BM_SETSTATE = 0x00F3,
#undef BM_SETSTYLE
       BM_SETSTYLE = 0x00F4,
#undef BM_CLICK
       BM_CLICK = 0x00F5,
#undef BM_GETIMAGE
       BM_GETIMAGE = 0x00F6,
#undef BM_SETIMAGE
       BM_SETIMAGE = 0x00F7,
#undef BM_SETDONTCLICK
       BM_SETDONTCLICK = 0x00F8,

#undef WM_INPUT_DEVICE_CHANGE
       WM_INPUT_DEVICE_CHANGE = 0x00FE,
#undef WM_INPUT
       WM_INPUT = 0x00FF,

#undef WM_KEYDOWN
       WM_KEYDOWN = 0x0100,
#undef WM_KEYUP
       WM_KEYUP = 0x0101,
#undef WM_CHAR
       WM_CHAR = 0x0102,
#undef WM_DEADCHAR
       WM_DEADCHAR = 0x0103,
#undef WM_SYSKEYDOWN
       WM_SYSKEYDOWN = 0x0104,
#undef WM_SYSKEYUP
       WM_SYSKEYUP = 0x0105,
#undef WM_SYSCHAR
       WM_SYSCHAR = 0x0106,
#undef WM_SYSDEADCHAR
       WM_SYSDEADCHAR = 0x0107,
#undef WM_UNICHAR
       WM_UNICHAR = 0x0109,
#undef WM_IME_STARTCOMPOSITION
       WM_IME_STARTCOMPOSITION = 0x010D,
#undef WM_IME_ENDCOMPOSITION
       WM_IME_ENDCOMPOSITION = 0x010E,
#undef WM_IME_COMPOSITION
       WM_IME_COMPOSITION = 0x010F,

#undef WM_INITDIALOG
       WM_INITDIALOG = 0x0110,
#undef WM_COMMAND
       WM_COMMAND = 0x0111,
#undef WM_SYSCOMMAND
       WM_SYSCOMMAND = 0x0112,
#undef WM_TIMER
       WM_TIMER = 0x0113,
#undef WM_HSCROLL
       WM_HSCROLL = 0x0114,
#undef WM_VSCROLL
       WM_VSCROLL = 0x0115,
#undef WM_INITMENU
       WM_INITMENU = 0x0116,
#undef WM_INITMENUPOPUP
       WM_INITMENUPOPUP = 0x0117,
#undef WM_GESTURE
       WM_GESTURE = 0x0119,
#undef WM_GESTURENOTIFY
       WM_GESTURENOTIFY = 0x011A,
#undef WM_MENUSELECT
       WM_MENUSELECT = 0x011F,
#undef WM_MENUCHAR
       WM_MENUCHAR = 0x0120,
#undef WM_ENTERIDLE
       WM_ENTERIDLE = 0x0121,
#undef WM_MENURBUTTONUP
       WM_MENURBUTTONUP = 0x0122,
#undef WM_MENUDRAG
       WM_MENUDRAG = 0x0123,
#undef WM_MENUGETOBJECT
       WM_MENUGETOBJECT = 0x0124,
#undef WM_UNINITMENUPOPUP
       WM_UNINITMENUPOPUP = 0x0125,
#undef WM_MENUCOMMAND
       WM_MENUCOMMAND = 0x0126,

#undef WM_CHANGEUISTATE
       WM_CHANGEUISTATE = 0x0127,
#undef WM_UPDATEUISTATE
       WM_UPDATEUISTATE = 0x0128,
#undef WM_QUERYUISTATE
       WM_QUERYUISTATE = 0x0129,

#undef WM_CTLCOLORMSGBOX
       WM_CTLCOLORMSGBOX = 0x0132,
#undef WM_CTLCOLOREDIT
       WM_CTLCOLOREDIT = 0x0133,
#undef WM_CTLCOLORLISTBOX
       WM_CTLCOLORLISTBOX = 0x0134,
#undef WM_CTLCOLORBTN
       WM_CTLCOLORBTN = 0x0135,
#undef WM_CTLCOLORDLG
       WM_CTLCOLORDLG = 0x0136,
#undef WM_CTLCOLORSCROLLBAR
       WM_CTLCOLORSCROLLBAR = 0x0137,
#undef WM_CTLCOLORSTATIC
       WM_CTLCOLORSTATIC = 0x0138,

#undef CB_GETEDITSEL
       CB_GETEDITSEL = 0x0140,
#undef CB_LIMITTEXT
       CB_LIMITTEXT = 0x0141,
#undef CB_SETEDITSEL
       CB_SETEDITSEL = 0x0142,
#undef CB_ADDSTRING
       CB_ADDSTRING = 0x0143,
#undef CB_DELETESTRING
       CB_DELETESTRING = 0x0144,
#undef CB_DIR
       CB_DIR = 0x0145,
#undef CB_GETCOUNT
       CB_GETCOUNT = 0x0146,
#undef CB_GETCURSEL
       CB_GETCURSEL = 0x0147,
#undef CB_GETLBTEXT
       CB_GETLBTEXT = 0x0148,
#undef CB_GETLBTEXTLEN
       CB_GETLBTEXTLEN = 0x0149,
#undef CB_INSERTSTRING
       CB_INSERTSTRING = 0x014A,
#undef CB_RESETCONTENT
       CB_RESETCONTENT = 0x014B,
#undef CB_FINDSTRING
       CB_FINDSTRING = 0x014C,
#undef CB_SELECTSTRING
       CB_SELECTSTRING = 0x014D,
#undef CB_SETCURSEL
       CB_SETCURSEL = 0x014E,
#undef CB_SHOWDROPDOWN
       CB_SHOWDROPDOWN = 0x014F,
#undef CB_GETITEMDATA
       CB_GETITEMDATA = 0x0150,
#undef CB_SETITEMDATA
       CB_SETITEMDATA = 0x0151,
#undef CB_GETDROPPEDCONTROLRECT
       CB_GETDROPPEDCONTROLRECT = 0x0152,
#undef CB_SETITEMHEIGHT
       CB_SETITEMHEIGHT = 0x0153,
#undef CB_GETITEMHEIGHT
       CB_GETITEMHEIGHT = 0x0154,
#undef CB_SETEXTENDEDUI
       CB_SETEXTENDEDUI = 0x0155,
#undef CB_GETEXTENDEDUI
       CB_GETEXTENDEDUI = 0x0156,
#undef CB_GETDROPPEDSTATE
       CB_GETDROPPEDSTATE = 0x0157,
#undef CB_FINDSTRINGEXACT
       CB_FINDSTRINGEXACT = 0x0158,
#undef CB_SETLOCALE
       CB_SETLOCALE = 0x0159,
#undef CB_GETLOCALE
       CB_GETLOCALE = 0x015A,
#undef CB_GETTOPINDEX
       CB_GETTOPINDEX = 0x015b,
#undef CB_SETTOPINDEX
       CB_SETTOPINDEX = 0x015c,
#undef CB_GETHORIZONTALEXTENT
       CB_GETHORIZONTALEXTENT = 0x015d,
#undef CB_SETHORIZONTALEXTENT
       CB_SETHORIZONTALEXTENT = 0x015e,
#undef CB_GETDROPPEDWIDTH
       CB_GETDROPPEDWIDTH = 0x015f,
#undef CB_SETDROPPEDWIDTH
       CB_SETDROPPEDWIDTH = 0x0160,
#undef CB_INITSTORAGE
       CB_INITSTORAGE = 0x0161,
#undef CB_MULTIPLEADDSTRING
       CB_MULTIPLEADDSTRING = 0x0163,
#undef CB_GETCOMBOBOXINFO
       CB_GETCOMBOBOXINFO = 0x0164,

#undef MN_GETHMENU
       MN_GETHMENU = 0x01E1,

       // Listbox messages
#undef LB_ADDSTRING
       LB_ADDSTRING = 0x0180,
#undef LB_INSERTSTRING
       LB_INSERTSTRING = 0x0181,
#undef LB_DELETESTRING
       LB_DELETESTRING = 0x0182,
#undef LB_SELITEMRANGEEX
       LB_SELITEMRANGEEX = 0x0183,
#undef LB_RESETCONTENT
       LB_RESETCONTENT = 0x0184,
#undef LB_SETSEL
       LB_SETSEL = 0x0185,
#undef LB_SETCURSEL
       LB_SETCURSEL = 0x0186,
#undef LB_GETSEL
       LB_GETSEL = 0x0187,
#undef LB_GETCURSEL
       LB_GETCURSEL = 0x0188,
#undef LB_GETTEXT
       LB_GETTEXT = 0x0189,
#undef LB_GETTEXTLEN
       LB_GETTEXTLEN = 0x018A,
#undef LB_GETCOUNT
       LB_GETCOUNT = 0x018B,
#undef LB_SELECTSTRING
       LB_SELECTSTRING = 0x018C,
#undef LB_DIR
       LB_DIR = 0x018D,
#undef LB_GETTOPINDEX
       LB_GETTOPINDEX = 0x018E,
#undef LB_FINDSTRING
       LB_FINDSTRING = 0x018F,
#undef LB_GETSELCOUNT
       LB_GETSELCOUNT = 0x0190,
#undef LB_GETSELITEMS
       LB_GETSELITEMS = 0x0191,
#undef LB_SETTABSTOPS
       LB_SETTABSTOPS = 0x0192,
#undef LB_GETHORIZONTALEXTENT
       LB_GETHORIZONTALEXTENT = 0x0193,
#undef LB_SETHORIZONTALEXTENT
       LB_SETHORIZONTALEXTENT = 0x0194,
#undef LB_SETCOLUMNWIDTH
       LB_SETCOLUMNWIDTH = 0x0195,
#undef LB_ADDFILE
       LB_ADDFILE = 0x0196,
#undef LB_SETTOPINDEX
       LB_SETTOPINDEX = 0x0197,
#undef LB_GETITEMRECT
       LB_GETITEMRECT = 0x0198,
#undef LB_GETITEMDATA
       LB_GETITEMDATA = 0x0199,
#undef LB_SETITEMDATA
       LB_SETITEMDATA = 0x019A,
#undef LB_SELITEMRANGE
       LB_SELITEMRANGE = 0x019B,
#undef LB_SETANCHORINDEX
       LB_SETANCHORINDEX = 0x019C,
#undef LB_GETANCHORINDEX
       LB_GETANCHORINDEX = 0x019D,
#undef LB_SETCARETINDEX
       LB_SETCARETINDEX = 0x019E,
#undef LB_GETCARETINDEX
       LB_GETCARETINDEX = 0x019F,
#undef LB_SETITEMHEIGHT
       LB_SETITEMHEIGHT = 0x01A0,
#undef LB_GETITEMHEIGHT
       LB_GETITEMHEIGHT = 0x01A1,
#undef LB_FINDSTRINGEXACT
       LB_FINDSTRINGEXACT = 0x01A2,
#undef LB_SETLOCALE
       LB_SETLOCALE = 0x01A5,
#undef LB_GETLOCALE
       LB_GETLOCALE = 0x01A6,
#undef LB_SETCOUNT
       LB_SETCOUNT = 0x01A7,
#undef LB_INITSTORAGE
       LB_INITSTORAGE = 0x01A8,
#undef LB_ITEMFROMPOINT
       LB_ITEMFROMPOINT = 0x01A9,
#undef LB_MULTIPLEADDSTRING
       LB_MULTIPLEADDSTRING = 0x01B1,
#undef LB_GETLISTBOXINFO
       LB_GETLISTBOXINFO = 0x01B2,
#undef LB_MSGMAX
       LB_MSGMAX = 0x01B3,

#undef WM_MOUSEMOVE
       WM_MOUSEMOVE = 0x0200,
#undef WM_LBUTTONDOWN
       WM_LBUTTONDOWN = 0x0201,
#undef WM_LBUTTONUP
       WM_LBUTTONUP = 0x0202,
#undef WM_LBUTTONDBLCLK
       WM_LBUTTONDBLCLK = 0x0203,
#undef WM_RBUTTONDOWN
       WM_RBUTTONDOWN = 0x0204,
#undef WM_RBUTTONUP
       WM_RBUTTONUP = 0x0205,
#undef WM_RBUTTONDBLCLK
       WM_RBUTTONDBLCLK = 0x0206,
#undef WM_MBUTTONDOWN
       WM_MBUTTONDOWN = 0x0207,
#undef WM_MBUTTONUP
       WM_MBUTTONUP = 0x0208,
#undef WM_MBUTTONDBLCLK
       WM_MBUTTONDBLCLK = 0x0209,
#undef WM_MOUSEWHEEL
       WM_MOUSEWHEEL = 0x020A,
#undef WM_XBUTTONDOWN
       WM_XBUTTONDOWN = 0x020B,
#undef WM_XBUTTONUP
       WM_XBUTTONUP = 0x020C,
#undef WM_XBUTTONDBLCLK
       WM_XBUTTONDBLCLK = 0x020D,
#undef WM_MOUSEHWHEEL
       WM_MOUSEHWHEEL = 0x020E,

#undef WM_PARENTNOTIFY
       WM_PARENTNOTIFY = 0x0210,
#undef WM_ENTERMENULOOP
       WM_ENTERMENULOOP = 0x0211,
#undef WM_EXITMENULOOP
       WM_EXITMENULOOP = 0x0212,

#undef WM_NEXTMENU
       WM_NEXTMENU = 0x0213,
#undef WM_SIZING
       WM_SIZING = 0x0214,
#undef WM_CAPTURECHANGED
       WM_CAPTURECHANGED = 0x0215,
#undef WM_MOVING
       WM_MOVING = 0x0216,

#undef WM_POWERBROADCAST
       WM_POWERBROADCAST = 0x0218,

#undef WM_DEVICECHANGE
       WM_DEVICECHANGE = 0x0219,

#undef WM_MDICREATE
       WM_MDICREATE = 0x0220,
#undef WM_MDIDESTROY
       WM_MDIDESTROY = 0x0221,
#undef WM_MDIACTIVATE
       WM_MDIACTIVATE = 0x0222,
#undef WM_MDIRESTORE
       WM_MDIRESTORE = 0x0223,
#undef WM_MDINEXT
       WM_MDINEXT = 0x0224,
#undef WM_MDIMAXIMIZE
       WM_MDIMAXIMIZE = 0x0225,
#undef WM_MDITILE
       WM_MDITILE = 0x0226,
#undef WM_MDICASCADE
       WM_MDICASCADE = 0x0227,
#undef WM_MDIICONARRANGE
       WM_MDIICONARRANGE = 0x0228,
#undef WM_MDIGETACTIVE
       WM_MDIGETACTIVE = 0x0229,

#undef WM_MDISETMENU
       WM_MDISETMENU = 0x0230,
#undef WM_ENTERSIZEMOVE
       WM_ENTERSIZEMOVE = 0x0231,
#undef WM_EXITSIZEMOVE
       WM_EXITSIZEMOVE = 0x0232,
#undef WM_DROPFILES
       WM_DROPFILES = 0x0233,
#undef WM_MDIREFRESHMENU
       WM_MDIREFRESHMENU = 0x0234,

#undef WM_POINTERDEVICECHANGE
       WM_POINTERDEVICECHANGE = 0x238,
#undef WM_POINTERDEVICEINRANGE
       WM_POINTERDEVICEINRANGE = 0x239,
#undef WM_POINTERDEVICEOUTOFRANGE
       WM_POINTERDEVICEOUTOFRANGE = 0x23a,

#undef WM_TOUCH
       WM_TOUCH = 0x0240,

#undef WM_NCPOINTERUPDATE
       WM_NCPOINTERUPDATE = 0x0241,
#undef WM_NCPOINTERDOWN
       WM_NCPOINTERDOWN = 0x0242,
#undef WM_NCPOINTERUP
       WM_NCPOINTERUP = 0x0243,
#undef WM_POINTERUPDATE
       WM_POINTERUPDATE = 0x0245,
#undef WM_POINTERDOWN
       WM_POINTERDOWN = 0x0246,
#undef WM_POINTERUP
       WM_POINTERUP = 0x0247,
#undef WM_POINTERENTER
       WM_POINTERENTER = 0x0249,
#undef WM_POINTERLEAVE
       WM_POINTERLEAVE = 0x024A,
#undef WM_POINTERACTIVATE
       WM_POINTERACTIVATE = 0x024B,
#undef WM_POINTERCAPTURECHANGED
       WM_POINTERCAPTURECHANGED = 0x024C,
#undef WM_TOUCHHITTESTING
       WM_TOUCHHITTESTING = 0x024D,
#undef WM_POINTERWHEEL
       WM_POINTERWHEEL = 0x024E,
#undef WM_POINTERHWHEEL
       WM_POINTERHWHEEL = 0x024F,
#undef DM_POINTERHITTEST
       DM_POINTERHITTEST = 0x0250,

#undef WM_IME_SETCONTEXT
       WM_IME_SETCONTEXT = 0x0281,
#undef WM_IME_NOTIFY
       WM_IME_NOTIFY = 0x0282,
#undef WM_IME_CONTROL
       WM_IME_CONTROL = 0x0283,
#undef WM_IME_COMPOSITIONFULL
       WM_IME_COMPOSITIONFULL = 0x0284,
#undef WM_IME_SELECT
       WM_IME_SELECT = 0x0285,
#undef WM_IME_CHAR
       WM_IME_CHAR = 0x0286,
#undef WM_IME_REQUEST
       WM_IME_REQUEST = 0x0288,
#undef WM_IME_KEYDOWN
       WM_IME_KEYDOWN = 0x0290,
#undef WM_IME_KEYUP
       WM_IME_KEYUP = 0x0291,

#undef WM_NCMOUSEHOVER
       WM_NCMOUSEHOVER = 0x02A0,
#undef WM_MOUSEHOVER
       WM_MOUSEHOVER = 0x02A1,
#undef WM_NCMOUSELEAVE
       WM_NCMOUSELEAVE = 0x02A2,
#undef WM_MOUSELEAVE
       WM_MOUSELEAVE = 0x02A3,

#undef WM_WTSSESSION_CHANGE
       WM_WTSSESSION_CHANGE = 0x02B1,

#undef WM_CUT
       WM_CUT = 0x0300,
#undef WM_COPY
       WM_COPY = 0x0301,
#undef WM_PASTE
       WM_PASTE = 0x0302,
#undef WM_CLEAR
       WM_CLEAR = 0x0303,
#undef WM_UNDO
       WM_UNDO = 0x0304,
#undef WM_RENDERFORMAT
       WM_RENDERFORMAT = 0x0305,
#undef WM_RENDERALLFORMATS
       WM_RENDERALLFORMATS = 0x0306,
#undef WM_DESTROYCLIPBOARD
       WM_DESTROYCLIPBOARD = 0x0307,
#undef WM_DRAWCLIPBOARD
       WM_DRAWCLIPBOARD = 0x0308,
#undef WM_PAINTCLIPBOARD
       WM_PAINTCLIPBOARD = 0x0309,
#undef WM_VSCROLLCLIPBOARD
       WM_VSCROLLCLIPBOARD = 0x030A,
#undef WM_SIZECLIPBOARD
       WM_SIZECLIPBOARD = 0x030B,
#undef WM_ASKCBFORMATNAME
       WM_ASKCBFORMATNAME = 0x030C,
#undef WM_CHANGECBCHAIN
       WM_CHANGECBCHAIN = 0x030D,
#undef WM_HSCROLLCLIPBOARD
       WM_HSCROLLCLIPBOARD = 0x030E,
#undef WM_QUERYNEWPALETTE
       WM_QUERYNEWPALETTE = 0x030F,
#undef WM_PALETTEISCHANGING
       WM_PALETTEISCHANGING = 0x0310,
#undef WM_PALETTECHANGED
       WM_PALETTECHANGED = 0x0311,
#undef WM_HOTKEY
       WM_HOTKEY = 0x0312,

#undef WM_PRINT
       WM_PRINT = 0x0317,
#undef WM_PRINTCLIENT
       WM_PRINTCLIENT = 0x0318,

#undef WM_APPCOMMAND
       WM_APPCOMMAND = 0x0319,

#undef WM_THEMECHANGED
       WM_THEMECHANGED = 0x031A,

#undef WM_CLIPBOARDUPDATE
       WM_CLIPBOARDUPDATE = 0x031D,

#undef WM_DWMCOMPOSITIONCHANGED
       WM_DWMCOMPOSITIONCHANGED = 0x031E,
#undef WM_DWMNCRENDERINGCHANGED
       WM_DWMNCRENDERINGCHANGED = 0x031F,
#undef WM_DWMCOLORIZATIONCOLORCHANGED
       WM_DWMCOLORIZATIONCOLORCHANGED = 0x0320,
#undef WM_DWMWINDOWMAXIMIZEDCHANGE
       WM_DWMWINDOWMAXIMIZEDCHANGE = 0x0321,

#undef WM_DWMSENDICONICTHUMBNAIL
       WM_DWMSENDICONICTHUMBNAIL = 0x0323,
#undef WM_DWMSENDICONICLIVEPREVIEWBITMAP
       WM_DWMSENDICONICLIVEPREVIEWBITMAP = 0x0326,

#undef WM_GETTITLEBARINFOEX
       WM_GETTITLEBARINFOEX = 0x033F,

       // Multimedia window messages
       // joystick
#undef MM_JOY1MOVE
       MM_JOY1MOVE = 0x3A0,
#undef MM_JOY2MOVE
       MM_JOY2MOVE = 0x3A1,
#undef MM_JOY1ZMOVE
       MM_JOY1ZMOVE = 0x3A2,
#undef MM_JOY2ZMOVE
       MM_JOY2ZMOVE = 0x3A3,
#undef MM_JOY1BUTTONDOWN
       MM_JOY1BUTTONDOWN = 0x3B5,
#undef MM_JOY2BUTTONDOWN
       MM_JOY2BUTTONDOWN = 0x3B6,
#undef MM_JOY1BUTTONUP
       MM_JOY1BUTTONUP = 0x3B7,
#undef MM_JOY2BUTTONUP
       MM_JOY2BUTTONUP = 0x3B8,

       // MCI
#undef MM_MCINOTIFY
       MM_MCINOTIFY = 0x3B9,

       // waveform output
#undef MM_WOM_OPEN
       MM_WOM_OPEN = 0x3BB,
#undef MM_WOM_CLOSE
       MM_WOM_CLOSE = 0x3BC,
#undef MM_WOM_DONE
       MM_WOM_DONE = 0x3BD,

       // waveform input
#undef MM_WIM_OPEN
       MM_WIM_OPEN = 0x3BE,
#undef MM_WIM_CLOSE
       MM_WIM_CLOSE = 0x3BF,
#undef MM_WIM_DATA
       MM_WIM_DATA = 0x3C0,

       // MIDI input
#undef MM_MIM_OPEN
       MM_MIM_OPEN = 0x3C1,
#undef MM_MIM_CLOSE
       MM_MIM_CLOSE = 0x3C2,
#undef MM_MIM_DATA
       MM_MIM_DATA = 0x3C3,
#undef MM_MIM_LONGDATA
       MM_MIM_LONGDATA = 0x3C4,
#undef MM_MIM_ERROR
       MM_MIM_ERROR = 0x3C5,
#undef MM_MIM_LONGERROR
       MM_MIM_LONGERROR = 0x3C6,

       // MIDI output
#undef MM_MOM_OPEN
       MM_MOM_OPEN = 0x3C7,
#undef MM_MOM_CLOSE
       MM_MOM_CLOSE = 0x3C8,
#undef MM_MOM_DONE
       MM_MOM_DONE = 0x3C9,

       // installable drivers
#undef MM_DRVM_OPEN
       MM_DRVM_OPEN = 0x3D0,
#undef MM_DRVM_CLOSE
       MM_DRVM_CLOSE = 0x3D1,
#undef MM_DRVM_DATA
       MM_DRVM_DATA = 0x3D2,
#undef MM_DRVM_ERROR
       MM_DRVM_ERROR = 0x3D3,

#undef MM_STREAM_OPEN
       MM_STREAM_OPEN = 0x3D4,
#undef MM_STREAM_CLOSE
       MM_STREAM_CLOSE = 0x3D5,
#undef MM_STREAM_DONE
       MM_STREAM_DONE = 0x3D6,
#undef MM_STREAM_ERROR
       MM_STREAM_ERROR = 0x3D7,

       // Callback for MEVT_POSITIONCB
#undef MM_MOM_POSITIONCB
       MM_MOM_POSITIONCB = 0x3CA,

#undef MM_MCISIGNAL
       MM_MCISIGNAL = 0x3CB,

       // MIM_DONE w/ pending events
#undef MM_MIM_MOREDATA
       MM_MIM_MOREDATA = 0x3CC,

#undef MM_MIXM_LINE_CHANGE
       MM_MIXM_LINE_CHANGE = 0x3D0, // mixer line change notify
#undef MM_MIXM_CONTROL_CHANGE
       MM_MIXM_CONTROL_CHANGE = 0x3D1, // mixer control change notify

       // DDE window messages (WM_DDE_FIRST = 0x03e0)

       // ... which we might not have if WIN32_LEAN_AND_MEAN is defined.
#undef WM_DDE_FIRST
#define WM_DDE_FIRST 0x03e0

#undef WM_DDE_INITIATE
       WM_DDE_INITIATE = (WM_DDE_FIRST),
#undef WM_DDE_TERMINATE
       WM_DDE_TERMINATE = (WM_DDE_FIRST+1),
#undef WM_DDE_ADVISE
       WM_DDE_ADVISE = (WM_DDE_FIRST+2),
#undef WM_DDE_UNADVISE
       WM_DDE_UNADVISE = (WM_DDE_FIRST+3),
#undef WM_DDE_ACK
       WM_DDE_ACK = (WM_DDE_FIRST+4),
#undef WM_DDE_DATA
       WM_DDE_DATA = (WM_DDE_FIRST+5),
#undef WM_DDE_REQUEST
       WM_DDE_REQUEST = (WM_DDE_FIRST+6),
#undef WM_DDE_POKE
       WM_DDE_POKE = (WM_DDE_FIRST+7),
#undef WM_DDE_EXECUTE
       WM_DDE_EXECUTE = (WM_DDE_FIRST+8),

       // ListView messages (LVM_FIRST = 0x1000)
#undef LVM_GETBKCOLOR
       LVM_GETBKCOLOR = (LVM_FIRST + 0),
#undef LVM_SETBKCOLOR
       LVM_SETBKCOLOR = (LVM_FIRST + 1),
#undef LVM_GETIMAGELIST
       LVM_GETIMAGELIST = (LVM_FIRST + 2),
#undef LVM_SETIMAGELIST
       LVM_SETIMAGELIST = (LVM_FIRST + 3),
#undef LVM_GETITEMCOUNT
       LVM_GETITEMCOUNT = (LVM_FIRST + 4),
#undef LVM_GETITEMA
       LVM_GETITEMA = (LVM_FIRST + 5),
#undef LVM_SETITEMA
       LVM_SETITEMA = (LVM_FIRST + 6),
#undef LVM_INSERTITEMA
       LVM_INSERTITEMA = (LVM_FIRST + 7),
#undef LVM_DELETEITEM
       LVM_DELETEITEM = (LVM_FIRST + 8),
#undef LVM_DELETEALLITEMS
       LVM_DELETEALLITEMS = (LVM_FIRST + 9),
#undef LVM_GETCALLBACKMASK
       LVM_GETCALLBACKMASK = (LVM_FIRST + 10),
#undef LVM_SETCALLBACKMASK
       LVM_SETCALLBACKMASK = (LVM_FIRST + 11),
#undef LVM_GETNEXTITEM
       LVM_GETNEXTITEM = (LVM_FIRST + 12),
#undef LVM_FINDITEMA
       LVM_FINDITEMA = (LVM_FIRST + 13),
#undef LVM_GETITEMRECT
       LVM_GETITEMRECT = (LVM_FIRST + 14),
#undef LVM_SETITEMPOSITION
       LVM_SETITEMPOSITION = (LVM_FIRST + 15),
#undef LVM_GETITEMPOSITION
       LVM_GETITEMPOSITION = (LVM_FIRST + 16),
#undef LVM_GETSTRINGWIDTHA
       LVM_GETSTRINGWIDTHA = (LVM_FIRST + 17),
#undef LVM_GETSTRINGWIDTHW
       LVM_GETSTRINGWIDTHW = (LVM_FIRST + 87),
#undef LVM_HITTEST
       LVM_HITTEST = (LVM_FIRST + 18),
#undef LVM_ENSUREVISIBLE
       LVM_ENSUREVISIBLE = (LVM_FIRST + 19),
#undef LVM_SCROLL
       LVM_SCROLL = (LVM_FIRST + 20),
#undef LVM_REDRAWITEMS
       LVM_REDRAWITEMS = (LVM_FIRST + 21),
#undef LVM_ARRANGE
       LVM_ARRANGE = (LVM_FIRST + 22),
#undef LVM_EDITLABELA
       LVM_EDITLABELA = (LVM_FIRST + 23),
#undef LVM_GETEDITCONTROL
       LVM_GETEDITCONTROL = (LVM_FIRST + 24),
#undef LVM_GETCOLUMNA
       LVM_GETCOLUMNA = (LVM_FIRST + 25),
#undef LVM_SETCOLUMNA
       LVM_SETCOLUMNA = (LVM_FIRST + 26),
#undef LVM_INSERTCOLUMNA
       LVM_INSERTCOLUMNA = (LVM_FIRST + 27),
#undef LVM_DELETECOLUMN
       LVM_DELETECOLUMN = (LVM_FIRST + 28),
#undef LVM_GETCOLUMNWIDTH
       LVM_GETCOLUMNWIDTH = (LVM_FIRST + 29),
#undef LVM_SETCOLUMNWIDTH
       LVM_SETCOLUMNWIDTH = (LVM_FIRST + 30),
#undef LVM_GETHEADER
       LVM_GETHEADER = (LVM_FIRST + 31),
#undef LVM_CREATEDRAGIMAGE
       LVM_CREATEDRAGIMAGE = (LVM_FIRST + 33),
#undef LVM_GETVIEWRECT
       LVM_GETVIEWRECT = (LVM_FIRST + 34),
#undef LVM_GETTEXTCOLOR
       LVM_GETTEXTCOLOR = (LVM_FIRST + 35),
#undef LVM_SETTEXTCOLOR
       LVM_SETTEXTCOLOR = (LVM_FIRST + 36),
#undef LVM_GETTEXTBKCOLOR
       LVM_GETTEXTBKCOLOR = (LVM_FIRST + 37),
#undef LVM_SETTEXTBKCOLOR
       LVM_SETTEXTBKCOLOR = (LVM_FIRST + 38),
#undef LVM_GETTOPINDEX
       LVM_GETTOPINDEX = (LVM_FIRST + 39),
#undef LVM_GETCOUNTPERPAGE
       LVM_GETCOUNTPERPAGE = (LVM_FIRST + 40),
#undef LVM_GETORIGIN
       LVM_GETORIGIN = (LVM_FIRST + 41),
#undef LVM_UPDATE
       LVM_UPDATE = (LVM_FIRST + 42),
#undef LVM_SETITEMSTATE
       LVM_SETITEMSTATE = (LVM_FIRST + 43),
#undef LVM_GETITEMSTATE
       LVM_GETITEMSTATE = (LVM_FIRST + 44),
#undef LVM_GETITEMTEXTA
       LVM_GETITEMTEXTA = (LVM_FIRST + 45),
#undef LVM_SETITEMTEXTA
       LVM_SETITEMTEXTA = (LVM_FIRST + 46),
#undef LVM_SETITEMCOUNT
       LVM_SETITEMCOUNT = (LVM_FIRST + 47),
#undef LVM_SORTITEMS
       LVM_SORTITEMS = (LVM_FIRST + 48),
#undef LVM_SETITEMPOSITION32
       LVM_SETITEMPOSITION32 = (LVM_FIRST + 49),
#undef LVM_GETSELECTEDCOUNT
       LVM_GETSELECTEDCOUNT = (LVM_FIRST + 50),
#undef LVM_GETITEMSPACING
       LVM_GETITEMSPACING = (LVM_FIRST + 51),
#undef LVM_GETISEARCHSTRINGA
       LVM_GETISEARCHSTRINGA = (LVM_FIRST + 52),
#undef LVM_SETICONSPACING
       LVM_SETICONSPACING = (LVM_FIRST + 53),
#undef LVM_SETEXTENDEDLISTVIEWSTYLE
       LVM_SETEXTENDEDLISTVIEWSTYLE = (LVM_FIRST + 54), // optional wParam == mask
#undef LVM_GETEXTENDEDLISTVIEWSTYLE
       LVM_GETEXTENDEDLISTVIEWSTYLE = (LVM_FIRST + 55),
#undef LVM_GETSUBITEMRECT
       LVM_GETSUBITEMRECT = (LVM_FIRST + 56),
#undef LVM_SUBITEMHITTEST
       LVM_SUBITEMHITTEST = (LVM_FIRST + 57),
#undef LVM_SETCOLUMNORDERARRAY
       LVM_SETCOLUMNORDERARRAY = (LVM_FIRST + 58),
#undef LVM_GETCOLUMNORDERARRAY
       LVM_GETCOLUMNORDERARRAY = (LVM_FIRST + 59),
#undef LVM_SETHOTITEM
       LVM_SETHOTITEM = (LVM_FIRST + 60),
#undef LVM_GETHOTITEM
       LVM_GETHOTITEM = (LVM_FIRST + 61),
#undef LVM_SETHOTCURSOR
       LVM_SETHOTCURSOR = (LVM_FIRST + 62),
#undef LVM_GETHOTCURSOR
       LVM_GETHOTCURSOR = (LVM_FIRST + 63),
#undef LVM_APPROXIMATEVIEWRECT
       LVM_APPROXIMATEVIEWRECT = (LVM_FIRST + 64),
#undef LVM_SETWORKAREAS
       LVM_SETWORKAREAS = (LVM_FIRST + 65),
#undef LVM_GETSELECTIONMARK
       LVM_GETSELECTIONMARK = (LVM_FIRST + 66),
#undef LVM_SETSELECTIONMARK
       LVM_SETSELECTIONMARK = (LVM_FIRST + 67),
#undef LVM_SETBKIMAGEA
       LVM_SETBKIMAGEA = (LVM_FIRST + 68),
#undef LVM_GETBKIMAGEA
       LVM_GETBKIMAGEA = (LVM_FIRST + 69),
#undef LVM_GETWORKAREAS
       LVM_GETWORKAREAS = (LVM_FIRST + 70),
#undef LVM_SETHOVERTIME
       LVM_SETHOVERTIME = (LVM_FIRST + 71),
#undef LVM_GETHOVERTIME
       LVM_GETHOVERTIME = (LVM_FIRST + 72),
#undef LVM_GETNUMBEROFWORKAREAS
       LVM_GETNUMBEROFWORKAREAS = (LVM_FIRST + 73),
#undef LVM_SETTOOLTIPS
       LVM_SETTOOLTIPS = (LVM_FIRST + 74),
#undef LVM_GETITEMW
       LVM_GETITEMW = (LVM_FIRST + 75),
#undef LVM_SETITEMW
       LVM_SETITEMW = (LVM_FIRST + 76),
#undef LVM_INSERTITEMW
       LVM_INSERTITEMW = (LVM_FIRST + 77),
#undef LVM_GETTOOLTIPS
       LVM_GETTOOLTIPS = (LVM_FIRST + 78),
#undef LVM_SORTITEMSEX
       LVM_SORTITEMSEX = (LVM_FIRST + 81),
#undef LVM_FINDITEMW
       LVM_FINDITEMW = (LVM_FIRST + 83),
#undef LVM_GETGROUPSTATE
       LVM_GETGROUPSTATE = (LVM_FIRST + 92),
#undef LVM_GETFOCUSEDGROUP
       LVM_GETFOCUSEDGROUP = (LVM_FIRST + 93),
#undef LVM_GETCOLUMNW
       LVM_GETCOLUMNW = (LVM_FIRST + 95),
#undef LVM_SETCOLUMNW
       LVM_SETCOLUMNW = (LVM_FIRST + 96),
#undef LVM_INSERTCOLUMNW
       LVM_INSERTCOLUMNW = (LVM_FIRST + 97),
#undef LVM_GETGROUPRECT
       LVM_GETGROUPRECT = (LVM_FIRST + 98),
#undef LVM_GETITEMTEXTW
       LVM_GETITEMTEXTW = (LVM_FIRST + 115),
#undef LVM_SETITEMTEXTW
       LVM_SETITEMTEXTW = (LVM_FIRST + 116),
#undef LVM_GETISEARCHSTRINGW
       LVM_GETISEARCHSTRINGW = (LVM_FIRST + 117),
#undef LVM_EDITLABELW
       LVM_EDITLABELW = (LVM_FIRST + 118),
#undef LVM_SETBKIMAGEW
       LVM_SETBKIMAGEW = (LVM_FIRST + 138),
#undef LVM_GETBKIMAGEW
       LVM_GETBKIMAGEW = (LVM_FIRST + 139),
#undef LVM_SETSELECTEDCOLUMN
       LVM_SETSELECTEDCOLUMN = (LVM_FIRST + 140),
#undef LVM_SETTILEWIDTH
       LVM_SETTILEWIDTH = (LVM_FIRST + 141),
#undef LVM_SETVIEW
       LVM_SETVIEW = (LVM_FIRST + 142),
#undef LVM_GETVIEW
       LVM_GETVIEW = (LVM_FIRST + 143),
#undef LVM_INSERTGROUP
       LVM_INSERTGROUP = (LVM_FIRST + 145),
#undef LVM_SETGROUPINFO
       LVM_SETGROUPINFO = (LVM_FIRST + 147),
#undef LVM_GETGROUPINFO
       LVM_GETGROUPINFO = (LVM_FIRST + 149),
#undef LVM_REMOVEGROUP
       LVM_REMOVEGROUP = (LVM_FIRST + 150),
#undef LVM_MOVEGROUP
       LVM_MOVEGROUP = (LVM_FIRST + 151),
#undef LVM_GETGROUPCOUNT
       LVM_GETGROUPCOUNT = (LVM_FIRST + 152),
#undef LVM_GETGROUPINFOBYINDEX
       LVM_GETGROUPINFOBYINDEX = (LVM_FIRST + 153),
#undef LVM_MOVEITEMTOGROUP
       LVM_MOVEITEMTOGROUP = (LVM_FIRST + 154),
#undef LVM_SETGROUPMETRICS
       LVM_SETGROUPMETRICS = (LVM_FIRST + 155),
#undef LVM_GETGROUPMETRICS
       LVM_GETGROUPMETRICS = (LVM_FIRST + 156),
#undef LVM_ENABLEGROUPVIEW
       LVM_ENABLEGROUPVIEW = (LVM_FIRST + 157),
#undef LVM_SORTGROUPS
       LVM_SORTGROUPS = (LVM_FIRST + 158),
#undef LVM_INSERTGROUPSORTED
       LVM_INSERTGROUPSORTED = (LVM_FIRST + 159),
#undef LVM_REMOVEALLGROUPS
       LVM_REMOVEALLGROUPS = (LVM_FIRST + 160),
#undef LVM_HASGROUP
       LVM_HASGROUP = (LVM_FIRST + 161),
#undef LVM_SETTILEVIEWINFO
       LVM_SETTILEVIEWINFO = (LVM_FIRST + 162),
#undef LVM_GETTILEVIEWINFO
       LVM_GETTILEVIEWINFO = (LVM_FIRST + 163),
#undef LVM_SETTILEINFO
       LVM_SETTILEINFO = (LVM_FIRST + 164),
#undef LVM_GETTILEINFO
       LVM_GETTILEINFO = (LVM_FIRST + 165),
#undef LVM_SETINSERTMARK
       LVM_SETINSERTMARK = (LVM_FIRST + 166),
#undef LVM_GETINSERTMARK
       LVM_GETINSERTMARK = (LVM_FIRST + 167),
#undef LVM_INSERTMARKHITTEST
       LVM_INSERTMARKHITTEST = (LVM_FIRST + 168),
#undef LVM_GETINSERTMARKRECT
       LVM_GETINSERTMARKRECT = (LVM_FIRST + 169),
#undef LVM_SETINSERTMARKCOLOR
       LVM_SETINSERTMARKCOLOR = (LVM_FIRST + 170),
#undef LVM_GETINSERTMARKCOLOR
       LVM_GETINSERTMARKCOLOR = (LVM_FIRST + 171),
#undef LVM_SETINFOTIP
       LVM_SETINFOTIP = (LVM_FIRST + 173),
#undef LVM_GETSELECTEDCOLUMN
       LVM_GETSELECTEDCOLUMN = (LVM_FIRST + 174),
#undef LVM_ISGROUPVIEWENABLED
       LVM_ISGROUPVIEWENABLED = (LVM_FIRST + 175),
#undef LVM_GETOUTLINECOLOR
       LVM_GETOUTLINECOLOR = (LVM_FIRST + 176),
#undef LVM_SETOUTLINECOLOR
       LVM_SETOUTLINECOLOR = (LVM_FIRST + 177),
#undef LVM_CANCELEDITLABEL
       LVM_CANCELEDITLABEL = (LVM_FIRST + 179),
#undef LVM_MAPINDEXTOID
       LVM_MAPINDEXTOID = (LVM_FIRST + 180),
#undef LVM_MAPIDTOINDEX
       LVM_MAPIDTOINDEX = (LVM_FIRST + 181),
#undef LVM_ISITEMVISIBLE
       LVM_ISITEMVISIBLE = (LVM_FIRST + 182),
#undef LVM_GETEMPTYTEXT
       LVM_GETEMPTYTEXT = (LVM_FIRST + 204),
#undef LVM_GETFOOTERRECT
       LVM_GETFOOTERRECT = (LVM_FIRST + 205),
#undef LVM_GETFOOTERINFO
       LVM_GETFOOTERINFO = (LVM_FIRST + 206),
#undef LVM_GETFOOTERITEMRECT
       LVM_GETFOOTERITEMRECT = (LVM_FIRST + 207),
#undef LVM_GETFOOTERITEM
       LVM_GETFOOTERITEM = (LVM_FIRST + 208),
#undef LVM_GETITEMINDEXRECT
       LVM_GETITEMINDEXRECT = (LVM_FIRST + 209),
#undef LVM_SETITEMINDEXSTATE
       LVM_SETITEMINDEXSTATE = (LVM_FIRST + 210),
#undef LVM_GETNEXTITEMINDEX
       LVM_GETNEXTITEMINDEX = (LVM_FIRST + 211),

       // TreeView messages (TV_FIRST  = 0x1100)
#undef TVM_INSERTITEMA
       TVM_INSERTITEMA = (TV_FIRST + 0),
#undef TVM_DELETEITEM
       TVM_DELETEITEM = (TV_FIRST + 1),
#undef TVM_EXPAND
       TVM_EXPAND = (TV_FIRST + 2),
#undef TVM_GETITEMRECT
       TVM_GETITEMRECT = (TV_FIRST + 4),
#undef TVM_GETCOUNT
       TVM_GETCOUNT = (TV_FIRST + 5),
#undef TVM_GETINDENT
       TVM_GETINDENT = (TV_FIRST + 6),
#undef TVM_SETINDENT
       TVM_SETINDENT = (TV_FIRST + 7),
#undef TVM_GETIMAGELIST
       TVM_GETIMAGELIST = (TV_FIRST + 8),
#undef TVM_SETIMAGELIST
       TVM_SETIMAGELIST = (TV_FIRST + 9),
#undef TVM_GETNEXTITEM
       TVM_GETNEXTITEM = (TV_FIRST + 10),
#undef TVM_SELECTITEM
       TVM_SELECTITEM = (TV_FIRST + 11),
#undef TVM_GETITEMA
       TVM_GETITEMA = (TV_FIRST + 12),
#undef TVM_SETITEMA
       TVM_SETITEMA = (TV_FIRST + 13),
#undef TVM_EDITLABELA
       TVM_EDITLABELA = (TV_FIRST + 14),
#undef TVM_GETEDITCONTROL
       TVM_GETEDITCONTROL = (TV_FIRST + 15),
#undef TVM_GETVISIBLECOUNT
       TVM_GETVISIBLECOUNT = (TV_FIRST + 16),
#undef TVM_HITTEST
       TVM_HITTEST = (TV_FIRST + 17),
#undef TVM_CREATEDRAGIMAGE
       TVM_CREATEDRAGIMAGE = (TV_FIRST + 18),
#undef TVM_SORTCHILDREN
       TVM_SORTCHILDREN = (TV_FIRST + 19),
#undef TVM_ENSUREVISIBLE
       TVM_ENSUREVISIBLE = (TV_FIRST + 20),
#undef TVM_SORTCHILDRENCB
       TVM_SORTCHILDRENCB = (TV_FIRST + 21),
#undef TVM_ENDEDITLABELNOW
       TVM_ENDEDITLABELNOW = (TV_FIRST + 22),
#undef TVM_GETISEARCHSTRINGA
       TVM_GETISEARCHSTRINGA = (TV_FIRST + 23),
#undef TVM_SETTOOLTIPS
       TVM_SETTOOLTIPS = (TV_FIRST + 24),
#undef TVM_GETTOOLTIPS
       TVM_GETTOOLTIPS = (TV_FIRST + 25),
#undef TVM_SETINSERTMARK
       TVM_SETINSERTMARK = (TV_FIRST + 26),
#undef TVM_SETITEMHEIGHT
       TVM_SETITEMHEIGHT = (TV_FIRST + 27),
#undef TVM_GETITEMHEIGHT
       TVM_GETITEMHEIGHT = (TV_FIRST + 28),
#undef TVM_SETBKCOLOR
       TVM_SETBKCOLOR = (TV_FIRST + 29),
#undef TVM_SETTEXTCOLOR
       TVM_SETTEXTCOLOR = (TV_FIRST + 30),
#undef TVM_GETBKCOLOR
       TVM_GETBKCOLOR = (TV_FIRST + 31),
#undef TVM_GETTEXTCOLOR
       TVM_GETTEXTCOLOR = (TV_FIRST + 32),
#undef TVM_SETSCROLLTIME
       TVM_SETSCROLLTIME = (TV_FIRST + 33),
#undef TVM_GETSCROLLTIME
       TVM_GETSCROLLTIME = (TV_FIRST + 34),
#undef TVM_SETBORDER
       TVM_SETBORDER = (TV_FIRST + 35),
#undef TVM_SETINSERTMARKCOLOR
       TVM_SETINSERTMARKCOLOR = (TV_FIRST + 37),
#undef TVM_GETINSERTMARKCOLOR
       TVM_GETINSERTMARKCOLOR = (TV_FIRST + 38),
#undef TVM_GETITEMSTATE
       TVM_GETITEMSTATE = (TV_FIRST + 39),
#undef TVM_SETLINECOLOR
       TVM_SETLINECOLOR = (TV_FIRST + 40),
#undef TVM_GETLINECOLOR
       TVM_GETLINECOLOR = (TV_FIRST + 41),
#undef TVM_MAPACCIDTOHTREEITEM
       TVM_MAPACCIDTOHTREEITEM = (TV_FIRST + 42),
#undef TVM_MAPHTREEITEMTOACCID
       TVM_MAPHTREEITEMTOACCID = (TV_FIRST + 43),
#undef TVM_SETEXTENDEDSTYLE
       TVM_SETEXTENDEDSTYLE = (TV_FIRST + 44),
#undef TVM_GETEXTENDEDSTYLE
       TVM_GETEXTENDEDSTYLE = (TV_FIRST + 45),
#undef TVM_INSERTITEMW
       TVM_INSERTITEMW = (TV_FIRST + 50),
#undef TVM_SETHOT
       TVM_SETHOT = (TV_FIRST + 58),
#undef TVM_SETAUTOSCROLLINFO
       TVM_SETAUTOSCROLLINFO = (TV_FIRST + 59),
#undef TVM_GETITEMW
       TVM_GETITEMW = (TV_FIRST + 62),
#undef TVM_SETITEMW
       TVM_SETITEMW = (TV_FIRST + 63),
#undef TVM_GETISEARCHSTRINGW
       TVM_GETISEARCHSTRINGW = (TV_FIRST + 64),
#undef TVM_EDITLABELW
       TVM_EDITLABELW = (TV_FIRST + 65),
#undef TVM_GETSELECTEDCOUNT
       TVM_GETSELECTEDCOUNT = (TV_FIRST + 70),
#undef TVM_SHOWINFOTIP
       TVM_SHOWINFOTIP = (TV_FIRST + 71),
#undef TVM_GETITEMPARTRECT
       TVM_GETITEMPARTRECT = (TV_FIRST + 72),

       // Header messages (HDM_FIRST = 0x1200)
#undef HDM_GETITEMCOUNT
       HDM_GETITEMCOUNT = (HDM_FIRST + 0),
#undef HDM_INSERTITEMA
       HDM_INSERTITEMA = (HDM_FIRST + 1),
#undef HDM_DELETEITEM
       HDM_DELETEITEM = (HDM_FIRST + 2),
#undef HDM_GETITEMA
       HDM_GETITEMA = (HDM_FIRST + 3),
#undef HDM_SETITEMA
       HDM_SETITEMA = (HDM_FIRST + 4),
#undef HDM_LAYOUT
       HDM_LAYOUT = (HDM_FIRST + 5),
#undef HDM_HITTEST
       HDM_HITTEST = (HDM_FIRST + 6),
#undef HDM_GETITEMRECT
       HDM_GETITEMRECT = (HDM_FIRST + 7),
#undef HDM_SETIMAGELIST
       HDM_SETIMAGELIST = (HDM_FIRST + 8),
#undef HDM_GETIMAGELIST
       HDM_GETIMAGELIST = (HDM_FIRST + 9),
#undef HDM_INSERTITEMW
       HDM_INSERTITEMW = (HDM_FIRST + 10),
#undef HDM_GETITEMW
       HDM_GETITEMW = (HDM_FIRST + 11),
#undef HDM_SETITEMW
       HDM_SETITEMW = (HDM_FIRST + 12),
#undef HDM_ORDERTOINDEX
       HDM_ORDERTOINDEX = (HDM_FIRST + 15),
#undef HDM_CREATEDRAGIMAGE
       HDM_CREATEDRAGIMAGE = (HDM_FIRST + 16), // wparam = which item (by index)
#undef HDM_GETORDERARRAY
       HDM_GETORDERARRAY = (HDM_FIRST + 17),
#undef HDM_SETORDERARRAY
       HDM_SETORDERARRAY = (HDM_FIRST + 18),
#undef HDM_SETHOTDIVIDER
       HDM_SETHOTDIVIDER = (HDM_FIRST + 19),
#undef HDM_SETBITMAPMARGIN
       HDM_SETBITMAPMARGIN = (HDM_FIRST + 20),
#undef HDM_GETBITMAPMARGIN
       HDM_GETBITMAPMARGIN = (HDM_FIRST + 21),
#undef HDM_SETFILTERCHANGETIMEOUT
       HDM_SETFILTERCHANGETIMEOUT = (HDM_FIRST + 22),
#undef HDM_EDITFILTER
       HDM_EDITFILTER = (HDM_FIRST + 23),
#undef HDM_CLEARFILTER
       HDM_CLEARFILTER = (HDM_FIRST + 24),
#undef HDM_GETITEMDROPDOWNRECT
       HDM_GETITEMDROPDOWNRECT = (HDM_FIRST + 25), // rect of item's drop down button
#undef HDM_GETOVERFLOWRECT
       HDM_GETOVERFLOWRECT = (HDM_FIRST + 26), // rect of overflow button
#undef HDM_GETFOCUSEDITEM
       HDM_GETFOCUSEDITEM = (HDM_FIRST + 27),
#undef HDM_SETFOCUSEDITEM
       HDM_SETFOCUSEDITEM = (HDM_FIRST + 28),

       // Tab control messages (TCM_FIRST = 0x1300)
#undef TCM_GETIMAGELIST
       TCM_GETIMAGELIST = (TCM_FIRST + 2),
#undef TCM_SETIMAGELIST
       TCM_SETIMAGELIST = (TCM_FIRST + 3),
#undef TCM_GETITEMCOUNT
       TCM_GETITEMCOUNT = (TCM_FIRST + 4),
#undef TCM_GETITEMA
       TCM_GETITEMA = (TCM_FIRST + 5),
#undef TCM_SETITEMA
       TCM_SETITEMA = (TCM_FIRST + 6),
#undef TCM_INSERTITEMA
       TCM_INSERTITEMA = (TCM_FIRST + 7),
#undef TCM_DELETEITEM
       TCM_DELETEITEM = (TCM_FIRST + 8),
#undef TCM_DELETEALLITEMS
       TCM_DELETEALLITEMS = (TCM_FIRST + 9),
#undef TCM_GETITEMRECT
       TCM_GETITEMRECT = (TCM_FIRST + 10),
#undef TCM_GETCURSEL
       TCM_GETCURSEL = (TCM_FIRST + 11),
#undef TCM_SETCURSEL
       TCM_SETCURSEL = (TCM_FIRST + 12),
#undef TCM_HITTEST
       TCM_HITTEST = (TCM_FIRST + 13),
#undef TCM_SETITEMEXTRA
       TCM_SETITEMEXTRA = (TCM_FIRST + 14),
#undef TCM_ADJUSTRECT
       TCM_ADJUSTRECT = (TCM_FIRST + 40),
#undef TCM_SETITEMSIZE
       TCM_SETITEMSIZE = (TCM_FIRST + 41),
#undef TCM_REMOVEIMAGE
       TCM_REMOVEIMAGE = (TCM_FIRST + 42),
#undef TCM_SETPADDING
       TCM_SETPADDING = (TCM_FIRST + 43),
#undef TCM_GETROWCOUNT
       TCM_GETROWCOUNT = (TCM_FIRST + 44),
#undef TCM_GETTOOLTIPS
       TCM_GETTOOLTIPS = (TCM_FIRST + 45),
#undef TCM_SETTOOLTIPS
       TCM_SETTOOLTIPS = (TCM_FIRST + 46),
#undef TCM_GETCURFOCUS
       TCM_GETCURFOCUS = (TCM_FIRST + 47),
#undef TCM_SETCURFOCUS
       TCM_SETCURFOCUS = (TCM_FIRST + 48),
#undef TCM_SETMINTABWIDTH
       TCM_SETMINTABWIDTH = (TCM_FIRST + 49),
#undef TCM_DESELECTALL
       TCM_DESELECTALL = (TCM_FIRST + 50),
#undef TCM_HIGHLIGHTITEM
       TCM_HIGHLIGHTITEM = (TCM_FIRST + 51),
#undef TCM_SETEXTENDEDSTYLE
       TCM_SETEXTENDEDSTYLE = (TCM_FIRST + 52), // optional wParam == mask
#undef TCM_GETEXTENDEDSTYLE
       TCM_GETEXTENDEDSTYLE = (TCM_FIRST + 53),
#undef TCM_GETITEMW
       TCM_GETITEMW = (TCM_FIRST + 60),
#undef TCM_SETITEMW
       TCM_SETITEMW = (TCM_FIRST + 61),
#undef TCM_INSERTITEMW
       TCM_INSERTITEMW = (TCM_FIRST + 62),

       // Pager control messages (PGM_FIRST = 0x1400)
#undef PGM_SETCHILD
       PGM_SETCHILD = (PGM_FIRST + 1), // lParam == hwnd
#undef PGM_RECALCSIZE
       PGM_RECALCSIZE = (PGM_FIRST + 2),
#undef PGM_FORWARDMOUSE
       PGM_FORWARDMOUSE = (PGM_FIRST + 3),
#undef PGM_SETBKCOLOR
       PGM_SETBKCOLOR = (PGM_FIRST + 4),
#undef PGM_GETBKCOLOR
       PGM_GETBKCOLOR = (PGM_FIRST + 5),
#undef PGM_SETBORDER
       PGM_SETBORDER = (PGM_FIRST + 6),
#undef PGM_GETBORDER
       PGM_GETBORDER = (PGM_FIRST + 7),
#undef PGM_SETPOS
       PGM_SETPOS = (PGM_FIRST + 8),
#undef PGM_GETPOS
       PGM_GETPOS = (PGM_FIRST + 9),
#undef PGM_SETBUTTONSIZE
       PGM_SETBUTTONSIZE = (PGM_FIRST + 10),
#undef PGM_GETBUTTONSIZE
       PGM_GETBUTTONSIZE = (PGM_FIRST + 11),
#undef PGM_GETBUTTONSTATE
       PGM_GETBUTTONSTATE = (PGM_FIRST + 12),
#undef PGM_SETSCROLLINFO
       PGM_SETSCROLLINFO = (PGM_FIRST + 13),

       // Edit control messages (ECM_FIRST = 0x1500)
#undef EM_SETCUEBANNER
       EM_SETCUEBANNER = (ECM_FIRST + 0x0001), // Set the cue banner with the lParm = LPCWSTR
#undef EM_GETCUEBANNER
       EM_GETCUEBANNER = (ECM_FIRST + 0x0002), // Set the cue banner with the lParm = LPCWSTR
#undef EM_SHOWBALLOONTIP
       EM_SHOWBALLOONTIP = (ECM_FIRST + 0x0003), // Show a balloon tip associated to the edit control
#undef EM_HIDEBALLOONTIP
       EM_HIDEBALLOONTIP = (ECM_FIRST + 0x0004), // Hide any balloon tip associated with the edit control
#undef EM_SETHILITE
       EM_SETHILITE = (ECM_FIRST + 0x0005),
#undef EM_GETHILITE
       EM_GETHILITE = (ECM_FIRST + 0x0006),
#undef EM_NOSETFOCUS
       EM_NOSETFOCUS = (ECM_FIRST + 0x0007),
#undef EM_TAKEFOCUS
       EM_TAKEFOCUS = (ECM_FIRST + 0x0008),

       // Button control messages (BCM_FIRST = 0x1600)
#undef BCM_GETIDEALSIZE
       BCM_GETIDEALSIZE = (BCM_FIRST + 0x0001),
#undef BCM_SETIMAGELIST
       BCM_SETIMAGELIST = (BCM_FIRST + 0x0002),
#undef BCM_GETIMAGELIST
       BCM_GETIMAGELIST = (BCM_FIRST + 0x0003),
#undef BCM_SETTEXTMARGIN
       BCM_SETTEXTMARGIN = (BCM_FIRST + 0x0004),
#undef BCM_GETTEXTMARGIN
       BCM_GETTEXTMARGIN = (BCM_FIRST + 0x0005),
#undef BCM_SETDROPDOWNSTATE
       BCM_SETDROPDOWNSTATE = (BCM_FIRST + 0x0006),
#undef BCM_SETSPLITINFO
       BCM_SETSPLITINFO = (BCM_FIRST + 0x0007),
#undef BCM_GETSPLITINFO
       BCM_GETSPLITINFO = (BCM_FIRST + 0x0008),
#undef BCM_SETNOTE
       BCM_SETNOTE = (BCM_FIRST + 0x0009),
#undef BCM_GETNOTE
       BCM_GETNOTE = (BCM_FIRST + 0x000A),
#undef BCM_GETNOTELENGTH
       BCM_GETNOTELENGTH = (BCM_FIRST + 0x000B),
#undef BCM_SETSHIELD
       BCM_SETSHIELD = (BCM_FIRST + 0x000C),

       // Combobox control messages (CBM_FIRST = 0x1700)
#undef CB_SETMINVISIBLE
       CB_SETMINVISIBLE = (CBM_FIRST + 1),
#undef CB_GETMINVISIBLE
       CB_GETMINVISIBLE = (CBM_FIRST + 2),
#undef CB_SETCUEBANNER
       CB_SETCUEBANNER = (CBM_FIRST + 3),
#undef CB_GETCUEBANNER
       CB_GETCUEBANNER = (CBM_FIRST + 4),

       // Common control shared messages (CCM_FIRST = 0x2000)
#undef CCM_SETBKCOLOR
       CCM_SETBKCOLOR = (CCM_FIRST + 1), // lParam is bkColor
#undef CCM_SETCOLORSCHEME
       CCM_SETCOLORSCHEME = (CCM_FIRST + 2), // lParam is color scheme
#undef CCM_GETCOLORSCHEME
       CCM_GETCOLORSCHEME = (CCM_FIRST + 3), // fills in COLORSCHEME pointed to by lParam
#undef CCM_GETDROPTARGET
       CCM_GETDROPTARGET = (CCM_FIRST + 4),
#undef CCM_SETUNICODEFORMAT
       CCM_SETUNICODEFORMAT = (CCM_FIRST + 5),
#undef CCM_GETUNICODEFORMAT
       CCM_GETUNICODEFORMAT = (CCM_FIRST + 6),
#undef CCM_SETVERSION
       CCM_SETVERSION = (CCM_FIRST + 7),
#undef CCM_GETVERSION
       CCM_GETVERSION = (CCM_FIRST + 0x08),
#undef CCM_SETNOTIFYWINDOW
       CCM_SETNOTIFYWINDOW = (CCM_FIRST + 0x9), // wParam == hwndParent.
#undef CCM_SETWINDOWTHEME
       CCM_SETWINDOWTHEME = (CCM_FIRST + 0xb),
#undef CCM_DPISCALE
       CCM_DPISCALE = (CCM_FIRST + 0xc), // wParam == Awareness
} MESSAGEID;
