/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonObject;

public final class WsonArray {
    private final JsonArray json;

    public WsonArray(JsonArray json) {
        this.json = Objects.requireNonNull(json);
    }

    public boolean getBoolean(int index) throws JsonException {
        try {
            return JsonUtils.getAsBoolean(this.json.get(index));
        }
        catch (JsonException e) {
            throw new JsonException("Boolean at [" + index + "] not found.", e);
        }
    }

    public boolean getBoolean(int index, boolean fallback) {
        return JsonUtils.getAsBoolean(this.json.get(index), fallback);
    }

    public int getInt(int index) throws JsonException {
        try {
            return JsonUtils.getAsInt(this.json.get(index));
        }
        catch (JsonException e) {
            throw new JsonException("Number at [" + index + "] not found.", e);
        }
    }

    public int getInt(int index, int fallback) {
        return JsonUtils.getAsInt(this.json.get(index), fallback);
    }

    public long getLong(int index) throws JsonException {
        try {
            return JsonUtils.getAsLong(this.json.get(index));
        }
        catch (JsonException e) {
            throw new JsonException("Number at [" + index + "] not found.", e);
        }
    }

    public long getLong(int index, long fallback) {
        return JsonUtils.getAsLong(this.json.get(index), fallback);
    }

    public float getFloat(int index) throws JsonException {
        try {
            return JsonUtils.getAsFloat(this.json.get(index));
        }
        catch (JsonException e) {
            throw new JsonException("Number at [" + index + "] not found.", e);
        }
    }

    public float getFloat(int index, float fallback) {
        return JsonUtils.getAsFloat(this.json.get(index), fallback);
    }

    public double getDouble(int index) throws JsonException {
        try {
            return JsonUtils.getAsDouble(this.json.get(index));
        }
        catch (JsonException e) {
            throw new JsonException("Number at [" + index + "] not found.", e);
        }
    }

    public double getDouble(int index, double fallback) {
        return JsonUtils.getAsDouble(this.json.get(index), fallback);
    }

    public String getString(int index) throws JsonException {
        try {
            return JsonUtils.getAsString(this.json.get(index));
        }
        catch (JsonException e) {
            throw new JsonException("String at [" + index + "] not found.", e);
        }
    }

    public String getString(int index, String fallback) {
        return JsonUtils.getAsString(this.json.get(index), fallback);
    }

    public WsonArray getArray(int index) throws JsonException {
        try {
            return JsonUtils.getAsArray(this.json.get(index));
        }
        catch (JsonException e) {
            throw new JsonException("Array at [" + index + "] not found.", e);
        }
    }

    public WsonObject getObject(int index) throws JsonException {
        try {
            return JsonUtils.getAsObject(this.json.get(index));
        }
        catch (JsonException e) {
            throw new JsonException("Object at [" + index + "] not found.", e);
        }
    }

    public JsonElement getElement(int index) {
        return this.json.get(index);
    }

    public ArrayList<String> getAllStrings() {
        return StreamSupport.stream(this.json.spliterator(), false).filter(JsonUtils::isString).map(JsonElement::getAsString).collect(Collectors.toCollection(ArrayList::new));
    }

    public ArrayList<WsonObject> getAllObjects() {
        return StreamSupport.stream(this.json.spliterator(), false).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).map(WsonObject::new).collect(Collectors.toCollection(ArrayList::new));
    }

    public JsonArray toJsonArray() {
        return this.json;
    }

    public String toString() {
        return this.json.toString();
    }
}

