/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.util;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_638;
import net.wurstclient.WurstClient;
import net.wurstclient.util.BlockUtils;

public final class ChunkSearcher {
    private final class_2791 chunk;
    private final class_2248 block;
    private final int dimensionId;
    private final ArrayList<class_2338> matchingBlocks = new ArrayList();
    private Status status = Status.IDLE;
    private Future<?> future;

    public ChunkSearcher(class_2791 chunk, class_2248 block, int dimensionId) {
        this.chunk = chunk;
        this.block = block;
        this.dimensionId = dimensionId;
    }

    public void startSearching(ExecutorService pool) {
        if (this.status != Status.IDLE) {
            throw new IllegalStateException();
        }
        this.status = Status.SEARCHING;
        this.future = pool.submit(this::searchNow);
    }

    private void searchNow() {
        if (this.status == Status.IDLE || this.status == Status.DONE || !this.matchingBlocks.isEmpty()) {
            throw new IllegalStateException();
        }
        class_1923 chunkPos = this.chunk.method_12004();
        class_638 world = WurstClient.MC.field_1687;
        int minX = chunkPos.method_8326();
        int minY = world.method_31607();
        int minZ = chunkPos.method_8328();
        int maxX = chunkPos.method_8327();
        int maxY = world.method_31600();
        int maxZ = chunkPos.method_8329();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (this.status == Status.INTERRUPTED || Thread.interrupted()) {
                        return;
                    }
                    class_2338 pos = new class_2338(x, y, z);
                    class_2248 block = BlockUtils.getBlock(pos);
                    if (!this.block.equals(block)) continue;
                    this.matchingBlocks.add(pos);
                }
            }
        }
        this.status = Status.DONE;
    }

    public void cancelSearching() {
        new Thread(this::cancelNow, "ChunkSearcher-canceller").start();
    }

    private void cancelNow() {
        if (this.future != null) {
            try {
                this.status = Status.INTERRUPTED;
                this.future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.matchingBlocks.clear();
        this.status = Status.IDLE;
    }

    public class_2791 getChunk() {
        return this.chunk;
    }

    public class_2248 getBlock() {
        return this.block;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public ArrayList<class_2338> getMatchingBlocks() {
        return this.matchingBlocks;
    }

    public Status getStatus() {
        return this.status;
    }

    public static enum Status {
        IDLE,
        SEARCHING,
        INTERRUPTED,
        DONE;

    }
}

