/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings.filterlists;

import java.util.ArrayList;
import java.util.List;
import net.wurstclient.settings.filterlists.EntityFilterList;
import net.wurstclient.settings.filters.FilterAllaysSetting;
import net.wurstclient.settings.filters.FilterAnimalsSetting;
import net.wurstclient.settings.filters.FilterArmorStandsSetting;
import net.wurstclient.settings.filters.FilterBabiesSetting;
import net.wurstclient.settings.filters.FilterEndermenSetting;
import net.wurstclient.settings.filters.FilterFlyingSetting;
import net.wurstclient.settings.filters.FilterGolemsSetting;
import net.wurstclient.settings.filters.FilterInvisibleSetting;
import net.wurstclient.settings.filters.FilterMonstersSetting;
import net.wurstclient.settings.filters.FilterPetsSetting;
import net.wurstclient.settings.filters.FilterPigmenSetting;
import net.wurstclient.settings.filters.FilterPlayersSetting;
import net.wurstclient.settings.filters.FilterSleepingSetting;
import net.wurstclient.settings.filters.FilterTradersSetting;

public final class RemoteViewFilterList
extends EntityFilterList {
    private RemoteViewFilterList(List<EntityFilterList.EntityFilter> filters) {
        super(filters);
    }

    public static RemoteViewFilterList create() {
        ArrayList<EntityFilterList.EntityFilter> builder = new ArrayList<EntityFilterList.EntityFilter>();
        builder.add(new FilterPlayersSetting("Won't view other players.", false));
        builder.add(new FilterSleepingSetting("Won't view sleeping players.", false));
        builder.add(new FilterFlyingSetting("Won't view players that are at least the given distance above ground.", 0.0));
        builder.add(new FilterMonstersSetting("Won't view zombies, creepers, etc.", true));
        builder.add(new FilterPigmenSetting("Won't view zombie pigmen.", true));
        builder.add(new FilterEndermenSetting("Won't view endermen.", true));
        builder.add(new FilterAnimalsSetting("Won't view pigs, cows, etc.", true));
        builder.add(new FilterBabiesSetting("Won't view baby pigs, baby villagers, etc.", true));
        builder.add(new FilterPetsSetting("Won't view tamed wolves, tamed horses, etc.", true));
        builder.add(new FilterTradersSetting("Won't view villagers, wandering traders, etc.", true));
        builder.add(new FilterGolemsSetting("Won't view iron golems, snow golems and shulkers.", true));
        builder.add(new FilterAllaysSetting("Won't view allays.", true));
        builder.add(new FilterInvisibleSetting("Won't view invisible entities.", false));
        builder.add(new FilterArmorStandsSetting("Won't view armor stands.", true));
        return new RemoteViewFilterList(builder);
    }
}

