/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings.filterlists;

import java.util.ArrayList;
import java.util.List;
import net.wurstclient.settings.filterlists.EntityFilterList;
import net.wurstclient.settings.filters.FilterAllaysSetting;
import net.wurstclient.settings.filters.FilterAnimalsSetting;
import net.wurstclient.settings.filters.FilterArmorStandsSetting;
import net.wurstclient.settings.filters.FilterGolemsSetting;
import net.wurstclient.settings.filters.FilterInvisibleSetting;
import net.wurstclient.settings.filters.FilterMonstersSetting;
import net.wurstclient.settings.filters.FilterNamedSetting;
import net.wurstclient.settings.filters.FilterPlayersSetting;
import net.wurstclient.settings.filters.FilterTradersSetting;

public final class CrystalAuraFilterList
extends EntityFilterList {
    private CrystalAuraFilterList(List<EntityFilterList.EntityFilter> filters) {
        super(filters);
    }

    public static CrystalAuraFilterList create() {
        ArrayList<EntityFilterList.EntityFilter> builder = new ArrayList<EntityFilterList.EntityFilter>();
        String damageWarning = "\n\nThey can still take damage if they get too close to a valid target or an existing crystal.";
        builder.add(new FilterPlayersSetting("Won't target other players when auto-placing crystals." + damageWarning, false));
        builder.add(new FilterMonstersSetting("Won't target zombies, creepers, etc. when auto-placing crystals." + damageWarning, true));
        builder.add(new FilterAnimalsSetting("Won't target pigs, cows, etc. when auto-placing crystals." + damageWarning, true));
        builder.add(new FilterTradersSetting("Won't target villagers, wandering traders, etc. when auto-placing crystals." + damageWarning, true));
        builder.add(new FilterGolemsSetting("Won't target iron golems, snow golems and shulkers when auto-placing crystals." + damageWarning, true));
        builder.add(new FilterAllaysSetting("Won't target allays when auto-placing crystals." + damageWarning, true));
        builder.add(new FilterInvisibleSetting("Won't target invisible entities when auto-placing crystals." + damageWarning, false));
        builder.add(new FilterNamedSetting("Won't target name-tagged entities when auto-placing crystals." + damageWarning, false));
        builder.add(new FilterArmorStandsSetting("Won't target armor stands when auto-placing crystals." + damageWarning, true));
        return new CrystalAuraFilterList(builder);
    }
}

