/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.Set;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.Component;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.util.ChatUtils;

public abstract class Setting {
    private final String name;
    private final String description;

    public Setting(String name, String description) {
        this.name = Objects.requireNonNull(name);
        this.description = Objects.requireNonNull(description);
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return WurstClient.INSTANCE.translate(this.description);
    }

    public final String getWrappedDescription(int width) {
        return ChatUtils.wrapText(this.getDescription(), width);
    }

    public final String getDescriptionKey() {
        return this.description;
    }

    public abstract Component getComponent();

    public abstract void fromJson(JsonElement var1);

    public abstract JsonElement toJson();

    public abstract JsonObject exportWikiData();

    public void update() {
    }

    public abstract Set<PossibleKeybind> getPossibleKeybinds(String var1);
}

