/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.components.BlockListEditButton;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonArray;

public final class BlockListSetting
extends Setting {
    private final ArrayList<String> blockNames = new ArrayList();
    private final String[] defaultNames;

    public BlockListSetting(String name, String description, String ... blocks) {
        super(name, description);
        ((Stream)Arrays.stream(blocks).parallel()).map(s -> (class_2248)class_7923.field_41175.method_10223(new class_2960(s))).filter(Objects::nonNull).map(BlockUtils::getName).distinct().sorted().forEachOrdered(s -> this.blockNames.add((String)s));
        this.defaultNames = this.blockNames.toArray(new String[0]);
    }

    public List<String> getBlockNames() {
        return Collections.unmodifiableList(this.blockNames);
    }

    public void add(class_2248 block) {
        String name = BlockUtils.getName(block);
        if (Collections.binarySearch(this.blockNames, name) >= 0) {
            return;
        }
        this.blockNames.add(name);
        Collections.sort(this.blockNames);
        WurstClient.INSTANCE.saveSettings();
    }

    public void remove(int index) {
        if (index < 0 || index >= this.blockNames.size()) {
            return;
        }
        this.blockNames.remove(index);
        WurstClient.INSTANCE.saveSettings();
    }

    public void resetToDefaults() {
        this.blockNames.clear();
        this.blockNames.addAll(Arrays.asList(this.defaultNames));
        WurstClient.INSTANCE.saveSettings();
    }

    @Override
    public Component getComponent() {
        return new BlockListEditButton(this);
    }

    @Override
    public void fromJson(JsonElement json) {
        try {
            WsonArray wson = JsonUtils.getAsArray(json);
            this.blockNames.clear();
            wson.getAllStrings().parallelStream().map(s -> (class_2248)class_7923.field_41175.method_10223(new class_2960(s))).filter(Objects::nonNull).map(BlockUtils::getName).distinct().sorted().forEachOrdered(s -> this.blockNames.add((String)s));
        }
        catch (JsonException e) {
            e.printStackTrace();
            this.resetToDefaults();
        }
    }

    @Override
    public JsonElement toJson() {
        JsonArray json = new JsonArray();
        this.blockNames.forEach(s -> json.add(s));
        return json;
    }

    @Override
    public JsonObject exportWikiData() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getName());
        json.addProperty("descriptionKey", this.getDescriptionKey());
        json.addProperty("type", "BlockList");
        JsonArray defaultBlocksJson = new JsonArray();
        for (String blockName : this.defaultNames) {
            defaultBlocksJson.add(blockName);
        }
        json.add("defaultBlocks", (JsonElement)defaultBlocksJson);
        return json;
    }

    @Override
    public Set<PossibleKeybind> getPossibleKeybinds(String featureName) {
        String fullName = featureName + " " + this.getName();
        String command = ".blocklist " + featureName.toLowerCase() + " ";
        command = command + this.getName().toLowerCase().replace(" ", "_") + " ";
        LinkedHashSet<PossibleKeybind> pkb = new LinkedHashSet<PossibleKeybind>();
        pkb.add(new PossibleKeybind(command + "reset", "Reset " + fullName));
        return pkb;
    }
}

