/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.mixin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1071;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1071.class})
public class PlayerSkinProviderMixin {
    @Shadow
    @Final
    private MinecraftSessionService field_5308;
    private static JsonObject capes;

    @Inject(at={@At(value="HEAD")}, method={"loadSkin(Lcom/mojang/authlib/GameProfile;Lnet/minecraft/client/texture/PlayerSkinProvider$SkinTextureAvailableCallback;Z)V"}, cancellable=true)
    private void onLoadSkin(GameProfile profile, class_1071.class_1072 callback, boolean requireSecure, CallbackInfo ci) {
        Runnable runnable = () -> {
            HashMap map = Maps.newHashMap();
            try {
                map.putAll(this.field_5308.getTextures(profile, requireSecure));
            }
            catch (InsecurePublicKeyException insecurePublicKeyException) {
                // empty catch block
            }
            if (map.isEmpty()) {
                profile.getProperties().clear();
                if (profile.getId().equals(class_310.method_1551().method_1548().method_1677().getId())) {
                    profile.getProperties().putAll((Multimap)class_310.method_1551().method_1539());
                    map.putAll(this.field_5308.getTextures(profile, false));
                } else {
                    this.field_5308.fillProfileProperties(profile, requireSecure);
                    try {
                        map.putAll(this.field_5308.getTextures(profile, requireSecure));
                    }
                    catch (InsecurePublicKeyException insecurePublicKeyException) {
                        // empty catch block
                    }
                }
            }
            this.addWurstCape(profile, map);
            class_310.method_1551().execute(() -> RenderSystem.recordRenderCall(() -> ImmutableList.of((Object)MinecraftProfileTexture.Type.SKIN, (Object)MinecraftProfileTexture.Type.CAPE).forEach(type -> {
                if (map.containsKey(type)) {
                    this.method_4651((MinecraftProfileTexture)map.get(type), (MinecraftProfileTexture.Type)type, callback);
                }
            })));
        };
        class_156.method_18349().execute(runnable);
        ci.cancel();
    }

    private void addWurstCape(GameProfile profile, HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture> map) {
        String name = profile.getName();
        String uuid = profile.getId().toString();
        try {
            if (capes == null) {
                this.setupWurstCapes();
            }
            if (capes.has(name)) {
                String capeURL = capes.get(name).getAsString();
                map.put(MinecraftProfileTexture.Type.CAPE, new MinecraftProfileTexture(capeURL, null));
            } else if (capes.has(uuid)) {
                String capeURL = capes.get(uuid).getAsString();
                map.put(MinecraftProfileTexture.Type.CAPE, new MinecraftProfileTexture(capeURL, null));
            }
        }
        catch (Exception e) {
            System.err.println("[Wurst] Failed to load cape for '" + name + "' (" + uuid + ")");
            e.printStackTrace();
        }
    }

    private void setupWurstCapes() {
        try {
            URL url = new URL("https://www.wurstclient.net/api/v1/capes.json");
            capes = JsonParser.parseReader((Reader)new InputStreamReader(url.openStream())).getAsJsonObject();
        }
        catch (Exception e) {
            System.err.println("[Wurst] Failed to load capes from wurstclient.net!");
            e.printStackTrace();
        }
    }

    @Shadow
    public class_2960 method_4651(MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type type, @Nullable class_1071.class_1072 callback) {
        return null;
    }
}

