/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.mixin;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.util.UUID;
import net.minecraft.class_1076;
import net.minecraft.class_1297;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_3678;
import net.minecraft.class_3966;
import net.minecraft.class_4093;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_7434;
import net.minecraft.class_746;
import net.minecraft.class_7853;
import net.wurstclient.WurstClient;
import net.wurstclient.event.EventManager;
import net.wurstclient.events.LeftClickListener;
import net.wurstclient.events.RightClickListener;
import net.wurstclient.mixinterface.IClientPlayerEntity;
import net.wurstclient.mixinterface.IClientPlayerInteractionManager;
import net.wurstclient.mixinterface.ILanguageManager;
import net.wurstclient.mixinterface.IMinecraftClient;
import net.wurstclient.mixinterface.IWorld;
import net.wurstclient.other_features.NoTelemetryOtf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_310.class})
public abstract class MinecraftClientMixin
extends class_4093<Runnable>
implements class_3678,
IMinecraftClient {
    @Shadow
    @Final
    public File field_1697;
    @Shadow
    private int field_1752;
    @Shadow
    private class_636 field_1761;
    @Shadow
    @Final
    private class_1076 field_1717;
    @Shadow
    private class_746 field_1724;
    @Shadow
    public class_638 field_1687;
    @Shadow
    @Final
    private class_320 field_1726;
    @Shadow
    @Final
    private YggdrasilAuthenticationService field_39420;
    private class_320 wurstSession;
    private class_7434 wurstProfileKeys;

    private MinecraftClientMixin(WurstClient wurst, String string_1) {
        super(string_1);
    }

    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/client/MinecraftClient;crosshairTarget:Lnet/minecraft/util/hit/HitResult;", ordinal=0)}, method={"doAttack()Z"}, cancellable=true)
    private void onDoAttack(CallbackInfoReturnable<Boolean> cir) {
        LeftClickListener.LeftClickEvent event = new LeftClickListener.LeftClickEvent();
        EventManager.fire(event);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/client/MinecraftClient;itemUseCooldown:I", ordinal=0)}, method={"doItemUse()V"}, cancellable=true)
    private void onDoItemUse(CallbackInfo ci) {
        RightClickListener.RightClickEvent event = new RightClickListener.RightClickEvent();
        EventManager.fire(event);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"doItemPick()V"})
    private void onDoItemPick(CallbackInfo ci) {
        if (!WurstClient.INSTANCE.isEnabled()) {
            return;
        }
        class_239 hitResult = WurstClient.MC.field_1765;
        if (hitResult == null || hitResult.method_17783() != class_239.class_240.field_1331) {
            return;
        }
        class_1297 entity = ((class_3966)hitResult).method_17782();
        WurstClient.INSTANCE.getFriends().middleClick(entity);
    }

    @Inject(at={@At(value="HEAD")}, method={"getSession()Lnet/minecraft/client/util/Session;"}, cancellable=true)
    private void onGetSession(CallbackInfoReturnable<class_320> cir) {
        if (this.wurstSession == null) {
            return;
        }
        cir.setReturnValue((Object)this.wurstSession);
    }

    @Redirect(at=@At(value="FIELD", target="Lnet/minecraft/client/MinecraftClient;session:Lnet/minecraft/client/util/Session;", opcode=180, ordinal=0), method={"getSessionProperties()Lcom/mojang/authlib/properties/PropertyMap;"})
    private class_320 getSessionForSessionProperties(class_310 mc) {
        if (this.wurstSession != null) {
            return this.wurstSession;
        }
        return this.field_1726;
    }

    @Inject(at={@At(value="HEAD")}, method={"getProfileKeys()Lnet/minecraft/client/util/ProfileKeys;"}, cancellable=true)
    private void onGetProfileKeys(CallbackInfoReturnable<class_7853> cir) {
        if (WurstClient.INSTANCE.getOtfs().noChatReportsOtf.isActive()) {
            cir.setReturnValue((Object)class_7853.field_40800);
        }
        if (this.wurstProfileKeys == null) {
            return;
        }
        cir.setReturnValue((Object)this.wurstProfileKeys);
    }

    @Inject(at={@At(value="HEAD")}, method={"isTelemetryEnabledByApi()Z"}, cancellable=true)
    private void onIsTelemetryEnabledByApi(CallbackInfoReturnable<Boolean> cir) {
        NoTelemetryOtf noTelemetryOtf = WurstClient.INSTANCE.getOtfs().noTelemetryOtf;
        cir.setReturnValue((Object)(!noTelemetryOtf.isEnabled() ? 1 : 0));
    }

    @Inject(at={@At(value="HEAD")}, method={"isOptionalTelemetryEnabledByApi()Z"}, cancellable=true)
    private void onIsOptionalTelemetryEnabledByApi(CallbackInfoReturnable<Boolean> cir) {
        NoTelemetryOtf noTelemetryOtf = WurstClient.INSTANCE.getOtfs().noTelemetryOtf;
        cir.setReturnValue((Object)(!noTelemetryOtf.isEnabled() ? 1 : 0));
    }

    @Override
    public void rightClick() {
        this.method_1583();
    }

    @Override
    public int getItemUseCooldown() {
        return this.field_1752;
    }

    @Override
    public void setItemUseCooldown(int itemUseCooldown) {
        this.field_1752 = itemUseCooldown;
    }

    @Override
    public IClientPlayerEntity getPlayer() {
        return (IClientPlayerEntity)this.field_1724;
    }

    @Override
    public IWorld getWorld() {
        return (IWorld)this.field_1687;
    }

    @Override
    public IClientPlayerInteractionManager getInteractionManager() {
        return (IClientPlayerInteractionManager)this.field_1761;
    }

    @Override
    public ILanguageManager getLanguageManager() {
        return (ILanguageManager)this.field_1717;
    }

    @Override
    public void setSession(class_320 session) {
        this.wurstSession = session;
        UserApiService userApiService = this.wurst_createUserApiService(session.method_1674());
        UUID uuid = this.wurstSession.method_1677().getId();
        this.wurstProfileKeys = new class_7434(userApiService, uuid, this.field_1697.toPath());
    }

    private UserApiService wurst_createUserApiService(String accessToken) {
        try {
            return this.field_39420.createUserApiService(accessToken);
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
            return UserApiService.OFFLINE;
        }
    }

    @Shadow
    private void method_1583() {
    }
}

