/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.keybinds;

import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.screens.ClickGuiScreen;
import net.wurstclient.command.CmdProcessor;
import net.wurstclient.events.KeyPressListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hack.HackList;
import net.wurstclient.keybinds.KeybindList;
import net.wurstclient.util.ChatUtils;

public final class KeybindProcessor
implements KeyPressListener {
    private final HackList hax;
    private final KeybindList keybinds;
    private final CmdProcessor cmdProcessor;

    public KeybindProcessor(HackList hax, KeybindList keybinds, CmdProcessor cmdProcessor) {
        this.hax = hax;
        this.keybinds = keybinds;
        this.cmdProcessor = cmdProcessor;
    }

    @Override
    public void onKeyPress(KeyPressListener.KeyPressEvent event) {
        if (event.getAction() != 1) {
            return;
        }
        class_437 screen = WurstClient.MC.field_1755;
        if (screen != null && !(screen instanceof ClickGuiScreen)) {
            return;
        }
        String keyName = this.getKeyName(event);
        String cmds = this.keybinds.getCommands(keyName);
        if (cmds == null) {
            return;
        }
        this.processCmds(cmds);
    }

    private String getKeyName(KeyPressListener.KeyPressEvent event) {
        int keyCode = event.getKeyCode();
        int scanCode = event.getScanCode();
        return class_3675.method_15985((int)keyCode, (int)scanCode).method_1441();
    }

    private void processCmds(String cmds) {
        cmds = cmds.replace(";", "\u00a7").replace("\u00a7\u00a7", ";");
        for (String cmd : cmds.split("\u00a7")) {
            this.processCmd(cmd.trim());
        }
    }

    private void processCmd(String cmd) {
        if (cmd.startsWith(".")) {
            this.cmdProcessor.process(cmd.substring(1));
        } else if (cmd.contains(" ")) {
            this.cmdProcessor.process(cmd);
        } else {
            Hack hack = this.hax.getHackByName(cmd);
            if (hack == null) {
                this.cmdProcessor.process(cmd);
                return;
            }
            if (!hack.isEnabled() && this.hax.tooManyHaxHack.isEnabled() && this.hax.tooManyHaxHack.isBlocked(hack)) {
                ChatUtils.error(hack.getName() + " is blocked by TooManyHax.");
                return;
            }
            hack.setEnabled(!hack.isEnabled());
        }
    }
}

