/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.class_1041;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.wurstclient.Category;
import net.wurstclient.Feature;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.events.KeyPressListener;
import net.wurstclient.hacks.TooManyHaxHack;
import net.wurstclient.other_features.TabGuiOtf;
import net.wurstclient.util.ChatUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class TabGui
implements KeyPressListener {
    private final ArrayList<Tab> tabs = new ArrayList();
    private final TabGuiOtf tabGuiOtf;
    private int width;
    private int height;
    private int selected;
    private boolean tabOpened;

    public TabGui() {
        this.tabGuiOtf = WurstClient.INSTANCE.getOtfs().tabGuiOtf;
        WurstClient.INSTANCE.getEventManager().add(KeyPressListener.class, this);
        LinkedHashMap<Category, Tab> tabMap = new LinkedHashMap<Category, Tab>();
        for (Category category : Category.values()) {
            tabMap.put(category, new Tab(category.getName()));
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.addAll(WurstClient.INSTANCE.getHax().getAllHax());
        features.addAll(WurstClient.INSTANCE.getCmds().getAllCmds());
        features.addAll(WurstClient.INSTANCE.getOtfs().getAllOtfs());
        for (Feature feature : features) {
            if (feature.getCategory() == null) continue;
            ((Tab)tabMap.get((Object)feature.getCategory())).add(feature);
        }
        this.tabs.addAll(tabMap.values());
        this.tabs.forEach(Tab::updateSize);
        this.updateSize();
    }

    private void updateSize() {
        this.width = 64;
        for (Tab tab : this.tabs) {
            int tabWidth = WurstClient.MC.field_1772.method_1727(tab.name) + 10;
            if (tabWidth <= this.width) continue;
            this.width = tabWidth;
        }
        this.height = this.tabs.size() * 10;
    }

    @Override
    public void onKeyPress(KeyPressListener.KeyPressEvent event) {
        if (event.getAction() != 1) {
            return;
        }
        if (this.tabGuiOtf.isHidden()) {
            return;
        }
        if (this.tabOpened) {
            switch (event.getKeyCode()) {
                case 263: {
                    this.tabOpened = false;
                    break;
                }
                default: {
                    this.tabs.get(this.selected).onKeyPress(event.getKeyCode());
                    break;
                }
            }
        } else {
            switch (event.getKeyCode()) {
                case 264: {
                    if (this.selected < this.tabs.size() - 1) {
                        ++this.selected;
                        break;
                    }
                    this.selected = 0;
                    break;
                }
                case 265: {
                    if (this.selected > 0) {
                        --this.selected;
                        break;
                    }
                    this.selected = this.tabs.size() - 1;
                    break;
                }
                case 262: {
                    this.tabOpened = true;
                }
            }
        }
    }

    public void render(class_332 context, float partialTicks) {
        class_4587 matrixStack = context.method_51448();
        if (this.tabGuiOtf.isHidden()) {
            return;
        }
        ClickGui gui = WurstClient.INSTANCE.getGui();
        int txtColor = gui.getTxtColor();
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        matrixStack.method_22903();
        class_1041 sr = WurstClient.MC.method_22683();
        int x = 2;
        int y = 23;
        matrixStack.method_46416((float)x, (float)y, 0.0f);
        this.drawBox(matrixStack, 0, 0, this.width, this.height);
        double factor = sr.method_4495();
        GL11.glScissor((int)((int)((double)x * factor)), (int)((int)((double)(sr.method_4502() - this.height - y) * factor)), (int)((int)((double)this.width * factor)), (int)((int)((double)this.height * factor)));
        GL11.glEnable((int)3089);
        int textY = 1;
        for (int i = 0; i < this.tabs.size(); ++i) {
            Object tabName = this.tabs.get((int)i).name;
            if (i == this.selected) {
                tabName = (this.tabOpened ? "<" : ">") + (String)tabName;
            }
            context.method_51433(WurstClient.MC.field_1772, (String)tabName, 2, textY, txtColor, false);
            textY += 10;
        }
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3089);
        if (this.tabOpened) {
            matrixStack.method_22903();
            Tab tab = this.tabs.get(this.selected);
            int tabX = x + this.width + 2;
            int tabY = y;
            matrixStack.method_46416((float)(this.width + 2), 0.0f, 0.0f);
            this.drawBox(matrixStack, 0, 0, tab.width, tab.height);
            GL11.glScissor((int)((int)((double)tabX * factor)), (int)((int)((double)(sr.method_4502() - tab.height - tabY) * factor)), (int)((int)((double)tab.width * factor)), (int)((int)((double)tab.height * factor)));
            GL11.glEnable((int)3089);
            int tabTextY = 1;
            for (int i = 0; i < tab.features.size(); ++i) {
                Feature feature = tab.features.get(i);
                Object fName = feature.getName();
                if (feature.isEnabled()) {
                    fName = "\u00a7a" + (String)fName + "\u00a7r";
                }
                if (i == tab.selected) {
                    fName = ">" + (String)fName;
                }
                context.method_51433(WurstClient.MC.field_1772, (String)fName, 2, tabTextY, txtColor, false);
                tabTextY += 10;
            }
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3089);
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
        GL11.glEnable((int)2884);
    }

    private void drawBox(class_4587 matrixStack, int x1, int y1, int x2, int y2) {
        ClickGui gui = WurstClient.INSTANCE.getGui();
        float[] bgColor = gui.getBgColor();
        float[] acColor = gui.getAcColor();
        float opacity = gui.getOpacity();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)bgColor[0], (float)bgColor[1], (float)bgColor[2], (float)opacity);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_1344();
        tessellator.method_1350();
        float xi1 = (float)x1 - 0.1f;
        float xi2 = (float)x2 + 0.1f;
        float yi1 = (float)y1 - 0.1f;
        float yi2 = (float)y2 + 0.1f;
        GL11.glLineWidth((float)1.0f);
        RenderSystem.setShaderColor((float)acColor[0], (float)acColor[1], (float)acColor[2], (float)0.5f);
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xi1, yi1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xi2, yi1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xi2, yi2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xi1, yi2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xi1, yi1, 0.0f).method_1344();
        tessellator.method_1350();
        xi1 = (float)((double)xi1 - 0.9);
        xi2 = (float)((double)xi2 + 0.9);
        yi1 = (float)((double)yi1 - 0.9);
        yi2 = (float)((double)yi2 + 0.9);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, xi2, yi1, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, xi1, yi1, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, xi1, yi1, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, xi1, yi2, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, xi2, yi1, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, xi2, yi2, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, xi2, yi2, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, xi1, yi2, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        tessellator.method_1350();
    }

    private static final class Tab {
        private final String name;
        private final ArrayList<Feature> features = new ArrayList();
        private int width;
        private int height;
        private int selected;

        public Tab(String name) {
            this.name = name;
        }

        public void updateSize() {
            this.width = 64;
            for (Feature feature : this.features) {
                int fWidth = WurstClient.MC.field_1772.method_1727(feature.getName()) + 10;
                if (fWidth <= this.width) continue;
                this.width = fWidth;
            }
            this.height = this.features.size() * 10;
        }

        public void onKeyPress(int keyCode) {
            switch (keyCode) {
                case 264: {
                    if (this.selected < this.features.size() - 1) {
                        ++this.selected;
                        break;
                    }
                    this.selected = 0;
                    break;
                }
                case 265: {
                    if (this.selected > 0) {
                        --this.selected;
                        break;
                    }
                    this.selected = this.features.size() - 1;
                    break;
                }
                case 257: {
                    this.onEnter();
                }
            }
        }

        private void onEnter() {
            Feature feature = this.features.get(this.selected);
            TooManyHaxHack tooManyHax = WurstClient.INSTANCE.getHax().tooManyHaxHack;
            if (tooManyHax.isEnabled() && tooManyHax.isBlocked(feature)) {
                ChatUtils.error(feature.getName() + " is blocked by TooManyHax.");
                return;
            }
            feature.doPrimaryAction();
        }

        public void add(Feature feature) {
            this.features.add(feature);
        }
    }
}

