/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks.autocomplete;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.wurstclient.hacks.autocomplete.MessageCompleter;
import net.wurstclient.hacks.autocomplete.ModelSettings;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonObject;

public final class OobaboogaMessageCompleter
extends MessageCompleter {
    public OobaboogaMessageCompleter(ModelSettings modelSettings) {
        super(modelSettings);
    }

    @Override
    protected JsonObject buildParams(String prompt) {
        JsonObject params = new JsonObject();
        params.addProperty("prompt", prompt);
        params.addProperty("max_length", (Number)this.modelSettings.maxTokens.getValueI());
        params.addProperty("temperature", (Number)this.modelSettings.temperature.getValue());
        params.addProperty("top_p", (Number)this.modelSettings.topP.getValue());
        params.addProperty("repetition_penalty", (Number)this.modelSettings.repetitionPenalty.getValue());
        params.addProperty("encoder_repetition_penalty", (Number)this.modelSettings.encoderRepetitionPenalty.getValue());
        JsonArray stoppingStrings = new JsonArray();
        stoppingStrings.add(this.modelSettings.stopSequence.getSelected().getSequence());
        params.add("stopping_strings", (JsonElement)stoppingStrings);
        return params;
    }

    @Override
    protected WsonObject requestCompletion(JsonObject parameters) throws IOException, JsonException {
        URL url = new URL(this.modelSettings.oobaboogaEndpoint.getValue());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        try (OutputStream os = conn.getOutputStream();){
            os.write(JsonUtils.GSON.toJson((JsonElement)parameters).getBytes());
            os.flush();
        }
        return JsonUtils.parseConnectionToObject(conn);
    }

    @Override
    protected String extractCompletion(WsonObject response) throws JsonException {
        String completion = response.getArray("results").getObject(0).getString("text");
        completion = completion.replace("\n", " ");
        return completion;
    }
}

