/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2879;
import net.minecraft.class_291;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.WurstClient;
import net.wurstclient.ai.PathFinder;
import net.wurstclient.ai.PathPos;
import net.wurstclient.ai.PathProcessor;
import net.wurstclient.commands.PathCmd;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.DontSaveState;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.treebot.Tree;
import net.wurstclient.treebot.TreeBotUtils;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.RotationUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

@SearchTags(value={"tree bot"})
@DontSaveState
public final class TreeBotHack
extends Hack
implements UpdateListener,
RenderListener {
    private final SliderSetting range = new SliderSetting("\u8303\u56f4", "TreeBot\u80fd\u591f\u7834\u574f\u65b9\u5757\u7684\u8ddd\u79bb\u3002", 4.5, 1.0, 6.0, 0.05, SliderSetting.ValueDisplay.DECIMAL);
    private TreeFinder treeFinder;
    private AngleFinder angleFinder;
    private TreeBotPathProcessor processor;
    private Tree tree;
    private class_2338 currentBlock;
    private float progress;
    private float prevProgress;

    public TreeBotHack() {
        super("\u780d\u6811\u673a\u5668\u4eba");
        this.setCategory(Category.BLOCKS);
        this.addSetting(this.range);
    }

    @Override
    public String getRenderName() {
        if (this.treeFinder != null && !this.treeFinder.isDone() && !this.treeFinder.isFailed()) {
            return this.getName() + " [Searching]";
        }
        if (this.processor != null && !this.processor.isDone()) {
            return this.getName() + " [Going]";
        }
        if (this.tree != null && !this.tree.getLogs().isEmpty()) {
            return this.getName() + " [Chopping]";
        }
        return this.getName();
    }

    @Override
    public void onEnable() {
        this.treeFinder = new TreeFinder();
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(RenderListener.class, this);
    }

    @Override
    public void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        PathProcessor.releaseControls();
        this.treeFinder = null;
        this.angleFinder = null;
        this.processor = null;
        if (this.tree != null) {
            this.tree.close();
            this.tree = null;
        }
        if (this.currentBlock != null) {
            IMC.getInteractionManager().setBreakingBlock(true);
            TreeBotHack.MC.field_1761.method_2925();
            this.currentBlock = null;
        }
    }

    @Override
    public void onUpdate() {
        if (this.treeFinder != null) {
            this.goToTree();
            return;
        }
        if (this.tree == null) {
            this.treeFinder = new TreeFinder();
            return;
        }
        this.tree.getLogs().removeIf(Predicate.not(TreeBotUtils::isLog));
        this.tree.compileBuffer();
        if (this.tree.getLogs().isEmpty()) {
            this.tree.close();
            this.tree = null;
            return;
        }
        if (this.angleFinder != null) {
            this.goToAngle();
            return;
        }
        ArrayList<class_2338> logsInRange = this.getLogsInRange();
        if (!logsInRange.isEmpty()) {
            this.breakBlocks(logsInRange);
            return;
        }
        if (this.angleFinder == null) {
            this.angleFinder = new AngleFinder();
        }
    }

    private void goToTree() {
        if (!this.treeFinder.isDoneOrFailed()) {
            PathProcessor.lockControls();
            this.treeFinder.findPath();
            return;
        }
        if (this.processor != null && !this.processor.isDone()) {
            this.processor.goToGoal();
            return;
        }
        PathProcessor.releaseControls();
        this.treeFinder = null;
    }

    private void goToAngle() {
        if (!this.angleFinder.isDone() && !this.angleFinder.isFailed()) {
            PathProcessor.lockControls();
            this.angleFinder.findPath();
            return;
        }
        if (this.processor != null && !this.processor.isDone()) {
            this.processor.goToGoal();
            return;
        }
        PathProcessor.releaseControls();
        this.angleFinder = null;
    }

    private ArrayList<class_2338> getLogsInRange() {
        class_243 eyesVec = RotationUtils.getEyesPos().method_1023(0.5, 0.5, 0.5);
        double rangeSq = Math.pow(this.range.getValue(), 2.0);
        return this.tree.getLogs().stream().filter(pos -> eyesVec.method_1025(class_243.method_24954((class_2382)pos)) <= rangeSq).filter(TreeBotUtils::hasLineOfSight).collect(Collectors.toCollection(ArrayList::new));
    }

    private void breakBlocks(ArrayList<class_2338> blocksInRange) {
        for (class_2338 pos : blocksInRange) {
            if (!this.breakBlock(pos)) continue;
            TreeBotHack.WURST.getHax().autoToolHack.equipBestTool(pos, false, true, 0);
            this.currentBlock = pos;
            break;
        }
        if (this.currentBlock == null) {
            TreeBotHack.MC.field_1761.method_2925();
        }
        if (this.currentBlock != null && BlockUtils.getHardness(this.currentBlock) < 1.0f) {
            this.prevProgress = this.progress;
            this.progress = IMC.getInteractionManager().getCurrentBreakingProgress();
            if (this.progress < this.prevProgress) {
                this.prevProgress = this.progress;
            }
        } else {
            this.progress = 1.0f;
            this.prevProgress = 1.0f;
        }
    }

    private boolean breakBlock(class_2338 pos) {
        class_2350 side = TreeBotUtils.getLineOfSightSide(RotationUtils.getEyesPos(), pos);
        class_243 relCenter = BlockUtils.getBoundingBox(pos).method_989((double)(-pos.method_10263()), (double)(-pos.method_10264()), (double)(-pos.method_10260())).method_1005();
        class_243 center = class_243.method_24954((class_2382)pos).method_1019(relCenter);
        class_2382 dirVec = side.method_10163();
        class_243 relHitVec = new class_243(relCenter.field_1352 * (double)dirVec.method_10263(), relCenter.field_1351 * (double)dirVec.method_10264(), relCenter.field_1350 * (double)dirVec.method_10260());
        class_243 hitVec = center.method_1019(relHitVec);
        WURST.getRotationFaker().faceVectorPacket(hitVec);
        if (!TreeBotHack.MC.field_1761.method_2902(pos, side)) {
            return false;
        }
        TreeBotHack.MC.field_1724.field_3944.method_2883((class_2596)new class_2879(class_1268.field_5808));
        return true;
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        RenderSystem.setShader(class_757::method_34539);
        PathCmd pathCmd = TreeBotHack.WURST.getCmds().pathCmd;
        if (this.treeFinder != null) {
            this.treeFinder.renderPath(matrixStack, pathCmd.isDebugMode(), pathCmd.isDepthTest());
        }
        if (this.angleFinder != null) {
            this.angleFinder.renderPath(matrixStack, pathCmd.isDebugMode(), pathCmd.isDepthTest());
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2929);
        if (this.tree != null) {
            this.drawTree(matrixStack);
        }
        if (this.currentBlock != null) {
            this.drawCurrentBlock(matrixStack, partialTicks);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
    }

    private void drawTree(class_4587 matrixStack) {
        RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
        matrixStack.method_22903();
        RenderUtils.applyRegionalRenderOffset(matrixStack, TreeBotHack.MC.field_1687.method_22350(this.tree.getStump()));
        Matrix4f viewMatrix = matrixStack.method_23760().method_23761();
        Matrix4f projMatrix = RenderSystem.getProjectionMatrix();
        class_5944 shader = RenderSystem.getShader();
        this.tree.getVertexBuffer().method_1353();
        this.tree.getVertexBuffer().method_34427(viewMatrix, projMatrix, shader);
        class_291.method_1354();
        matrixStack.method_22909();
    }

    private void drawCurrentBlock(class_4587 matrixStack, float partialTicks) {
        matrixStack.method_22903();
        class_2338 camPos = RenderUtils.getCameraBlockPos();
        int regionX = (camPos.method_10263() >> 9) * 512;
        int regionZ = (camPos.method_10260() >> 9) * 512;
        RenderUtils.applyRegionalRenderOffset(matrixStack, regionX, regionZ);
        class_238 box = new class_238(class_2338.field_10980);
        float p = this.prevProgress + (this.progress - this.prevProgress) * partialTicks;
        float red = p * 2.0f;
        float green = 2.0f - red;
        matrixStack.method_46416((float)(this.currentBlock.method_10263() - regionX), (float)this.currentBlock.method_10264(), (float)(this.currentBlock.method_10260() - regionZ));
        if (p < 1.0f) {
            matrixStack.method_22904(0.5, 0.5, 0.5);
            matrixStack.method_22905(p, p, p);
            matrixStack.method_22904(-0.5, -0.5, -0.5);
        }
        RenderSystem.setShaderColor((float)red, (float)green, (float)0.0f, (float)0.25f);
        RenderUtils.drawSolidBox(box, matrixStack);
        RenderSystem.setShaderColor((float)red, (float)green, (float)0.0f, (float)0.5f);
        RenderUtils.drawOutlinedBox(box, matrixStack);
        matrixStack.method_22909();
    }

    private ArrayList<class_2338> getNeighbors(class_2338 pos) {
        return BlockUtils.getAllInBoxStream(pos.method_10069(-1, -1, -1), pos.method_10069(1, 1, 1)).filter(TreeBotUtils::isLog).collect(Collectors.toCollection(ArrayList::new));
    }

    private class TreeFinder
    extends TreeBotPathFinder {
        public TreeFinder() {
            super(class_2338.method_49638((class_2374)WurstClient.MC.field_1724.method_19538()));
        }

        public TreeFinder(TreeBotPathFinder pathFinder) {
            super(pathFinder);
        }

        @Override
        protected boolean isMineable(class_2338 pos) {
            return TreeBotUtils.isLeaves(pos);
        }

        @Override
        protected boolean checkDone() {
            this.done = this.isNextToTreeStump(this.current);
            return this.done;
        }

        private boolean isNextToTreeStump(PathPos pos) {
            return this.isTreeStump(pos.method_10095()) || this.isTreeStump(pos.method_10078()) || this.isTreeStump(pos.method_10072()) || this.isTreeStump(pos.method_10067());
        }

        private boolean isTreeStump(class_2338 pos) {
            if (!TreeBotUtils.isLog(pos)) {
                return false;
            }
            if (TreeBotUtils.isLog(pos.method_10074())) {
                return false;
            }
            this.analyzeTree(pos);
            return TreeBotHack.this.tree.getLogs().size() <= 6;
        }

        private void analyzeTree(class_2338 stump) {
            ArrayList<class_2338> logs = new ArrayList<class_2338>(Arrays.asList(stump));
            ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>(Arrays.asList(stump));
            for (int i = 0; i < 1024 && !queue.isEmpty(); ++i) {
                class_2338 current = queue.pollFirst();
                for (class_2338 next : TreeBotHack.this.getNeighbors(current)) {
                    if (logs.contains(next)) continue;
                    logs.add(next);
                    queue.add(next);
                }
            }
            TreeBotHack.this.tree = new Tree(stump, logs);
        }

        @Override
        public void reset() {
            TreeBotHack.this.treeFinder = new TreeFinder(TreeBotHack.this.treeFinder);
        }
    }

    private class TreeBotPathProcessor {
        private final TreeBotPathFinder pathFinder;
        private final PathProcessor processor;

        public TreeBotPathProcessor(TreeBotPathFinder pathFinder) {
            this.pathFinder = pathFinder;
            this.processor = pathFinder.getProcessor();
        }

        public void goToGoal() {
            if (!this.pathFinder.isPathStillValid(this.processor.getIndex()) || this.processor.getTicksOffPath() > 20) {
                this.pathFinder.reset();
                return;
            }
            ArrayList<class_2338> leaves = this.getLeavesInRange(this.pathFinder.getPath());
            if (!leaves.isEmpty()) {
                TreeBotHack.this.breakBlocks(leaves);
                return;
            }
            this.processor.process();
        }

        private ArrayList<class_2338> getLeavesInRange(List<PathPos> path) {
            class_243 eyesVec = RotationUtils.getEyesPos().method_1023(0.5, 0.5, 0.5);
            double rangeSq = Math.pow(TreeBotHack.this.range.getValue(), 2.0);
            path = path.subList(this.processor.getIndex(), path.size());
            return path.stream().flatMap(pos -> Stream.of(pos, pos.method_10084())).distinct().filter(TreeBotUtils::isLeaves).filter(pos -> eyesVec.method_1025(class_243.method_24954((class_2382)pos)) <= rangeSq).filter(TreeBotUtils::hasLineOfSight).collect(Collectors.toCollection(ArrayList::new));
        }

        public final boolean isDone() {
            return this.processor.isDone();
        }
    }

    private class AngleFinder
    extends TreeBotPathFinder {
        public AngleFinder() {
            super(class_2338.method_49638((class_2374)WurstClient.MC.field_1724.method_19538()));
            this.setThinkSpeed(512);
            this.setThinkTime(1);
        }

        public AngleFinder(TreeBotPathFinder pathFinder) {
            super(pathFinder);
        }

        @Override
        protected boolean isMineable(class_2338 pos) {
            return TreeBotUtils.isLeaves(pos);
        }

        @Override
        protected boolean checkDone() {
            this.done = this.hasAngle(this.current);
            return this.done;
        }

        private boolean hasAngle(PathPos pos) {
            class_746 player = WurstClient.MC.field_1724;
            class_243 eyes = class_243.method_24955((class_2382)pos).method_1031(0.0, (double)player.method_18381(player.method_18376()), 0.0);
            class_243 eyesVec = eyes.method_1023(0.5, 0.5, 0.5);
            double rangeSq = Math.pow(TreeBotHack.this.range.getValue(), 2.0);
            for (class_2338 log : TreeBotHack.this.tree.getLogs()) {
                if (eyesVec.method_1025(class_243.method_24954((class_2382)log)) > rangeSq || TreeBotUtils.getLineOfSightSide(eyes, log) == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            TreeBotHack.this.angleFinder = new AngleFinder(TreeBotHack.this.angleFinder);
        }
    }

    private abstract class TreeBotPathFinder
    extends PathFinder {
        public TreeBotPathFinder(class_2338 goal) {
            super(goal);
        }

        public TreeBotPathFinder(TreeBotPathFinder pathFinder) {
            super(pathFinder);
        }

        public void findPath() {
            this.think();
            if (this.isDoneOrFailed()) {
                this.formatPath();
                TreeBotHack.this.processor = new TreeBotPathProcessor(this);
            }
        }

        public boolean isDoneOrFailed() {
            return this.isDone() || this.isFailed();
        }

        public abstract void reset();
    }
}

