/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2672;
import net.minecraft.class_2791;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.wurstclient.Category;
import net.wurstclient.events.PacketInputListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hacks.search.SearchArea;
import net.wurstclient.settings.BlockSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.BlockVertexCompiler;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.ChunkSearcher;
import net.wurstclient.util.MinPriorityThreadFactory;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.RotationUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class SearchHack
extends Hack
implements UpdateListener,
PacketInputListener,
RenderListener {
    private final BlockSetting block = new BlockSetting("\u65b9\u5757", "The type of block to search for.", "minecraft:diamond_ore", false);
    private final EnumSetting<SearchArea> area = new EnumSetting("\u533a\u57df", "\u73a9\u5bb6\u5468\u56f4\u8981\u641c\u7d22\u7684\u533a\u57df\u3002\n\u66f4\u5927\u7684\u503c\u9700\u8981\u66f4\u5feb\u7684\u7535\u8111\u3002", (Enum[])SearchArea.values(), (Enum)SearchArea.D11);
    private final SliderSetting limit = new SliderSetting("\u9650\u5236", "\u8981\u663e\u793a\u7684\u65b9\u5757\u7684\u6700\u5927\u6570\u91cf\u3002\n\u66f4\u5927\u7684\u503c\u9700\u8981\u66f4\u5feb\u7684\u7535\u8111\u3002", 4.0, 3.0, 6.0, 1.0, SliderSetting.ValueDisplay.LOGARITHMIC);
    private int prevLimit;
    private boolean notify;
    private final HashMap<class_2791, ChunkSearcher> searchers = new HashMap();
    private final Set<class_2791> chunksToUpdate = Collections.synchronizedSet(new HashSet());
    private ExecutorService pool1;
    private ForkJoinPool pool2;
    private ForkJoinTask<HashSet<class_2338>> getMatchingBlocksTask;
    private ForkJoinTask<ArrayList<int[]>> compileVerticesTask;
    private class_291 vertexBuffer;
    private boolean bufferUpToDate;

    public SearchHack() {
        super("\u5bfb\u627e\u65b9\u5757");
        this.setCategory(Category.RENDER);
        this.addSetting(this.block);
        this.addSetting(this.area);
        this.addSetting(this.limit);
    }

    @Override
    public String getRenderName() {
        return this.getName() + " [" + this.block.getBlockName().replace("minecraft:", "") + "]";
    }

    @Override
    public void onEnable() {
        this.prevLimit = this.limit.getValueI();
        this.notify = true;
        this.pool1 = MinPriorityThreadFactory.newFixedThreadPool();
        this.pool2 = new ForkJoinPool();
        this.bufferUpToDate = false;
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(PacketInputListener.class, this);
        EVENTS.add(RenderListener.class, this);
    }

    @Override
    public void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(PacketInputListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.stopPool2Tasks();
        this.pool1.shutdownNow();
        this.pool2.shutdownNow();
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
        this.chunksToUpdate.clear();
    }

    @Override
    public void onReceivedPacket(PacketInputListener.PacketInputEvent event) {
        class_2791 chunk;
        class_746 player = SearchHack.MC.field_1724;
        class_638 world = SearchHack.MC.field_1687;
        if (player == null || world == null) {
            return;
        }
        class_2596<?> packet = event.getPacket();
        if (packet instanceof class_2626) {
            class_2626 change = (class_2626)packet;
            class_2338 pos2 = change.method_11309();
            chunk = world.method_22350(pos2);
        } else if (packet instanceof class_2637) {
            class_2637 change = (class_2637)packet;
            ArrayList changedBlocks = new ArrayList();
            change.method_30621((pos, state) -> changedBlocks.add(pos));
            if (changedBlocks.isEmpty()) {
                return;
            }
            chunk = world.method_22350((class_2338)changedBlocks.get(0));
        } else if (packet instanceof class_2672) {
            class_2672 chunkData = (class_2672)packet;
            chunk = world.method_8497(chunkData.method_11523(), chunkData.method_11524());
        } else {
            return;
        }
        this.chunksToUpdate.add(chunk);
    }

    @Override
    public void onUpdate() {
        class_2248 currentBlock = this.block.getBlock();
        class_2338 eyesPos = class_2338.method_49638((class_2374)RotationUtils.getEyesPos());
        class_1923 center = SearchHack.MC.field_1724.method_31476();
        int dimensionId = SearchHack.MC.field_1687.method_27983().toString().hashCode();
        this.addSearchersInRange(center, currentBlock, dimensionId);
        this.removeSearchersOutOfRange(center);
        this.replaceSearchersWithDifferences(currentBlock, dimensionId);
        this.replaceSearchersWithChunkUpdate(currentBlock, dimensionId);
        if (!this.areAllChunkSearchersDone()) {
            return;
        }
        this.checkIfLimitChanged();
        if (this.getMatchingBlocksTask == null) {
            this.startGetMatchingBlocksTask(eyesPos);
        }
        if (!this.getMatchingBlocksTask.isDone()) {
            return;
        }
        if (this.compileVerticesTask == null) {
            this.startCompileVerticesTask();
        }
        if (!this.compileVerticesTask.isDone()) {
            return;
        }
        if (!this.bufferUpToDate) {
            this.setBufferFromTask();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2929);
        matrixStack.method_22903();
        RenderUtils.applyRegionalRenderOffset(matrixStack);
        float[] rainbow = RenderUtils.getRainbowColor();
        RenderSystem.setShaderColor((float)rainbow[0], (float)rainbow[1], (float)rainbow[2], (float)0.5f);
        RenderSystem.setShader(class_757::method_34539);
        if (this.vertexBuffer != null) {
            Matrix4f viewMatrix = matrixStack.method_23760().method_23761();
            Matrix4f projMatrix = RenderSystem.getProjectionMatrix();
            class_5944 shader = RenderSystem.getShader();
            this.vertexBuffer.method_1353();
            this.vertexBuffer.method_34427(viewMatrix, projMatrix, shader);
            class_291.method_1354();
        }
        matrixStack.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
    }

    private void addSearchersInRange(class_1923 center, class_2248 block, int dimensionId) {
        ArrayList<class_2791> chunksInRange = this.area.getSelected().getChunksInRange(center);
        for (class_2791 chunk : chunksInRange) {
            if (this.searchers.containsKey(chunk)) continue;
            this.addSearcher(chunk, block, dimensionId);
        }
    }

    private void removeSearchersOutOfRange(class_1923 center) {
        for (ChunkSearcher searcher : new ArrayList<ChunkSearcher>(this.searchers.values())) {
            class_1923 searcherPos = searcher.getChunk().method_12004();
            if (this.area.getSelected().isInRange(searcherPos, center)) continue;
            this.removeSearcher(searcher);
        }
    }

    private void replaceSearchersWithDifferences(class_2248 currentBlock, int dimensionId) {
        for (ChunkSearcher oldSearcher : new ArrayList<ChunkSearcher>(this.searchers.values())) {
            if (currentBlock.equals(oldSearcher.getBlock()) && dimensionId == oldSearcher.getDimensionId()) continue;
            this.removeSearcher(oldSearcher);
            this.addSearcher(oldSearcher.getChunk(), currentBlock, dimensionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSearchersWithChunkUpdate(class_2248 currentBlock, int dimensionId) {
        Set<class_2791> set = this.chunksToUpdate;
        synchronized (set) {
            if (this.chunksToUpdate.isEmpty()) {
                return;
            }
            Iterator<class_2791> itr = this.chunksToUpdate.iterator();
            while (itr.hasNext()) {
                class_2791 chunk = itr.next();
                ChunkSearcher oldSearcher = this.searchers.get(chunk);
                if (oldSearcher == null) continue;
                this.removeSearcher(oldSearcher);
                this.addSearcher(chunk, currentBlock, dimensionId);
                itr.remove();
            }
        }
    }

    private void addSearcher(class_2791 chunk, class_2248 block, int dimensionId) {
        this.stopPool2Tasks();
        ChunkSearcher searcher = new ChunkSearcher(chunk, block, dimensionId);
        this.searchers.put(chunk, searcher);
        searcher.startSearching(this.pool1);
    }

    private void removeSearcher(ChunkSearcher searcher) {
        this.stopPool2Tasks();
        this.searchers.remove(searcher.getChunk());
        searcher.cancelSearching();
    }

    private void stopPool2Tasks() {
        if (this.getMatchingBlocksTask != null) {
            this.getMatchingBlocksTask.cancel(true);
            this.getMatchingBlocksTask = null;
        }
        if (this.compileVerticesTask != null) {
            this.compileVerticesTask.cancel(true);
            this.compileVerticesTask = null;
        }
        this.bufferUpToDate = false;
    }

    private boolean areAllChunkSearchersDone() {
        for (ChunkSearcher searcher : this.searchers.values()) {
            if (searcher.getStatus() == ChunkSearcher.Status.DONE) continue;
            return false;
        }
        return true;
    }

    private void checkIfLimitChanged() {
        if (this.limit.getValueI() != this.prevLimit) {
            this.stopPool2Tasks();
            this.notify = true;
            this.prevLimit = this.limit.getValueI();
        }
    }

    private void startGetMatchingBlocksTask(class_2338 eyesPos) {
        int maxBlocks = (int)Math.pow(10.0, this.limit.getValueI());
        Callable<HashSet> task = () -> this.searchers.values().parallelStream().flatMap(searcher -> searcher.getMatchingBlocks().stream()).sorted(Comparator.comparingInt(pos -> eyesPos.method_19455((class_2382)pos))).limit(maxBlocks).collect(Collectors.toCollection(HashSet::new));
        this.getMatchingBlocksTask = this.pool2.submit(task);
    }

    private HashSet<class_2338> getMatchingBlocksFromTask() {
        HashSet<Object> matchingBlocks = new HashSet();
        try {
            matchingBlocks = this.getMatchingBlocksTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        int maxBlocks = (int)Math.pow(10.0, this.limit.getValueI());
        if (matchingBlocks.size() < maxBlocks) {
            this.notify = true;
        } else if (this.notify) {
            ChatUtils.warning("Search found \u00a7lA LOT\u00a7r of blocks! To prevent lag, it will only show the closest \u00a76" + this.limit.getValueString() + "\u00a7r results.");
            this.notify = false;
        }
        return matchingBlocks;
    }

    private void startCompileVerticesTask() {
        HashSet<class_2338> matchingBlocks = this.getMatchingBlocksFromTask();
        class_2338 camPos = RenderUtils.getCameraBlockPos();
        int regionX = (camPos.method_10263() >> 9) * 512;
        int regionZ = (camPos.method_10260() >> 9) * 512;
        Callable<ArrayList> task = () -> BlockVertexCompiler.compile(matchingBlocks, regionX, regionZ);
        this.compileVerticesTask = this.pool2.submit(task);
    }

    private void setBufferFromTask() {
        ArrayList<int[]> vertices = this.getVerticesFromTask();
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
        this.vertexBuffer = new class_291(class_291.class_8555.field_44793);
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        for (int[] vertex : vertices) {
            bufferBuilder.method_22912((double)vertex[0], (double)vertex[1], (double)vertex[2]).method_1344();
        }
        class_287.class_7433 buffer = bufferBuilder.method_1326();
        this.vertexBuffer.method_1353();
        this.vertexBuffer.method_1352(buffer);
        class_291.method_1354();
        this.bufferUpToDate = true;
    }

    private ArrayList<int[]> getVerticesFromTask() {
        try {
            return this.compileVerticesTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

