/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2672;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.PacketInputListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.MinPriorityThreadFactory;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.RotationUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

@SearchTags(value={"mob spawn esp", "LightLevelESP", "light level esp", "LightLevelOverlay", "light level overlay"})
public final class MobSpawnEspHack
extends Hack
implements UpdateListener,
PacketInputListener,
RenderListener {
    private final EnumSetting<DrawDistance> drawDistance = new EnumSetting("\u7ed8\u5236\u8ddd\u79bb", (Enum[])DrawDistance.values(), (Enum)DrawDistance.D9);
    private final SliderSetting loadingSpeed = new SliderSetting("\u52a0\u8f7d\u901f\u5ea6", 1.0, 1.0, 5.0, 1.0, SliderSetting.ValueDisplay.INTEGER.withSuffix("x"));
    private final CheckboxSetting depthTest = new CheckboxSetting("\u6df1\u5ea6\u6d4b\u8bd5", true);
    private final HashMap<class_2791, ChunkScanner> scanners = new HashMap();
    private ExecutorService pool;

    public MobSpawnEspHack() {
        super("\u602a\u7269\u5237\u65b0\u533a");
        this.setCategory(Category.RENDER);
        this.addSetting(this.drawDistance);
        this.addSetting(this.loadingSpeed);
        this.addSetting(this.depthTest);
    }

    @Override
    public void onEnable() {
        this.pool = MinPriorityThreadFactory.newFixedThreadPool();
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(PacketInputListener.class, this);
        EVENTS.add(RenderListener.class, this);
    }

    @Override
    public void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(PacketInputListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        for (ChunkScanner scanner : new ArrayList<ChunkScanner>(this.scanners.values())) {
            if (scanner.vertexBuffer != null) {
                scanner.vertexBuffer.close();
            }
            this.scanners.remove(scanner.chunk);
        }
        this.pool.shutdownNow();
    }

    @Override
    public void onUpdate() {
        class_638 world = MobSpawnEspHack.MC.field_1687;
        class_2338 eyesBlock = class_2338.method_49638((class_2374)RotationUtils.getEyesPos());
        int chunkX = eyesBlock.method_10263() >> 4;
        int chunkZ = eyesBlock.method_10260() >> 4;
        int chunkRange = this.drawDistance.getSelected().chunkRange;
        ArrayList<class_2818> chunks = new ArrayList<class_2818>();
        for (int x = chunkX - chunkRange; x <= chunkX + chunkRange; ++x) {
            for (int i = chunkZ - chunkRange; i <= chunkZ + chunkRange; ++i) {
                chunks.add(world.method_8497(x, i));
            }
        }
        for (class_2791 class_27912 : chunks) {
            if (this.scanners.containsKey(class_27912)) continue;
            ChunkScanner scanner = new ChunkScanner(class_27912);
            this.scanners.put(class_27912, scanner);
            scanner.future = this.pool.submit(() -> scanner.scan());
        }
        for (ChunkScanner chunkScanner : new ArrayList<ChunkScanner>(this.scanners.values())) {
            if (Math.abs(chunkScanner.chunk.method_12004().field_9181 - chunkX) <= chunkRange && Math.abs(chunkScanner.chunk.method_12004().field_9180 - chunkZ) <= chunkRange || !chunkScanner.doneCompiling) continue;
            if (chunkScanner.vertexBuffer != null) {
                chunkScanner.vertexBuffer.close();
            }
            if (chunkScanner.future != null) {
                chunkScanner.future.cancel(true);
            }
            this.scanners.remove(chunkScanner.chunk);
        }
        Comparator<ChunkScanner> c = Comparator.comparingInt(s -> Math.abs(s.chunk.method_12004().field_9181 - chunkX) + Math.abs(s.chunk.method_12004().field_9180 - chunkZ));
        List list = this.scanners.values().stream().filter(s -> s.doneScanning).filter(s -> !s.doneCompiling).sorted(c).limit(this.loadingSpeed.getValueI()).collect(Collectors.toList());
        for (ChunkScanner scanner : list) {
            try {
                scanner.compileBuffer();
            }
            catch (ConcurrentModificationException e) {
                System.out.println("WARNING! ChunkScanner.compileDisplayList(); failed with the following exception:");
                e.printStackTrace();
                if (scanner.vertexBuffer == null) continue;
                scanner.vertexBuffer.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onReceivedPacket(PacketInputListener.PacketInputEvent event) {
        class_2791 chunk;
        class_746 player = MobSpawnEspHack.MC.field_1724;
        class_638 world = MobSpawnEspHack.MC.field_1687;
        if (player == null || world == null) {
            return;
        }
        class_2596<?> packet = event.getPacket();
        if (packet instanceof class_2626) {
            class_2626 change = (class_2626)packet;
            class_2338 class_23382 = change.method_11309();
            chunk = world.method_22350(class_23382);
        } else if (packet instanceof class_2637) {
            class_2637 change = (class_2637)packet;
            ArrayList arrayList = new ArrayList();
            change.method_30621((pos, state) -> changedBlocks.add(pos));
            if (arrayList.isEmpty()) {
                return;
            }
            chunk = world.method_22350((class_2338)arrayList.get(0));
        } else if (packet instanceof class_2672) {
            class_2672 chunkData = (class_2672)packet;
            chunk = world.method_8497(chunkData.method_11523(), chunkData.method_11524());
        } else {
            return;
        }
        ArrayList<class_2818> chunks = new ArrayList<class_2818>();
        for (int x = chunk.method_12004().field_9181 - 1; x <= chunk.method_12004().field_9181 + 1; ++x) {
            void var9_10;
            int n = chunk.method_12004().field_9180 - 1;
            while (var9_10 <= chunk.method_12004().field_9180 + 1) {
                chunks.add(world.method_8497(x, (int)var9_10));
                ++var9_10;
            }
        }
        for (class_2791 class_27912 : chunks) {
            ChunkScanner scanner = this.scanners.get(class_27912);
            if (scanner == null) {
                return;
            }
            scanner.reset();
            scanner.future = this.pool.submit(() -> scanner.scan());
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        boolean depthTest = this.depthTest.isChecked();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (!depthTest) {
            GL11.glDisable((int)2929);
        }
        GL11.glEnable((int)2884);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34540);
        for (ChunkScanner scanner : new ArrayList<ChunkScanner>(this.scanners.values())) {
            if (scanner.vertexBuffer == null) continue;
            matrixStack.method_22903();
            RenderUtils.applyRegionalRenderOffset(matrixStack, scanner.chunk);
            Matrix4f viewMatrix = matrixStack.method_23760().method_23761();
            Matrix4f projMatrix = RenderSystem.getProjectionMatrix();
            class_5944 shader = RenderSystem.getShader();
            scanner.vertexBuffer.method_1353();
            scanner.vertexBuffer.method_34427(viewMatrix, projMatrix, shader);
            class_291.method_1354();
            matrixStack.method_22909();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!depthTest) {
            GL11.glEnable((int)2929);
        }
        GL11.glDisable((int)3042);
    }

    private static enum DrawDistance {
        D3("3x3 chunks", 1),
        D5("5x5 chunks", 2),
        D7("7x7 chunks", 3),
        D9("9x9 chunks", 4),
        D11("11x11 chunks", 5),
        D13("13x13 chunks", 6),
        D15("15x15 chunks", 7),
        D17("17x17 chunks", 8),
        D19("19x19 chunks", 9),
        D21("21x21 chunks", 10),
        D23("23x23 chunks", 11),
        D25("25x25 chunks", 12);

        private final String name;
        private final int chunkRange;

        private DrawDistance(String name, int chunkRange) {
            this.name = name;
            this.chunkRange = chunkRange;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class ChunkScanner {
        public Future<?> future;
        private final class_2791 chunk;
        private final Set<class_2338> red = new HashSet<class_2338>();
        private final Set<class_2338> yellow = new HashSet<class_2338>();
        private class_291 vertexBuffer;
        private boolean doneScanning;
        private boolean doneCompiling;

        public ChunkScanner(class_2791 chunk) {
            this.chunk = chunk;
        }

        private void scan() {
            class_638 world = MC.field_1687;
            ArrayList<class_2338> blocks = new ArrayList<class_2338>();
            int minX = this.chunk.method_12004().method_8326();
            int minY = world.method_31607();
            int minZ = this.chunk.method_12004().method_8328();
            int maxX = this.chunk.method_12004().method_8327();
            int maxY = world.method_31600();
            int maxZ = this.chunk.method_12004().method_8329();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        class_2680 stateDown;
                        class_2338 pos2 = new class_2338(x, y, z);
                        class_2680 state = world.method_8320(pos2);
                        if (state.method_51366() || !state.method_26227().method_15769() || !(stateDown = world.method_8320(pos2.method_10074())).method_26170((class_1922)world, pos2.method_10074(), class_1299.field_6051)) continue;
                        blocks.add(pos2);
                    }
                }
            }
            if (Thread.interrupted()) {
                return;
            }
            this.red.addAll(blocks.stream().filter(pos -> world.method_8314(class_1944.field_9282, pos) < 1).filter(pos -> world.method_8314(class_1944.field_9284, pos) < 8).collect(Collectors.toList()));
            if (Thread.interrupted()) {
                return;
            }
            this.yellow.addAll(blocks.stream().filter(pos -> !this.red.contains(pos)).filter(pos -> world.method_8314(class_1944.field_9282, pos) < 1).collect(Collectors.toList()));
            this.doneScanning = true;
        }

        private void compileBuffer() {
            int regionX = (this.chunk.method_12004().method_8326() >> 9) * 512;
            int regionZ = (this.chunk.method_12004().method_8328() >> 9) * 512;
            if (this.vertexBuffer != null) {
                this.vertexBuffer.close();
            }
            this.vertexBuffer = new class_291(class_291.class_8555.field_44793);
            class_289 tessellator = RenderSystem.renderThreadTesselator();
            class_287 bufferBuilder = tessellator.method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
            new ArrayList<class_2338>(this.red).stream().filter(Objects::nonNull).map(pos -> new class_2338(pos.method_10263() - regionX, pos.method_10264(), pos.method_10260() - regionZ)).forEach(pos -> {
                bufferBuilder.method_22912((double)pos.method_10263(), (double)pos.method_10264() + 0.01, (double)pos.method_10260()).method_22915(1.0f, 0.0f, 0.0f, 0.5f).method_1344();
                bufferBuilder.method_22912((double)(pos.method_10263() + 1), (double)pos.method_10264() + 0.01, (double)(pos.method_10260() + 1)).method_22915(1.0f, 0.0f, 0.0f, 0.5f).method_1344();
                bufferBuilder.method_22912((double)(pos.method_10263() + 1), (double)pos.method_10264() + 0.01, (double)pos.method_10260()).method_22915(1.0f, 0.0f, 0.0f, 0.5f).method_1344();
                bufferBuilder.method_22912((double)pos.method_10263(), (double)pos.method_10264() + 0.01, (double)(pos.method_10260() + 1)).method_22915(1.0f, 0.0f, 0.0f, 0.5f).method_1344();
            });
            new ArrayList<class_2338>(this.yellow).stream().filter(Objects::nonNull).map(pos -> new class_2338(pos.method_10263() - regionX, pos.method_10264(), pos.method_10260() - regionZ)).forEach(pos -> {
                bufferBuilder.method_22912((double)pos.method_10263(), (double)pos.method_10264() + 0.01, (double)pos.method_10260()).method_22915(1.0f, 1.0f, 0.0f, 0.5f).method_1344();
                bufferBuilder.method_22912((double)(pos.method_10263() + 1), (double)pos.method_10264() + 0.01, (double)(pos.method_10260() + 1)).method_22915(1.0f, 1.0f, 0.0f, 0.5f).method_1344();
                bufferBuilder.method_22912((double)(pos.method_10263() + 1), (double)pos.method_10264() + 0.01, (double)pos.method_10260()).method_22915(1.0f, 1.0f, 0.0f, 0.5f).method_1344();
                bufferBuilder.method_22912((double)pos.method_10263(), (double)pos.method_10264() + 0.01, (double)(pos.method_10260() + 1)).method_22915(1.0f, 1.0f, 0.0f, 0.5f).method_1344();
            });
            class_287.class_7433 buffer = bufferBuilder.method_1326();
            this.vertexBuffer.method_1353();
            this.vertexBuffer.method_1352(buffer);
            class_291.method_1354();
            this.doneCompiling = true;
        }

        private void reset() {
            if (this.future != null) {
                this.future.cancel(true);
            }
            this.red.clear();
            this.yellow.clear();
            this.doneScanning = false;
            this.doneCompiling = false;
        }
    }
}

