/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.commands;

import net.minecraft.class_151;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.wurstclient.DontBlock;
import net.wurstclient.Feature;
import net.wurstclient.command.CmdError;
import net.wurstclient.command.CmdException;
import net.wurstclient.command.CmdSyntaxError;
import net.wurstclient.command.Command;
import net.wurstclient.settings.BlockSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.CmdUtils;
import net.wurstclient.util.MathUtils;

@DontBlock
public final class SetBlockCmd
extends Command {
    public SetBlockCmd() {
        super("setblock", "Changes a block setting of a feature. Allows you\nto change these settings through keybinds.", ".setblock <feature> <setting> <block>", ".setblock <feature> <setting> reset", "Example: .setblock Nuker ID dirt");
    }

    @Override
    public void call(String[] args) throws CmdException {
        if (args.length != 3) {
            throw new CmdSyntaxError();
        }
        Feature feature = CmdUtils.findFeature(args[0]);
        Setting setting = CmdUtils.findSetting(feature, args[1]);
        BlockSetting blockSetting = this.getAsBlockSetting(feature, setting);
        this.setBlock(blockSetting, args[2]);
    }

    private BlockSetting getAsBlockSetting(Feature feature, Setting setting) throws CmdError {
        if (!(setting instanceof BlockSetting)) {
            throw new CmdError(feature.getName() + " " + setting.getName() + " is not a block setting.");
        }
        return (BlockSetting)setting;
    }

    private void setBlock(BlockSetting setting, String value) throws CmdSyntaxError {
        if (value.toLowerCase().equals("reset")) {
            setting.resetToDefault();
            return;
        }
        class_2248 block = this.getBlockFromNameOrID(value);
        if (block == null) {
            throw new CmdSyntaxError("\"" + value + "\" is not a valid block.");
        }
        setting.setBlock(block);
    }

    private class_2248 getBlockFromNameOrID(String nameOrId) {
        if (MathUtils.isInteger(nameOrId)) {
            class_2680 state = (class_2680)class_2248.field_10651.method_10200(Integer.parseInt(nameOrId));
            if (state == null) {
                return null;
            }
            return state.method_26204();
        }
        try {
            return class_7923.field_41175.method_17966(new class_2960(nameOrId)).orElse(null);
        }
        catch (class_151 e) {
            return null;
        }
    }
}

