/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.screens.EditTextFieldScreen;
import net.wurstclient.settings.TextFieldSetting;
import net.wurstclient.util.ChatUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class TextFieldEditButton
extends Component {
    protected static final class_310 MC = WurstClient.MC;
    private final TextFieldSetting setting;

    public TextFieldEditButton(TextFieldSetting setting) {
        this.setting = Objects.requireNonNull(setting);
        this.setWidth(this.getDefaultWidth());
        this.setHeight(this.getDefaultHeight());
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (mouseY < (double)(this.getY() + 11)) {
            return;
        }
        switch (mouseButton) {
            case 0: {
                MC.method_1507((class_437)new EditTextFieldScreen(TextFieldEditButton.MC.field_1755, this.setting));
                break;
            }
            case 1: {
                this.setting.resetToDefault();
            }
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
        ClickGui gui = WurstClient.INSTANCE.getGui();
        float[] bgColor = gui.getBgColor();
        float[] acColor = gui.getAcColor();
        int txtColor = gui.getTxtColor();
        float opacity = gui.getOpacity();
        int x1 = this.getX();
        int x2 = x1 + this.getWidth();
        int y1 = this.getY();
        int y2 = y1 + this.getHeight();
        int y3 = y1 + 11;
        int scroll = this.getParent().isScrollingEnabled() ? this.getParent().getScrollOffset() : 0;
        boolean hovering = mouseX >= x1 && mouseY >= y1 && mouseX < x2 && mouseY < y2 && mouseY >= -scroll && mouseY < this.getParent().getHeight() - 13 - scroll;
        boolean hText = hovering && mouseY < y3;
        boolean hBox = hovering && mouseY >= y3;
        class_327 tr = TextFieldEditButton.MC.field_1772;
        class_4587 matrixStack = context.method_51448();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        if (hText) {
            gui.setTooltip(ChatUtils.wrapText(this.setting.getDescription(), 200));
        } else if (hBox) {
            gui.setTooltip(ChatUtils.wrapText(this.setting.getValue(), 200));
        }
        RenderSystem.setShaderColor((float)bgColor[0], (float)bgColor[1], (float)bgColor[2], (float)opacity);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)bgColor[0], (float)bgColor[1], (float)bgColor[2], (float)(hBox ? opacity * 1.5f : opacity));
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y3, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y3, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)acColor[0], (float)acColor[1], (float)acColor[2], (float)0.5f);
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y3, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y3, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y3, 0.0f).method_1344();
        tessellator.method_1350();
        int maxLength = tr.method_27527().method_35715(this.setting.getValue(), this.getWidth() - 8, class_2583.field_24360);
        Object value = this.setting.getValue();
        if (maxLength < ((String)value).length()) {
            value = ((String)value).substring(0, maxLength) + "...";
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_51433(tr, this.setting.getName(), x1, y1 + 2, txtColor, false);
        context.method_51433(tr, (String)value, x1 + 2, y3 + 2, txtColor, false);
        GL11.glEnable((int)3042);
    }

    @Override
    public int getDefaultWidth() {
        class_327 tr = TextFieldEditButton.MC.field_1772;
        return tr.method_1727(this.setting.getName()) + 4;
    }

    @Override
    public int getDefaultHeight() {
        return 22;
    }
}

