/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.wurstclient.Feature;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.SettingsWindow;
import net.wurstclient.clickgui.Window;
import net.wurstclient.hacks.TooManyHaxHack;
import net.wurstclient.util.ChatUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class FeatureButton
extends Component {
    private final class_310 MC = WurstClient.MC;
    private final ClickGui GUI = WurstClient.INSTANCE.getGui();
    private final Feature feature;
    private final boolean hasSettings;
    private Window settingsWindow;

    public FeatureButton(Feature feature) {
        this.feature = Objects.requireNonNull(feature);
        this.setWidth(this.getDefaultWidth());
        this.setHeight(this.getDefaultHeight());
        this.hasSettings = !feature.getSettings().isEmpty();
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return;
        }
        if (this.hasSettings && (mouseX > (double)(this.getX() + this.getWidth() - 12) || this.feature.getPrimaryAction().isEmpty())) {
            if (this.isSettingsWindowOpen()) {
                this.closeSettingsWindow();
            } else {
                this.openSettingsWindow();
            }
            return;
        }
        TooManyHaxHack tooManyHax = WurstClient.INSTANCE.getHax().tooManyHaxHack;
        if (tooManyHax.isEnabled() && tooManyHax.isBlocked(this.feature)) {
            ChatUtils.error(this.feature.getName() + " is blocked by TooManyHax.");
            return;
        }
        this.feature.doPrimaryAction();
    }

    private boolean isSettingsWindowOpen() {
        return this.settingsWindow != null && !this.settingsWindow.isClosing();
    }

    private void openSettingsWindow() {
        this.settingsWindow = new SettingsWindow(this.feature, this.getParent(), this.getY());
        this.GUI.addWindow(this.settingsWindow);
    }

    private void closeSettingsWindow() {
        this.settingsWindow.close();
        this.settingsWindow = null;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
        class_4587 matrixStack = context.method_51448();
        int x1 = this.getX();
        int x2 = x1 + this.getWidth();
        int x3 = this.hasSettings ? x2 - 11 : x2;
        int y1 = this.getY();
        int y2 = y1 + this.getHeight();
        boolean hovering = this.isHovering(mouseX, mouseY, x1, x2, y1, y2);
        boolean hHack = hovering && mouseX < x3;
        boolean hSettings = hovering && mouseX >= x3;
        RenderSystem.setShader(class_757::method_34539);
        if (hHack) {
            this.setTooltip();
        }
        this.drawButtonBackground(matrixStack, x1, x3, y1, y2, hHack);
        if (this.hasSettings) {
            this.drawSettingsBackground(matrixStack, x2, x3, y1, y2, hSettings);
        }
        this.drawOutline(matrixStack, x1, x2, y1, y2);
        if (this.hasSettings) {
            this.drawSeparator(matrixStack, x3, y1, y2);
            this.drawSettingsArrow(matrixStack, x2, x3, y1, y2, hSettings);
        }
        this.drawName(context, x1, x3, y1);
    }

    private boolean isHovering(int mouseX, int mouseY, int x1, int x2, int y1, int y2) {
        Window parent = this.getParent();
        boolean scrollEnabled = parent.isScrollingEnabled();
        int scroll = scrollEnabled ? parent.getScrollOffset() : 0;
        return mouseX >= x1 && mouseY >= y1 && mouseX < x2 && mouseY < y2 && mouseY >= -scroll && mouseY < parent.getHeight() - 13 - scroll;
    }

    private void setTooltip() {
        String tooltip = this.feature.getWrappedDescription(200);
        this.GUI.setTooltip(tooltip);
    }

    private void drawButtonBackground(class_4587 matrixStack, int x1, int x3, int y1, int y2, boolean hHack) {
        float[] bgColor = this.GUI.getBgColor();
        float opacity = this.GUI.getOpacity();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        if (this.feature.isEnabled()) {
            RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)(hHack ? opacity * 1.5f : opacity));
        } else {
            RenderSystem.setShaderColor((float)bgColor[0], (float)bgColor[1], (float)bgColor[2], (float)(hHack ? opacity * 1.5f : opacity));
        }
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x3, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x3, (float)y1, 0.0f).method_1344();
        tessellator.method_1350();
    }

    private void drawSettingsBackground(class_4587 matrixStack, int x2, int x3, int y1, int y2, boolean hSettings) {
        float[] bgColor = this.GUI.getBgColor();
        float opacity = this.GUI.getOpacity();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        RenderSystem.setShaderColor((float)bgColor[0], (float)bgColor[1], (float)bgColor[2], (float)(hSettings ? opacity * 1.5f : opacity));
        bufferBuilder.method_22918(matrix, (float)x3, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x3, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_1344();
        tessellator.method_1350();
    }

    private void drawOutline(class_4587 matrixStack, int x1, int x2, int y1, int y2) {
        float[] acColor = this.GUI.getAcColor();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1592);
        RenderSystem.setShaderColor((float)acColor[0], (float)acColor[1], (float)acColor[2], (float)0.5f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_1344();
        tessellator.method_1350();
    }

    private void drawSeparator(class_4587 matrixStack, int x3, int y1, int y2) {
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x3, (float)y2, 0.0f).method_1344();
        tessellator.method_1350();
    }

    private void drawSettingsArrow(class_4587 matrixStack, int x2, int x3, int y1, int y2, boolean hSettings) {
        float ya2;
        float ya1;
        float xa1 = x3 + 1;
        float xa2 = (float)(x3 + x2) / 2.0f;
        float xa3 = x2 - 1;
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        if (this.isSettingsWindowOpen()) {
            ya1 = (float)y2 - 3.5f;
            ya2 = y1 + 3;
            RenderSystem.setShaderColor((float)(hSettings ? 1.0f : 0.85f), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            ya1 = (float)y1 + 3.5f;
            ya2 = y2 - 3;
            RenderSystem.setShaderColor((float)0.0f, (float)(hSettings ? 1.0f : 0.85f), (float)0.0f, (float)1.0f);
        }
        bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xa1, ya1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xa3, ya1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xa2, ya2, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)0.0625f, (float)0.0625f, (float)0.0625f, (float)0.5f);
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xa1, ya1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xa3, ya1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xa2, ya2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xa1, ya1, 0.0f).method_1344();
        tessellator.method_1350();
    }

    private void drawName(class_332 context, int x1, int x3, int y1) {
        ClickGui gui = WurstClient.INSTANCE.getGui();
        int txtColor = gui.getTxtColor();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_327 tr = this.MC.field_1772;
        String name = this.feature.getName();
        int nameWidth = tr.method_1727(name);
        int tx = x1 + (x3 - x1 - nameWidth) / 2;
        int ty = y1 + 2;
        context.method_51433(tr, name, tx, ty, txtColor, false);
        GL11.glEnable((int)3042);
    }

    @Override
    public int getDefaultWidth() {
        String name = this.feature.getName();
        class_327 tr = this.MC.field_1772;
        int width = tr.method_1727(name) + 4;
        if (this.hasSettings) {
            width += 11;
        }
        return width;
    }

    @Override
    public int getDefaultHeight() {
        return 11;
    }
}

