/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.ui;

import arc.func.Boolf;
import arc.func.Floatf;
import arc.func.Floatp;
import arc.func.Prov;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.graphics.Pal;
import mindustry.ui.Fonts;

public class DelaySlideBar
extends Table {
    public static final Interp parabola4Reversed = x -> -4.0f * (x - 0.5f) * (x - 0.5f) + 1.0f;
    public static final Color back = Color.black.cpy().lerp(Color.darkGray, 0.35f).a(0.5f);
    public boolean blinkable = false;
    public boolean drawBackground = true;
    public boolean drawShadow = false;
    public float approachSpeedScl_Stable = 0.025f;
    public float approachSpeedScl_Real = 0.125f;
    public float barMargin = 0.0f;
    public float realStableMargin = 0.0f;
    public boolean snapWhileIncrease = true;
    public float allowedDeviation = 1.0E-6f;
    public Color rootColor = Color.black;
    public Color backgroundColor = back;
    public Color blinkColor = Color.white;
    public Prov<Color> colorStable = () -> Color.lightGray;
    public Prov<Color> colorReal = () -> Pal.accent;
    public Prov<CharSequence> info = () -> "null";
    public Floatp valueGetter = () -> 0.0f;
    public Floatp maxValue = () -> 1.0f;
    public Floatf<DelaySlideBar> fontScale = b -> 1.0f;
    protected float currentValue;
    protected float lastValue;
    protected float stableValue;
    protected float equalizedTime;
    protected float stableThreshold = 0.4f;
    public Boolf<DelaySlideBar> stable = b -> b.equalizedTime >= b.stableThreshold;
    protected float blink = 0.0f;
    protected boolean blinked = false;
    protected float fontAlpha = 1.0f;

    public DelaySlideBar() {
        this.color.set(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public DelaySlideBar(Prov<Color> colorReal, Prov<CharSequence> info, Floatp valueGetter, Floatp maxValue) {
        this();
        this.info = info;
        this.colorReal = colorReal;
        this.valueGetter = valueGetter;
        this.maxValue = maxValue;
        this.snap();
    }

    public DelaySlideBar(Prov<Color> colorReal, Prov<CharSequence> info, Floatp valueGetter) {
        this();
        this.colorReal = colorReal;
        this.info = info;
        this.valueGetter = valueGetter;
        this.snap();
    }

    public boolean isStable() {
        return this.stable.get((Object)this);
    }

    public void snap() {
        this.currentValue = this.stableValue = this.valueGetter.get();
        this.lastValue = this.stableValue;
    }

    public float getFraction() {
        return this.lastValue / this.maxValue.get();
    }

    public float getStableFraction() {
        return this.stableValue / this.maxValue.get();
    }

    public void act(float delta) {
        super.act(delta);
        this.currentValue = Mathf.clamp((float)this.valueGetter.get(), (float)1.0E-6f, (float)this.maxValue.get());
        if (this.snapWhileIncrease && this.lastValue < this.currentValue && this.stableValue < this.lastValue) {
            this.stableValue = this.lastValue;
        }
        this.equalizedTime = this.lastValue - this.currentValue < this.allowedDeviation ? (this.equalizedTime += delta) : 0.0f;
        if (this.blinkable && Mathf.equal((float)this.currentValue, (float)1.0E-6f) && !this.blinked) {
            this.blink();
        }
        if (this.isStable()) {
            this.stableValue = Mathf.lerpDelta((float)this.stableValue, (float)this.lastValue, (float)this.approachSpeedScl_Stable);
        }
        this.lastValue = Mathf.lerp((float)this.lastValue, (float)this.currentValue, (float)this.approachSpeedScl_Real);
        this.blink = Mathf.lerp((float)this.blink, (float)0.0f, (float)0.075f);
        if (!this.blinkable || this.blink < 0.01f && this.lastValue > 0.1f && this.currentValue > 0.01f) {
            this.blinked = false;
        }
    }

    public void blink() {
        if (!this.blinkable) {
            return;
        }
        this.blink = 1.0f;
        this.blinked = true;
    }

    public void draw() {
        super.draw();
        if (this.drawBackground) {
            Draw.color((Color)this.backgroundColor);
            Draw.alpha((float)(this.parentAlpha * this.color.a * this.backgroundColor.a));
            Fill.quad((float)this.x, (float)this.y, (float)(this.x + this.width), (float)this.y, (float)(this.x + this.width), (float)(this.y + this.height), (float)this.x, (float)(this.y + this.height));
        }
        Color color1 = (Color)this.colorStable.get();
        float c2 = Tmp.c2.set(color1).lerp(Color.black, 0.65f).a(this.parentAlpha * this.color.a).toFloatBits();
        float c1 = Tmp.c1.set(color1).lerp(Color.white, 0.1f).lerp(Tmp.c2, 1.0f - this.getStableFraction()).a(this.parentAlpha * this.color.a).toFloatBits();
        Fill.quad((float)(this.x + this.barMargin), (float)(this.y + this.barMargin), (float)c2, (float)(this.x - this.barMargin + this.width * this.getStableFraction()), (float)(this.y + this.barMargin), (float)c1, (float)(this.x - this.barMargin + this.width * this.getStableFraction()), (float)(this.y - this.barMargin + this.height), (float)c1, (float)(this.x + this.barMargin), (float)(this.y - this.barMargin + this.height), (float)c2);
        color1 = (Color)this.colorReal.get();
        c2 = Tmp.c2.set(color1).lerp(this.rootColor, 0.65f).a(this.parentAlpha * this.color.a).toFloatBits();
        c1 = Tmp.c1.set(color1).lerp(Color.white, 0.1f).lerp(Tmp.c2, 1.0f - this.getFraction()).a(this.parentAlpha * this.color.a).toFloatBits();
        Fill.quad((float)(this.x + (this.barMargin + this.realStableMargin)), (float)(this.y + (this.barMargin + this.realStableMargin)), (float)c2, (float)(this.x - (this.barMargin + this.realStableMargin) + this.width * this.getFraction()), (float)(this.y + (this.barMargin + this.realStableMargin)), (float)c1, (float)(this.x - (this.barMargin + this.realStableMargin) + this.width * this.getFraction()), (float)(this.y - (this.barMargin + this.realStableMargin) + this.height), (float)c1, (float)(this.x + (this.barMargin + this.realStableMargin)), (float)(this.y - (this.barMargin + this.realStableMargin) + this.height), (float)c2);
        if (this.blink > 0.001f) {
            Draw.color((Color)this.blinkColor);
            Draw.blend((Blending)Blending.additive);
            Draw.alpha((float)(this.blink * this.parentAlpha * this.color.a));
            float w = this.width * (parabola4Reversed.apply(this.blink * 0.95f) / 2.5f + 1.0f);
            Fill.quad((float)this.x, (float)this.y, (float)(this.x + w), (float)this.y, (float)(this.x + w), (float)(this.y + this.height), (float)this.x, (float)(this.y + this.height));
            Draw.blend();
        }
        Font font = Fonts.outline;
        GlyphLayout lay = (GlyphLayout)Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        lay.setText(font, (CharSequence)this.info.get());
        font.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        font.getCache().clear();
        float scl = this.fontScale.get((Object)this);
        font.getData().setScale(scl);
        font.getCache().addText((CharSequence)this.info.get(), this.x + this.width * 0.035f, this.y + this.height * 0.8125f);
        this.fontAlpha = lay.width > this.width / this.scaleX || scl < 0.325f ? Mathf.lerp((float)this.fontAlpha, (float)0.0f, (float)0.2f) : Mathf.lerp((float)this.fontAlpha, (float)1.0f, (float)0.05f);
        font.getCache().draw(this.parentAlpha * this.color.a * this.fontAlpha);
        font.getData().setScale(1.0f);
        Pools.free((Object)lay);
    }
}

