/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.graphic;

import arc.Core;
import arc.func.Cons3;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.gl.Shader;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.struct.IntMap;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import newhorizon.content.NHColor;
import newhorizon.content.NHShaders;
import newhorizon.content.NHStatusEffects;
import newhorizon.util.annotation.HeadlessDisabled;
import newhorizon.util.func.MathUtil;
import newhorizon.util.graphic.ScreenShaderDrawer;

@HeadlessDisabled
public class StatusRenderer {
    public static final float FADE_TIME = 90.0f;
    public static final float STATUS_RENDER_BEGIN = 160.0001f;
    public static final float STATUS_RENDER_STEP = 0.001f;
    public static final float STATUS_RENDER_RANGE = 1.0E-4f;
    public Seq<StatusEffect> registered = new Seq();
    public StatusDrawer[] drawers;
    public Rand rand = new Rand();
    protected LastSeq lastSeq;
    protected IntMap<Runnable> drawTask = new IntMap();

    public StatusRenderer() {
        this.lastSeq = new LastSeq();
        this.drawers = new StatusDrawer[this.statusSize()];
        for (int i = 0; i < this.statusSize(); ++i) {
            StatusEffect statusEffect = (StatusEffect)Vars.content.statusEffects().get(i);
            this.drawers[i] = new StatusDrawer(statusEffect, 0, (Cons3<Float, Unit, StatusEffect>)((Cons3)(warmup, unit, status) -> {}));
        }
        this.registerStatusEffects();
    }

    public int statusSize() {
        return Vars.content.statusEffects().size;
    }

    public float width() {
        return Core.camera.width;
    }

    public float height() {
        return Core.camera.height;
    }

    public float centerX() {
        return Core.camera.position.x;
    }

    public float centerY() {
        return Core.camera.position.y;
    }

    public float left() {
        return this.centerX() - this.width() / 2.0f;
    }

    public float right() {
        return this.centerX() + this.width() / 2.0f;
    }

    public float bottom() {
        return this.centerY() - this.height() / 2.0f;
    }

    public float top() {
        return this.centerY() + this.height() / 2.0f;
    }

    public long statusRandId(StatusEffect status) {
        return status.id + status.hashCode();
    }

    public void registerStatusEffects() {
        this.register(NHStatusEffects.ultFireBurn, 80, (Cons3<Float, Unit, StatusEffect>)((Cons3)(warmup, unit, status) -> {
            Color from = NHColor.lightSkyFront;
            Color to = NHColor.deeperBlue;
            float rad = this.width() / 32.0f;
            float life = 180.0f;
            int num = (int)(this.width() * Vars.renderer.getDisplayScale() * this.height() * Vars.renderer.getDisplayScale() / 5000.0f);
            float base = Time.time / life;
            this.rand.setSeed(this.statusRandId((StatusEffect)status));
            Draw.blend((Blending)Blending.additive);
            Draw.color((Color)from, (Color)Color.white, (Color)to, (float)MathUtil.timeValue(0.2f * warmup.floatValue(), 0.3f * warmup.floatValue(), 0.5f));
            Draw.alpha((float)MathUtil.timeValue(0.2f * warmup.floatValue(), 0.3f * warmup.floatValue(), 0.5f));
            Fill.quad((float)this.left(), (float)this.bottom(), (float)this.left(), (float)this.top(), (float)this.right(), (float)this.top(), (float)this.right(), (float)this.bottom());
            for (int i = 0; i < num; ++i) {
                float fin = (this.rand.random(1.0f) + base) % 1.0f;
                float fout = 1.0f - fin;
                Draw.alpha((float)((this.rand.random(0.8f, 0.875f) + Mathf.absin((float)2.0f, (float)0.15f)) * (Mathf.curve((float)fout, (float)0.35f, (float)0.55f) + 3.0f) / 4.0f * warmup.floatValue()));
                Draw.color((Color)Tmp.c1.set(from).mul(this.rand.random(0.9f, 1.1f)).lerp(Color.white, this.rand.random(0.2f, 0.3f) * Mathf.curve((float)fout, (float)0.8f, (float)1.0f)), (Color)Tmp.c2.set(to).mul(this.rand.random(0.9f, 1.1f)).lerp(Color.white, this.rand.random(0.2f, 0.3f) * Mathf.curve((float)fout, (float)0.8f, (float)1.0f)), (float)this.rand.random(0.0f, 1.0f));
                Tmp.v1.setToRandomDirection(this.rand).scl(this.width() / 2.075f, this.height() / 2.05f).scl(this.rand.random(0.95f, 1.15f) * Interp.fastSlow.apply(fout) + 0.165f + this.rand.random(0.05f, 0.125f));
                Fill.square((float)(Tmp.v1.x + this.centerX()), (float)(Tmp.v1.y + this.centerY()), (float)(rad * this.rand.random(0.8f, 1.8f) * fout * fout * warmup.floatValue()), (float)45.0f);
            }
            Draw.blend();
        }));
        this.register(NHStatusEffects.invincible, 60, NHShaders.statusXWave, (Cons3<Float, Unit, StatusEffect>)((Cons3)(warmup, unit, status) -> {
            int step = 36;
            float rad = (this.width() + this.height()) / 2.0f / (float)step;
            float stroke = rad * 0.16f;
            float inner = rad * 0.7f;
            float cx = this.centerX();
            float cy = this.centerY();
            float dst = rad * Mathf.sqrt3;
            float min = 0.65f;
            float max = 0.85f;
            this.rand.setSeed(this.statusRandId((StatusEffect)status));
            for (int i = 1; i < step / 2; ++i) {
                for (int j = 0; j < i; ++j) {
                    for (int k = 0; k < 6; ++k) {
                        float chance;
                        float ang;
                        float maxDst;
                        Tmp.v1.trns((float)(60 * k), dst * (float)i).add(cx, cy);
                        Tmp.v2.trns((float)(60 * k + 120), dst * (float)j).add(Tmp.v1);
                        if (Tmp.v2.x - rad > this.right() || Tmp.v2.x + rad < this.left() || Tmp.v2.y - dst > this.top() || Tmp.v2.y + dst < this.bottom()) continue;
                        float toCenter = Mathf.dst((float)Tmp.v2.x, (float)Tmp.v2.y, (float)cx, (float)cy);
                        float frac = toCenter / (maxDst = Mathf.dst((float)(Mathf.cosDeg((float)(ang = Angles.angle((float)Tmp.v2.x, (float)Tmp.v2.y, (float)cx, (float)cy))) * this.width() / 2.0f), (float)(Mathf.sinDeg((float)ang) * this.height() / 2.0f)));
                        float f = frac > min ? (frac < max ? Mathf.curve((float)frac, (float)min, (float)max) : 1.0f) : (chance = 0.0f);
                        if (!this.rand.chance((double)chance)) continue;
                        float mmax = 1.3f;
                        float innerFrac = Mathf.clamp((float)((frac - max) / (mmax - max) * this.rand.random(0.72f, 1.2f)));
                        float innerWarmup = Interp.bounceOut.apply(Interp.smoother.apply(Mathf.clamp((float)(-Interp.reverse.apply(innerFrac) + warmup.floatValue() * 2.0f))));
                        Tmp.c1.set(NHColor.lightSky).lerp(NHColor.lightSkyFront, innerWarmup * MathUtil.timeValue(0.2f, 0.6f, 1.5f, this.rand.random(360)));
                        Draw.color((Color)Tmp.c1);
                        Draw.alpha((float)((1.25f * Mathf.clamp((float)(0.32f + innerFrac * 0.6f)) + MathUtil.timeValue(0.1f, 0.4f, 2.0f, this.rand.random(360))) * innerWarmup));
                        Lines.stroke((float)stroke);
                        Lines.poly((float)Tmp.v2.x, (float)Tmp.v2.y, (int)6, (float)rad, (float)30.0f);
                        Fill.poly((float)Tmp.v2.x, (float)Tmp.v2.y, (int)6, (float)inner, (float)30.0f);
                    }
                }
            }
            Draw.reset();
        }));
        this.register(NHStatusEffects.scannerDown, 100, (Cons3<Float, Unit, StatusEffect>)((Cons3)(warmup, unit, status) -> {
            Color from = Pal.heal;
            Color to = NHColor.lightSkyBack;
            float particleLen = this.width() / 8.0f;
            float stroke = this.height() / 35.0f;
            float life = this.width() / 10.0f * Vars.renderer.getDisplayScale();
            Lines.stroke((float)(stroke * warmup.floatValue()));
            float base = Time.time / life;
            this.rand.setSeed(this.statusRandId((StatusEffect)status));
            Draw.blend((Blending)Blending.additive);
            Draw.color((Color)from, (Color)Color.white, (Color)to, (float)Mathf.absin((float)4.0f, (float)1.0f));
            Draw.alpha((float)((0.7f + Mathf.absin((float)2.0f, (float)0.2f)) * Mathf.curve((float)warmup.floatValue(), (float)0.0f, (float)0.5f)));
            Fill.quad((float)this.left(), (float)this.bottom(), (float)this.left(), (float)this.top(), (float)this.right(), (float)this.top(), (float)this.right(), (float)this.bottom());
            Draw.blend();
            for (int i = -40; i < 40; ++i) {
                for (int j = -15; j < 15; ++j) {
                    float fin = (this.rand.random(1.0f) + base) % 1.0f;
                    float fout = 1.0f - fin;
                    int angle = Mathf.sign((float)this.rand.range(1));
                    Draw.alpha((float)((this.rand.random(0.925f, 1.0f) + Mathf.absin((float)2.0f, (float)0.05f)) * Mathf.curve((float)warmup.floatValue(), (float)0.0f, (float)0.5f)));
                    Draw.tint((Color)Tmp.c1.set(from).mul(this.rand.random(0.9f, 1.1f)).lerp(Color.white, this.rand.random(0.4f, 0.8f) * Mathf.curve((float)fout, (float)0.8f, (float)1.0f)), (Color)Tmp.c2.set(to).mul(this.rand.random(0.9f, 1.1f)).lerp(Color.white, this.rand.random(0.4f, 0.8f) * Mathf.curve((float)fout, (float)0.8f, (float)1.0f)), (float)this.rand.random(0.0f, 1.0f));
                    Draw.getColor().lerp(Color.white, Mathf.absin((float)2.0f, (float)0.075f));
                    Lines.lineAngle((float)(this.centerX() + this.rand.range(0.5f) * particleLen + (float)j / 10.0f * this.width() * fin), (float)(this.centerY() + this.rand.range(0.5f) * stroke + (float)i * this.height() / 60.0f), (float)(angle * 90 + 90), (float)(particleLen * (fout * 0.4f + 0.6f) * warmup.floatValue()));
                }
            }
        }));
        this.register(NHStatusEffects.emp1, 120, (Cons3<Float, Unit, StatusEffect>)((Cons3)(warmup, unit, status) -> {
            ScreenShaderDrawer.drawDisplaceGlitch = warmup.floatValue() > 0.01f;
            NHShaders.displaceGlitch.intensity = warmup.floatValue() * 1.0f;
        }));
        this.register(NHStatusEffects.emp2, 130, (Cons3<Float, Unit, StatusEffect>)((Cons3)(warmup, unit, status) -> {
            ScreenShaderDrawer.drawDisplaceGlitch = warmup.floatValue() > 0.01f;
            NHShaders.displaceGlitch.intensity = warmup.floatValue() * 1.6f;
        }));
        this.register(NHStatusEffects.emp3, 140, (Cons3<Float, Unit, StatusEffect>)((Cons3)(warmup, unit, status) -> {
            ScreenShaderDrawer.drawDisplaceGlitch = warmup.floatValue() > 0.01f;
            NHShaders.displaceGlitch.intensity = warmup.floatValue() * 2.2f;
        }));
    }

    public void register(StatusEffect effect, int priority, Cons3<Float, Unit, StatusEffect> statusRenderer) {
        this.registered.add((Object)effect);
        this.drawers[effect.id] = new StatusDrawer(effect, priority, statusRenderer);
    }

    public void register(StatusEffect effect, int priority, Shader shader, Cons3<Float, Unit, StatusEffect> statusRenderer) {
        this.registered.add((Object)effect);
        this.drawers[effect.id] = new StatusDrawer(effect, priority, shader, statusRenderer);
    }

    public StatusDrawer getRenderer(StatusEffect statusEffect) {
        return this.drawers[statusEffect.id];
    }

    public void draw() {
        for (Runnable r : this.drawTask.values()) {
            r.run();
        }
    }

    public void update() {
        if (Vars.player.unit() == null || Vars.player.unit().statusBits() == null) {
            return;
        }
        this.registered.each(effect -> {
            if (Vars.player.unit().statusBits().get((int)effect.id)) {
                StatusDrawer d = this.getRenderer((StatusEffect)effect);
                this.lastSeq.add(effect.id);
                if (!this.drawTask.containsKey((int)effect.id)) {
                    this.drawTask.put((int)effect.id, () -> d.draw(Mathf.clamp((float)(this.lastSeq.get(effect.id) / 90.0f)), Vars.player.unit()));
                }
            }
        });
        this.lastSeq.update();
    }

    public void clear() {
        this.drawTask.clear();
        this.lastSeq.clear();
    }

    protected class LastSeq {
        public LastEffectTime[] arr;

        public LastSeq() {
            this.arr = new LastEffectTime[StatusRenderer.this.statusSize()];
        }

        public boolean contains(int id) {
            return this.arr[id] != null;
        }

        public float get(int id) {
            LastEffectTime l = this.arr[id];
            return l == null ? 0.0f : l.time;
        }

        public void clear() {
            for (int i = 0; i < this.arr.length; ++i) {
                LastEffectTime l = this.arr[i];
                if (l == null) continue;
                Pools.free((Object)l);
                this.arr[i] = null;
            }
        }

        public void update() {
            for (int i = 0; i < this.arr.length; ++i) {
                LastEffectTime l = this.arr[i];
                if (l == null) continue;
                if (l.time < -5.0f && !l.newly) {
                    this.arr[i] = null;
                    Pools.free((Object)l);
                    StatusRenderer.this.drawTask.remove(i);
                    continue;
                }
                l.newly = false;
                l.time -= Time.delta;
            }
        }

        public void add(int id) {
            LastEffectTime l = this.arr[id];
            if (l != null) {
                l.refill();
            } else {
                this.arr[id] = (LastEffectTime)Pools.obtain(LastEffectTime.class, () -> new LastEffectTime(8.0f));
            }
        }
    }

    public class StatusDrawer {
        public StatusEffect status;
        public int priority;
        public Shader shader;
        public Cons3<Float, Unit, StatusEffect> statusRenderer;

        public StatusDrawer(StatusEffect status, int priority, Cons3<Float, Unit, StatusEffect> statusRenderer) {
            this.status = status;
            this.priority = priority;
            this.statusRenderer = statusRenderer;
        }

        public StatusDrawer(StatusEffect status, int priority, Shader shader, Cons3<Float, Unit, StatusEffect> statusRenderer) {
            this.status = status;
            this.shader = shader;
            this.priority = priority;
            this.statusRenderer = statusRenderer;
        }

        public float drawZLayer() {
            return 160.0001f + 0.001f * (float)this.priority;
        }

        public void drawShader() {
            if (this.shader != null) {
                Draw.drawRange((float)this.drawZLayer(), (float)1.0E-4f, () -> Vars.renderer.effectBuffer.begin(Color.clear), () -> {
                    Vars.renderer.effectBuffer.end();
                    Vars.renderer.effectBuffer.blit(this.shader);
                });
            }
        }

        public void draw(float warmup, Unit unit) {
            Draw.z((float)this.drawZLayer());
            this.statusRenderer.get((Object)Float.valueOf(warmup), (Object)unit, (Object)this.status);
            this.drawShader();
        }
    }

    protected static class LastEffectTime
    implements Pool.Poolable {
        public float time;
        public boolean newly = true;

        public LastEffectTime(float time) {
            this.time = time;
        }

        public void refill() {
            this.time = Math.min(105.0f, this.time + Time.delta * 5.0f);
        }

        public void reset() {
            this.newly = true;
            this.time = 0.0f;
        }
    }
}

