/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.graphic;

import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Point2;
import arc.struct.IntIntMap;

public class SpriteUtil {
    public static final int[] ATLAS_INDEX_4_4;
    public static final int[] ATLAS_INDEX_4_12_RAW;
    public static final int[] ATLAS_INDEX_4_12;
    public static final IntIntMap ATLAS_INDEX_4_12_MAP;
    public static final Point2[] orthogonalPos;
    public static final Point2[][] diagonalPos;
    public static final Point2[] proximityPos;

    public static TextureRegion[][] split(TextureRegion region, int tileWidth, int tileHeight, int pad) {
        if (region.texture == null) {
            return null;
        }
        int x = region.getX();
        int y = region.getY();
        int width = region.width;
        int height = region.height;
        int pWidth = tileWidth + pad * 2;
        int pHeight = tileHeight + pad * 2;
        int sw = width / pWidth;
        int sh = height / pHeight;
        int startX = x;
        TextureRegion[][] tiles = new TextureRegion[sw][sh];
        int cy = 0;
        while (cy < sh) {
            x = startX;
            int cx = 0;
            while (cx < sw) {
                tiles[cx][cy] = new TextureRegion(region.texture, x + pad, y + pad, tileWidth, tileHeight);
                ++cx;
                x += pWidth;
            }
            ++cy;
            y += pHeight;
        }
        return tiles;
    }

    public static TextureRegion[] splitRegionArray(TextureRegion region, int tileWidth, int tileHeight) {
        return SpriteUtil.splitRegionArray(region, tileWidth, tileHeight, 0);
    }

    public static TextureRegion[] splitRegionArray(TextureRegion region, int tileWidth, int tileHeight, int pad) {
        return SpriteUtil.splitRegionArray(region, tileWidth, tileHeight, pad, null);
    }

    public static TextureRegion[] splitRegionArray(TextureRegion region, int tileWidth, int tileHeight, int pad, int[] indexMap) {
        if (region.texture == null) {
            return null;
        }
        int x = region.getX();
        int y = region.getY();
        int width = region.width;
        int height = region.height;
        int pWidth = tileWidth + pad * 2;
        int pHeight = tileHeight + pad * 2;
        int sw = width / pWidth;
        int sh = height / pHeight;
        int startX = x;
        TextureRegion[] tiles = new TextureRegion[sw * sh];
        int cy = 0;
        while (cy < sh) {
            x = startX;
            int cx = 0;
            while (cx < sw) {
                int index = cx + cy * sw;
                if (indexMap != null) {
                    tiles[indexMap[index]] = new TextureRegion(region.texture, x + pad, y + pad, tileWidth, tileHeight);
                } else {
                    tiles[index] = new TextureRegion(region.texture, x + pad, y + pad, tileWidth, tileHeight);
                }
                ++cx;
                x += pWidth;
            }
            ++cy;
            y += pHeight;
        }
        return tiles;
    }

    static {
        int i;
        ATLAS_INDEX_4_4 = new int[]{0, 2, 10, 8, 4, 6, 14, 12, 5, 7, 15, 13, 1, 3, 11, 9};
        ATLAS_INDEX_4_12_RAW = new int[]{0, 2, 10, 8, 143, 46, 78, 31, 38, 111, 110, 76, 4, 6, 14, 12, 39, 127, 239, 77, 55, 95, 175, 207, 5, 7, 15, 13, 23, 191, 223, 141, 63, 255, 240, 205, 1, 3, 11, 9, 79, 27, 139, 47, 19, 155, 159, 137};
        ATLAS_INDEX_4_12 = new int[ATLAS_INDEX_4_12_RAW.length];
        ATLAS_INDEX_4_12_MAP = new IntIntMap();
        orthogonalPos = new Point2[]{new Point2(0, 1), new Point2(1, 0), new Point2(0, -1), new Point2(-1, 0)};
        diagonalPos = new Point2[][]{{new Point2(1, 0), new Point2(1, 1), new Point2(0, 1)}, {new Point2(1, 0), new Point2(1, -1), new Point2(0, -1)}, {new Point2(-1, 0), new Point2(-1, -1), new Point2(0, -1)}, {new Point2(-1, 0), new Point2(-1, 1), new Point2(0, 1)}};
        proximityPos = new Point2[]{new Point2(0, 1), new Point2(1, 0), new Point2(0, -1), new Point2(-1, 0), new Point2(1, 1), new Point2(1, -1), new Point2(-1, -1), new Point2(-1, 1)};
        Integer[] indices = new Integer[ATLAS_INDEX_4_12_RAW.length];
        for (i = 0; i < ATLAS_INDEX_4_12_RAW.length; ++i) {
            indices[i] = i;
        }
        for (i = 1; i < indices.length; ++i) {
            int key = indices[i];
            int keyValue = ATLAS_INDEX_4_12_RAW[key];
            for (int j = i - 1; j >= 0 && ATLAS_INDEX_4_12_RAW[indices[j]] > keyValue; --j) {
                indices[j + 1] = indices[j];
            }
            indices[j + 1] = key;
        }
        for (i = 0; i < indices.length; ++i) {
            SpriteUtil.ATLAS_INDEX_4_12[indices[i].intValue()] = i;
        }
        for (i = 0; i < ATLAS_INDEX_4_12_RAW.length; ++i) {
            ATLAS_INDEX_4_12_MAP.put(ATLAS_INDEX_4_12_RAW[i], ATLAS_INDEX_4_12[i]);
        }
    }
}

