/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.graphic;

import arc.Core;
import arc.func.Cons;
import arc.func.Floatc2;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Scl;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Fonts;
import newhorizon.NewHorizon;
import newhorizon.util.func.NHFunc;
import newhorizon.util.func.NHInterp;

public class DrawFunc {
    public static final Color bottomColor = Pal.gray;
    public static final float sinScl = 1.0f;
    public static final int[] oneArr = new int[]{1};
    private static final Vec2 vec1 = new Vec2();
    private static final Vec2 vec2 = new Vec2();
    private static final Vec2 vec3 = new Vec2();
    private static final Vec2 vec4 = new Vec2();
    private static final Seq<Position> pointPos = new Seq(Position.class);
    private static final Rand rand = new Rand();
    public static float NOR_DISTANCE = 600.0f;

    public static void laser(TextureRegion line, TextureRegion start, TextureRegion end, float x, float y, float x2, float y2, float scale) {
        float scl = 8.0f * scale * Draw.scl;
        float rot = Mathf.angle((float)(x2 - x), (float)(y2 - y));
        float vx = Mathf.cosDeg((float)rot) * scl;
        float vy = Mathf.sinDeg((float)rot) * scl;
        Draw.rect((TextureRegion)start, (float)x, (float)y, (float)((float)start.width * scale * start.scl()), (float)((float)start.height * scale * start.scl()), (float)(rot + 180.0f));
        Draw.rect((TextureRegion)end, (float)x2, (float)y2, (float)((float)end.width * scale * end.scl()), (float)((float)end.height * scale * end.scl()), (float)rot);
        Lines.stroke((float)(12.0f * scale));
        Lines.line((TextureRegion)line, (float)(x + vx), (float)(y + vy), (float)(x2 - vx), (float)(y2 - vy), (boolean)false);
        Lines.stroke((float)1.0f);
    }

    public static void laser(TextureRegion line, TextureRegion edge, float x, float y, float x2, float y2) {
        DrawFunc.laser(line, edge, edge, x, y, x2, y2, 1.0f);
    }

    public static void laser(TextureRegion line, TextureRegion start, TextureRegion end, float x, float y, float x2, float y2) {
        DrawFunc.laser(line, start, end, x, y, x2, y2, 1.0f);
    }

    public static void laser(TextureRegion line, TextureRegion edge, float x, float y, float x2, float y2, float scale) {
        DrawFunc.laser(line, edge, edge, x, y, x2, y2, scale);
    }

    public static void basicLaser(float x, float y, float x2, float y2, float stroke, float circleScl) {
        Lines.stroke((float)stroke);
        Lines.line((float)x, (float)y, (float)x2, (float)y2, (boolean)false);
        Fill.circle((float)x, (float)y, (float)(stroke * circleScl));
        Fill.circle((float)x2, (float)y2, (float)(stroke * circleScl));
        Lines.stroke((float)1.0f);
    }

    public static void basicLaser(float x, float y, float x2, float y2, float stroke) {
        DrawFunc.basicLaser(x, y, x2, y2, stroke, 0.95f);
    }

    public static void lineAngleLerp(float x, float y, float angle, float length, boolean cap, Color begin, Color end) {
        float stroke = Lines.getStroke();
        vec2.trns(angle, length);
        float x2 = x + DrawFunc.vec2.x;
        float y2 = y + DrawFunc.vec2.y;
        float hstroke = stroke / 2.0f;
        float len = Mathf.len((float)(x2 - x), (float)(y2 - y));
        float diffx = (x2 - x) / len * hstroke;
        float diffy = (y2 - y) / len * hstroke;
        float colorB = begin.toFloatBits();
        float colorE = end.toFloatBits();
        if (cap) {
            Fill.quad((float)(x - diffx - diffy), (float)(y - diffy + diffx), (float)colorB, (float)(x - diffx + diffy), (float)(y - diffy - diffx), (float)colorB, (float)(x2 + diffx + diffy), (float)(y2 + diffy - diffx), (float)colorE, (float)(x2 + diffx - diffy), (float)(y2 + diffy + diffx), (float)colorE);
        } else {
            Fill.quad((float)(x - diffy), (float)(y + diffx), (float)colorB, (float)(x + diffy), (float)(y - diffx), (float)colorB, (float)(x2 + diffy), (float)(y2 - diffx), (float)colorE, (float)(x2 - diffy), (float)(y2 + diffx), (float)colorE);
        }
    }

    public static void randLenVectors(long seed, int amount, float length, float minLength, float angle, float range, Floatc2 cons) {
        rand.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            vec1.trns(angle + rand.range(range), minLength + rand.random(length));
            cons.get(DrawFunc.vec1.x, DrawFunc.vec1.y);
        }
    }

    public static void randLenVectors(long seed, float fin, int amount, float minLength, float length, Angles.ParticleConsumer cons) {
        rand.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            float l = rand.nextFloat();
            vec1.trns(rand.random(360.0f), length * l * fin + minLength);
            cons.accept(DrawFunc.vec1.x, DrawFunc.vec1.y, fin * l, (1.0f - fin) * l);
        }
    }

    public static float cameraDstScl(float x, float y, float norDst) {
        vec1.set(Core.camera.position);
        float dst = Mathf.dst((float)x, (float)y, (float)DrawFunc.vec1.x, (float)DrawFunc.vec1.y);
        return 1.0f - Mathf.clamp((float)(dst / norDst));
    }

    public static <T extends Building> void drawWhileHold(Class<T> type, Cons<T> drawer) {
        Draw.z((float)121.0f);
        Seq builds = Groups.build.copy(new Seq()).retainAll(b -> b.team == Vars.player.team() && type.isAssignableFrom(b.getClass())).as();
        for (Building build : builds) {
            drawer.get((Object)build);
        }
    }

    public static float cameraDstScl(float x, float y) {
        return DrawFunc.cameraDstScl(x, y, NOR_DISTANCE);
    }

    public static void tri(float x, float y, float width, float length, float angle) {
        float wx = Angles.trnsx((float)(angle + 90.0f), (float)width);
        float wy = Angles.trnsy((float)(angle + 90.0f), (float)width);
        Fill.tri((float)(x + wx), (float)(y + wy), (float)(x - wx), (float)(y - wy), (float)(Angles.trnsx((float)angle, (float)length) + x), (float)(Angles.trnsy((float)angle, (float)length) + y));
    }

    public static void arrow(float x, float y, float width, float length, float backLength, float angle) {
        float wx = Angles.trnsx((float)(angle + 90.0f), (float)width);
        float wy = Angles.trnsy((float)(angle + 90.0f), (float)width);
        float ox = Angles.trnsx((float)angle, (float)backLength);
        float oy = Angles.trnsy((float)angle, (float)backLength);
        float cx = Angles.trnsx((float)angle, (float)length) + x;
        float cy = Angles.trnsy((float)angle, (float)length) + y;
        Fill.tri((float)(x + ox), (float)(y + oy), (float)(x - wx), (float)(y - wy), (float)cx, (float)cy);
        Fill.tri((float)(x + wx), (float)(y + wy), (float)(x + ox), (float)(y + oy), (float)cx, (float)cy);
    }

    public static void surround(long id, float x, float y, float rad, int num, float innerSize, float outerSize, float interp) {
        Rand rand = NHFunc.rand;
        rand.setSeed(id);
        for (int i = 0; i < num; ++i) {
            float len = rad * rand.random(0.75f, 1.5f);
            vec1.trns(rand.random(360.0f) + rand.range(2.0f) * (1.5f - Mathf.curve((float)len, (float)(rad * 0.75f), (float)(rad * 1.5f))) * Time.time, len);
            float angle = vec1.angle();
            vec1.add(x, y);
            DrawFunc.tri(DrawFunc.vec1.x, DrawFunc.vec1.y, (interp + 1.0f) * outerSize + rand.random(0.0f, outerSize / 8.0f), outerSize * (Interp.exp5In.apply(interp) + 0.25f) / 2.0f, angle);
            DrawFunc.tri(DrawFunc.vec1.x, DrawFunc.vec1.y, (interp + 1.0f) / 2.0f * innerSize + rand.random(0.0f, innerSize / 8.0f), innerSize * (Interp.exp5In.apply(interp) + 0.5f), angle - 180.0f);
        }
    }

    public static void drawConnected(float x, float y, float size, Color color) {
        Draw.reset();
        float sin = Mathf.absin((float)(Time.time * 1.0f), (float)8.0f, (float)1.25f);
        for (int i = 0; i < 4; ++i) {
            float length = size / 2.0f + 3.0f + sin;
            Tmp.v1.trns((float)(i * 90), -length);
            Draw.color((Color)Pal.gray);
            Draw.rect((String)NewHorizon.name("linked-arrow-back"), (float)(x + Tmp.v1.x), (float)(y + Tmp.v1.y), (float)(i * 90));
            Draw.color((Color)color);
            Draw.rect((String)NewHorizon.name("linked-arrow"), (float)(x + Tmp.v1.x), (float)(y + Tmp.v1.y), (float)(i * 90));
        }
        Draw.reset();
    }

    public static void overlayText(Font font, String text, float x, float y, float offset, float offsetScl, float size, Color color, boolean underline, boolean align) {
        GlyphLayout layout = (GlyphLayout)Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(size / Scl.scl((float)1.0f));
        layout.setText(font, (CharSequence)text);
        font.setColor(color);
        float dy = offset + 3.0f;
        font.draw((CharSequence)text, x, y + layout.height / (float)(align ? 2 : 1) + (dy + 1.0f) * offsetScl, 1);
        dy -= 1.0f;
        if (underline) {
            Lines.stroke((float)2.0f, (Color)Color.darkGray);
            Lines.line((float)(x - layout.width / 2.0f - 2.0f), (float)(dy + y), (float)(x + layout.width / 2.0f + 1.5f), (float)(dy + y));
            Lines.stroke((float)1.0f, (Color)color);
            Lines.line((float)(x - layout.width / 2.0f - 2.0f), (float)(dy + y), (float)(x + layout.width / 2.0f + 1.5f), (float)(dy + y));
            Draw.color();
        }
        font.setUseIntegerPositions(ints);
        font.setColor(Color.white);
        font.getData().setScale(1.0f);
        Draw.reset();
        Pools.free((Object)layout);
    }

    public static void drawRail(float x, float y, float rotation, float shootY, float fin, float length, float width, float spacing, float scl, TextureRegion arrowRegion) {
        float railF = Mathf.curve((float)Interp.pow2Out.apply(fin), (float)0.0f, (float)0.25f) * Mathf.curve((float)Interp.pow4Out.apply(1.0f - fin), (float)0.0f, (float)0.1f) * fin;
        int i = 0;
        while ((float)i <= length / spacing) {
            Tmp.v1.trns(rotation, (float)i * spacing * Mathf.curve((float)Interp.pow4Out.apply(1.0f - fin), (float)0.0f, (float)0.1f) + shootY);
            float f = Interp.pow3Out.apply(Mathf.clamp((float)((fin * length - (float)i * spacing) / spacing))) * (0.6f + railF * 0.4f) * 0.8f * scl;
            Draw.rect((TextureRegion)arrowRegion, (float)(x + Tmp.v1.x), (float)(y + Tmp.v1.y), (float)((float)arrowRegion.width * Draw.scl * f), (float)((float)arrowRegion.height * Draw.scl * f), (float)(rotation - 90.0f));
            ++i;
        }
        Tmp.v1.trns(rotation, 0.0f, (2.0f - railF) * width);
        Tmp.v2.trns(rotation, shootY);
        Lines.stroke((float)(railF * 2.0f * scl));
        for (int i2 : Mathf.signs) {
            Lines.lineAngle((float)(x + Tmp.v1.x * (float)i2 + Tmp.v2.x), (float)(y + Tmp.v1.y * (float)i2 + Tmp.v2.y), (float)rotation, (float)(length * (0.75f + railF / 4.0f) * Mathf.curve((float)(Interp.pow5Out.apply(1.0f - fin) * Mathf.curve((float)Interp.pow4Out.apply(1.0f - fin), (float)0.0f, (float)0.1f)), (float)0.0f, (float)0.1f)));
        }
    }

    public static void circlePercentFlip(float x, float y, float rad, float in, float scl) {
        boolean monoIncr = in % (scl * 4.0f) < scl * 2.0f;
        float f = Mathf.cos((float)(in % (scl * 3.0f)), (float)scl, (float)1.1f);
        DrawFunc.circlePercent(x, y, rad, f > 0.0f ? f : -f, in + (float)(-90 * Mathf.sign((float)f)));
    }

    public static void fillCirclePercent(float centerX, float centerY, float x, float y, float rad, float percent, float angle) {
        float sin2;
        float cos2;
        float sin;
        float cos;
        float a;
        float p = Mathf.clamp((float)percent);
        int sides = Lines.circleVertices((float)rad);
        float space = 360.0f / (float)sides;
        float len = 2.0f * rad * Mathf.sinDeg((float)(space / 2.0f));
        vec1.trns(angle, rad);
        int i = 0;
        while ((float)i < (float)sides * p - 1.0f) {
            a = space * (float)i + angle;
            cos = Mathf.cosDeg((float)a);
            sin = Mathf.sinDeg((float)a);
            cos2 = Mathf.cosDeg((float)(a + space));
            sin2 = Mathf.sinDeg((float)(a + space));
            Fill.tri((float)(x + rad * cos), (float)(y + rad * sin), (float)(x + rad * cos2), (float)(y + rad * sin2), (float)centerX, (float)centerY);
            ++i;
        }
        a = space * (float)i + angle;
        cos = Mathf.cosDeg((float)a);
        sin = Mathf.sinDeg((float)a);
        cos2 = Mathf.cosDeg((float)(a + space));
        sin2 = Mathf.sinDeg((float)(a + space));
        float f = (float)sides * p - (float)i;
        vec1.trns(a, 0.0f, len * (f - 1.0f));
        Fill.tri((float)(x + rad * cos), (float)(y + rad * sin), (float)(x + rad * cos2 + DrawFunc.vec1.x), (float)(y + rad * sin2 + DrawFunc.vec1.y), (float)centerX, (float)centerY);
    }

    public static void fillCirclePercentFade(float centerX, float centerY, float x, float y, float rad, float percent, float angle, float aScl, float start, float end) {
        float sin2;
        float cos2;
        float sin;
        float cos;
        float a;
        float p = Mathf.clamp((float)percent);
        int sides = Lines.circleVertices((float)rad);
        float space = 360.0f / (float)sides;
        float len = 2.0f * rad * Mathf.sinDeg((float)(space / 2.0f));
        vec1.trns(angle, rad);
        int i = 0;
        while ((float)i < (float)sides * p - 1.0f) {
            a = space * (float)i + angle;
            cos = Mathf.cosDeg((float)a);
            sin = Mathf.sinDeg((float)a);
            cos2 = Mathf.cosDeg((float)(a + space));
            sin2 = Mathf.sinDeg((float)(a + space));
            Draw.alpha((float)(Mathf.curve((float)((float)i / ((float)sides * p)), (float)start, (float)end) * aScl));
            Fill.tri((float)(x + rad * cos), (float)(y + rad * sin), (float)(x + rad * cos2), (float)(y + rad * sin2), (float)centerX, (float)centerY);
            ++i;
        }
        a = space * (float)i + angle;
        cos = Mathf.cosDeg((float)a);
        sin = Mathf.sinDeg((float)a);
        cos2 = Mathf.cosDeg((float)(a + space));
        sin2 = Mathf.sinDeg((float)(a + space));
        float f = (float)sides * p - (float)i;
        vec1.trns(a, 0.0f, len * (f - 1.0f));
        Draw.alpha((float)aScl);
        Fill.tri((float)(x + rad * cos), (float)(y + rad * sin), (float)(x + rad * cos2 + DrawFunc.vec1.x), (float)(y + rad * sin2 + DrawFunc.vec1.y), (float)centerX, (float)centerY);
    }

    public static void circlePercent(float x, float y, float rad, float percent, float angle) {
        float sin2;
        float cos2;
        float sin;
        float cos;
        float a;
        float p = Mathf.clamp((float)percent);
        int sides = Lines.circleVertices((float)rad);
        float space = 360.0f / (float)sides;
        float len = 2.0f * rad * Mathf.sinDeg((float)(space / 2.0f));
        float hstep = Lines.getStroke() / 2.0f / Mathf.cosDeg((float)(space / 2.0f));
        float r1 = rad - hstep;
        float r2 = rad + hstep;
        int i = 0;
        while ((float)i < (float)sides * p - 1.0f) {
            a = space * (float)i + angle;
            cos = Mathf.cosDeg((float)a);
            sin = Mathf.sinDeg((float)a);
            cos2 = Mathf.cosDeg((float)(a + space));
            sin2 = Mathf.sinDeg((float)(a + space));
            Fill.quad((float)(x + r1 * cos), (float)(y + r1 * sin), (float)(x + r1 * cos2), (float)(y + r1 * sin2), (float)(x + r2 * cos2), (float)(y + r2 * sin2), (float)(x + r2 * cos), (float)(y + r2 * sin));
            ++i;
        }
        a = space * (float)i + angle;
        cos = Mathf.cosDeg((float)a);
        sin = Mathf.sinDeg((float)a);
        cos2 = Mathf.cosDeg((float)(a + space));
        sin2 = Mathf.sinDeg((float)(a + space));
        float f = (float)sides * p - (float)i;
        vec1.trns(a, 0.0f, len * (f - 1.0f));
        Fill.quad((float)(x + r1 * cos), (float)(y + r1 * sin), (float)(x + r1 * cos2 + DrawFunc.vec1.x), (float)(y + r1 * sin2 + DrawFunc.vec1.y), (float)(x + r2 * cos2 + DrawFunc.vec1.x), (float)(y + r2 * sin2 + DrawFunc.vec1.y), (float)(x + r2 * cos), (float)(y + r2 * sin));
    }

    public static void overlayText(String text, float x, float y, float offset, Color color, boolean underline) {
        DrawFunc.overlayText(Fonts.outline, text, x, y, offset, 1.0f, 0.25f, color, underline, false);
    }

    public static void drawSine2(float x, float y, float x2, float y2, float in, float scale, float scaleSpeed, float scaleOffset, float mag, float wavelength) {
        float dstTotal = Mathf.dst((float)x, (float)y, (float)x2, (float)y2);
        float ang = Angles.angle((float)x, (float)y, (float)x2, (float)y2);
        int dst = (int)(dstTotal / wavelength);
        Lines.beginLine();
        Lines.linePoint((float)x, (float)y);
        for (int i = 0; i < dst; ++i) {
            vec1.trns(ang, (float)i * wavelength, Mathf.sin((float)(in + scale * (scaleSpeed * (float)i + scaleOffset)), (float)scale, (float)mag)).add(x, y);
            Lines.linePoint((Position)vec1);
        }
        Lines.linePoint((float)x2, (float)y2);
        Lines.endLine((boolean)false);
    }

    public static void drawSine2Modifier(float x, float y, float x2, float y2, float in, float scale, float scaleSpeed, float scaleOffset, float mag, float wavelength, Floatc2 f) {
        float dstTotal = Mathf.dst((float)x, (float)y, (float)x2, (float)y2);
        float ang = Angles.angle((float)x, (float)y, (float)x2, (float)y2);
        int dst = (int)(dstTotal / wavelength);
        Lines.beginLine();
        vec1.trns(ang, 0.0f, Mathf.sin((float)(in + scale * scaleOffset), (float)scale, (float)mag)).add(x, y);
        Lines.linePoint((Position)vec1);
        f.get(DrawFunc.vec1.x, DrawFunc.vec1.y);
        for (int i = 1; i < dst; ++i) {
            vec1.trns(ang, (float)i * wavelength, Mathf.sin((float)(in + scale * (scaleSpeed * (float)i + scaleOffset)), (float)scale, (float)mag)).add(x, y);
            Lines.linePoint((Position)vec1);
        }
        Lines.linePoint((float)x2, (float)y2);
        Lines.endLine((boolean)false);
    }

    public static void drawSineLerp(float x, float y, float x2, float y2, int phase, float mag, float scale, float offset, float distant) {
        float dstTotal = Mathf.dst((float)x, (float)y, (float)x2, (float)y2);
        int dst = (int)(dstTotal / distant);
        if (dst < 1) {
            return;
        }
        Vec2 vec = new Vec2().trns(Angles.angle((float)x, (float)y, (float)x2, (float)y2), distant);
        for (int p = 0; p < phase; ++p) {
            Fill.circle((float)x, (float)y, (float)Lines.getStroke());
            for (int i = 0; i < dst; ++i) {
                vec1.trns(Angles.angle((float)x, (float)y, (float)x2, (float)y2) + 90.0f, Mathf.absin((float)(mag / (float)phase * (float)(3 * p) + dstTotal / (float)dst * (offset * mag) * 1.0f), (float)scale, (float)mag) - mag / 2.0f);
                vec2.trns(Angles.angle((float)x, (float)y, (float)x2, (float)y2) + 90.0f, Mathf.absin((float)(mag / (float)phase * (float)(3 * p) + dstTotal / (float)dst * (offset * mag + (float)i) * 1.0f), (float)scale, (float)mag) - mag / 2.0f);
                Vec2 from = vec.cpy().scl((float)i).add(vec1).add(x, y);
                Vec2 to = vec.cpy().scl((float)(i + 1)).add(vec2).add(x, y);
                Lines.line((float)from.x, (float)from.y, (float)to.x, (float)to.y, (boolean)false);
                Fill.circle((float)from.x, (float)from.y, (float)(Lines.getStroke() / 2.0f));
                Fill.circle((float)to.x, (float)to.y, (float)(Lines.getStroke() / 2.0f));
            }
        }
    }

    public static void link(Building from, Building to, Color color) {
        float sin = Mathf.absin((float)(Time.time * 1.0f), (float)6.0f, (float)1.0f);
        float r1 = (float)from.block.size / 2.0f * 8.0f + sin;
        float x1 = from.getX();
        float x2 = to.getX();
        float y1 = from.getY();
        float y2 = to.getY();
        float r2 = (float)to.block.size / 2.0f * 8.0f + sin;
        Draw.color((Color)color);
        Lines.square((float)x2, (float)y2, (float)((float)(to.block.size * 8) / 2.0f + 1.0f));
        Tmp.v1.trns(from.angleTo((Position)to), r1);
        Tmp.v2.trns(to.angleTo((Position)from), r2);
        int signs = (int)(from.dst((Position)to) / 8.0f);
        Lines.stroke((float)4.0f, (Color)Pal.gray);
        Lines.dashLine((float)(x1 + Tmp.v1.x), (float)(y1 + Tmp.v1.y), (float)(x2 + Tmp.v2.x), (float)(y2 + Tmp.v2.y), (int)signs);
        Lines.stroke((float)2.0f, (Color)color);
        Lines.dashLine((float)(x1 + Tmp.v1.x), (float)(y1 + Tmp.v1.y), (float)(x2 + Tmp.v2.x), (float)(y2 + Tmp.v2.y), (int)signs);
        Drawf.arrow((float)x1, (float)y1, (float)x2, (float)y2, (float)((float)(from.block.size * 8) / 2.0f + sin), (float)(4.0f + sin), (Color)color);
        Drawf.circles((float)x2, (float)y2, (float)r2, (Color)color);
    }

    public static void arrow(TextureRegion arrow, float x, float y, float sizeScl, float angle, Color color) {
        Draw.color((Color)color);
        Draw.rect((TextureRegion)arrow, (float)x, (float)y, (float)((float)arrow.width * sizeScl * Draw.scl), (float)((float)arrow.height * sizeScl * Draw.scl), (float)angle);
    }

    public static void arrow(String arrow, float x, float y, float sizeScl, float angle, Color color) {
        DrawFunc.arrow(Core.atlas.find(arrow, "bridge-arrow"), x, y, sizeScl, angle, color);
    }

    public static void arrowLine(TextureRegion arrow, float sizeScl, Color color, float dst, float maxDst, int offset, Position from, Position to) {
        float dstF = dst <= 0.0f ? 16.0f : dst;
        int num = (int)(from.dst(to) / dstF);
        if (num - 2 * offset < 0) {
            return;
        }
        float maxDstF = maxDst <= 0.0f ? Float.MAX_VALUE : maxDst;
        float angle = from.angleTo(to);
        Vec2 vec = new Vec2().trns(angle, dstF);
        for (int i = offset; i <= num - offset && !(vec.len() > maxDstF); ++i) {
            DrawFunc.arrow(arrow, from.getX() + vec.cpy().scl((float)((float)i)).x, from.getY() + vec.cpy().scl((float)((float)i)).y, sizeScl, angle, color);
        }
    }

    public static void arrowLine(String arrow, float sizeScl, Color color, float dst, float maxDst, int offset, Position from, Position to) {
        DrawFunc.arrowLine(Core.atlas.find(arrow, "bridge-arrow"), sizeScl, color, dst, maxDst, offset, from, to);
    }

    public static void posSquare(Color color, float stroke, float size, float x1, float y1, float x2, float y2) {
    }

    public static void posSquareLinkArr(Color color, float stroke, float size, boolean drawBottom, boolean linkLine, Position ... pos) {
        if (pos.length < 2 || !linkLine && pos[0] == null) {
            return;
        }
        for (int c : drawBottom ? Mathf.signs : oneArr) {
            for (int i = 1; i < pos.length; ++i) {
                if (pos[i] == null) continue;
                Position p1 = pos[i - 1];
                Position p2 = pos[i];
                Lines.stroke((float)(stroke + 1.0f - (float)c), (Color)(c == 1 ? color : bottomColor));
                if (linkLine) {
                    if (p1 == null) continue;
                    Lines.line((float)p2.getX(), (float)p2.getY(), (float)p1.getX(), (float)p1.getY());
                } else {
                    Lines.line((float)p2.getX(), (float)p2.getY(), (float)pos[0].getX(), (float)pos[0].getY());
                }
                Draw.reset();
            }
            for (Position p : pos) {
                if (p == null) continue;
                Draw.color((Color)(c == 1 ? color : bottomColor));
                Fill.square((float)p.getX(), (float)p.getY(), (float)(size + 1.0f - (float)c / 1.5f), (float)45.0f);
                Draw.reset();
            }
        }
    }

    public static void posSquareLink(Color color, float stroke, float size, boolean drawBottom, float x, float y, float x2, float y2) {
        DrawFunc.posSquareLink(color, stroke, size, drawBottom, (Position)vec1.set(x, y), (Position)vec2.set(x2, y2));
    }

    public static void posSquareLink(Color color, float stroke, float size, boolean drawBottom, Position from, Position to) {
        DrawFunc.posSquareLinkArr(color, stroke, size, drawBottom, false, from, to);
    }

    public static float rotator_90(float in, float margin) {
        return 90.0f * NHInterp.pow10.apply(Mathf.curve((float)in, (float)margin, (float)(1.0f - margin)));
    }

    public static float rotator_120(float in, float margin) {
        return 120.0f * NHInterp.pow10.apply(Mathf.curve((float)in, (float)margin, (float)(1.0f - margin)));
    }

    public static float rotator_90() {
        return 90.0f * Interp.pow5.apply(Mathf.curve((float)DrawFunc.cycle_100(), (float)0.15f, (float)0.85f));
    }

    public static float rotator_180() {
        return 180.0f * Interp.pow5.apply(Mathf.curve((float)DrawFunc.cycle_100(), (float)0.15f, (float)0.85f));
    }

    public static float rotator_360() {
        return 360.0f * Interp.pow5.apply(Mathf.curve((float)DrawFunc.cycle(0.0f, 270.0f), (float)0.15f, (float)0.85f));
    }

    public static float cycle_100() {
        return Time.time % 100.0f / 100.0f;
    }

    public static float cycle(float phaseOffset, float T) {
        return (Time.time + phaseOffset) % T / T;
    }

    public static float cycle(float in, float phaseOffset, float T) {
        return (in + phaseOffset) % T / T;
    }

    public static void gradient(float startX, float startY, float endX, float endY, float width, Color colorFrom, Color colorEnd) {
        float angle = Angles.angle((float)startX, (float)startY, (float)endX, (float)endY);
        float c1 = colorFrom.toFloatBits();
        float c2 = colorEnd.toFloatBits();
        vec1.trns(angle - 90.0f, width).add(startX, startY);
        vec2.trns(angle + 90.0f, width).add(startX, startY);
        vec3.trns(angle + 90.0f, width).add(endX, endY);
        vec4.trns(angle - 90.0f, width).add(endX, endY);
        Fill.quad((float)DrawFunc.vec1.x, (float)DrawFunc.vec1.y, (float)c1, (float)DrawFunc.vec2.x, (float)DrawFunc.vec2.y, (float)c1, (float)DrawFunc.vec3.x, (float)DrawFunc.vec3.y, (float)c2, (float)DrawFunc.vec4.x, (float)DrawFunc.vec4.y, (float)c2);
    }

    public static void gradient(Vec2 start, Vec2 end, float width, Color colorFrom, Color colorEnd) {
        DrawFunc.gradient(start.x, start.y, end.x, end.y, width, colorFrom, colorEnd);
    }

    public static void gradient(Vec2 start, Vec2 end, float width, Color colorFrom) {
        DrawFunc.gradient(start.x, start.y, end.x, end.y, width, colorFrom, Color.clear);
    }

    public static void drawText(String text, float x, float y) {
        DrawFunc.drawText(text, x, y, 1.0f);
    }

    public static void drawText(String text, float x, float y, float size) {
        Font font = Fonts.outline;
        GlyphLayout layout = (GlyphLayout)Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(size / 6.0f / Scl.scl((float)1.0f));
        layout.setText(font, (CharSequence)text);
        font.draw((CharSequence)text, x, y, 1);
        font.setUseIntegerPositions(ints);
        font.setColor(Color.white);
        font.getData().setScale(1.0f);
        Draw.reset();
        Pools.free((Object)layout);
    }
}

