/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.func;

import arc.math.Rand;
import arc.struct.Seq;
import newhorizon.util.struct.WeightedOption;

public class WeightedRandom {
    private static final Rand rand = new Rand();

    public static void random(WeightedOption ... options) {
        float totalWeight = 0.0f;
        for (WeightedOption option : options) {
            totalWeight += option.weight;
        }
        float randomValue = rand.nextFloat() * totalWeight;
        float cumulativeWeight = 0.0f;
        for (WeightedOption option : options) {
            if (!(randomValue <= (cumulativeWeight += option.weight))) continue;
            option.option.run();
            return;
        }
    }

    public static void random(Seq<WeightedOption> options) {
        float totalWeight = 0.0f;
        for (WeightedOption option : options) {
            totalWeight += option.weight;
        }
        float randomValue = rand.nextFloat() * totalWeight;
        float cumulativeWeight = 0.0f;
        for (WeightedOption option : options) {
            if (!(randomValue <= (cumulativeWeight += option.weight))) continue;
            option.option.run();
            return;
        }
    }

    public static void random(Object ... objects) {
        WeightedOption[] options = new WeightedOption[objects.length % 2];
        for (int i = 0; i < objects.length; i += 2) {
            options[i / 2] = new WeightedOption(((Float)objects[i]).floatValue(), (Runnable)objects[i + 1]);
        }
        WeightedRandom.random(options);
    }
}

