/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.func;

import arc.struct.ObjectMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ReflectionUtil {
    public static ObjectMap<String, Field> targetFieldMap = new ObjectMap();

    public static void copyProperties(Object source, Object target) {
        try {
            targetFieldMap.clear();
            for (Class<?> targetClass = target.getClass(); targetClass != null; targetClass = targetClass.getSuperclass()) {
                for (Field field : targetClass.getDeclaredFields()) {
                    if (Modifier.isFinal(field.getModifiers())) continue;
                    field.setAccessible(true);
                    targetFieldMap.put((Object)field.getName(), (Object)field);
                }
            }
            targetFieldMap.remove((Object)"id");
            for (Class<?> sourceClass = source.getClass(); sourceClass != null; sourceClass = sourceClass.getSuperclass()) {
                for (Field sourceField : sourceClass.getDeclaredFields()) {
                    if (Modifier.isFinal(sourceField.getModifiers())) continue;
                    sourceField.setAccessible(true);
                    Field targetField = (Field)targetFieldMap.get((Object)sourceField.getName());
                    if (targetField == null || !ReflectionUtil.isAssignable(sourceField.getType(), targetField.getType())) continue;
                    Object value = sourceField.get(source);
                    targetField.set(target, value);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isAssignable(Class<?> sourceType, Class<?> targetType) {
        return targetType.isAssignableFrom(sourceType);
    }
}

