/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.func;

import arc.Core;
import arc.files.Fi;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.PixmapIO;
import arc.graphics.Pixmaps;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.util.Log;
import arc.util.OS;
import java.io.IOException;
import mindustry.Vars;
import mindustry.gen.Tankc;
import mindustry.graphics.MultiPacker;
import mindustry.type.UnitType;
import mindustry.type.Weapon;

public class NHPixmap {
    public static final String PCD_SUFFIX = "-processed";
    public static final Color OUTLINE_COLOR = Color.valueOf((String)"565666");
    public static ObjectMap<String, Pixmap> processed = new ObjectMap();

    public static boolean isDebugging() {
        return false;
    }

    public static Pixmap addProcessed(String name, Pixmap pixmap) {
        processed.put((Object)name, (Object)pixmap);
        return pixmap;
    }

    public static void outLineAndAdd(String name, PixmapRegion pixmap, Color color, int radius) {
        NHPixmap.addProcessed(name, Pixmaps.outline((PixmapRegion)pixmap, (Color)color, (int)radius));
    }

    public static void outLineAndAdd(String name, TextureRegion pixmap, Color color, int radius) {
        NHPixmap.outLineAndAdd(name, Core.atlas.getPixmap(pixmap), color, radius);
    }

    public static void packAndAdd(MultiPacker packer, String name, Pixmap pixmap) {
        packer.add(MultiPacker.PageType.main, name, NHPixmap.addProcessed(name, pixmap));
    }

    public static void outlineLegs(MultiPacker packer, UnitType type) {
        if (NHPixmap.isDebugging() && !Vars.headless) {
            Color color = type.outlineColor;
            if (type.legRegion.found()) {
                packer.add(MultiPacker.PageType.main, type.name + "-leg", Pixmaps.outline((PixmapRegion)Core.atlas.getPixmap(type.legRegion), (Color)color, (int)type.outlineRadius));
            }
            if (type.jointRegion.found()) {
                packer.add(MultiPacker.PageType.main, type.name + "-joint", Pixmaps.outline((PixmapRegion)Core.atlas.getPixmap(type.jointRegion), (Color)color, (int)type.outlineRadius));
            }
            if (type.baseJointRegion.found()) {
                packer.add(MultiPacker.PageType.main, type.name + "-joint-base", Pixmaps.outline((PixmapRegion)Core.atlas.getPixmap(type.baseJointRegion), (Color)color, (int)type.outlineRadius));
            }
            if (type.footRegion.found()) {
                packer.add(MultiPacker.PageType.main, type.name + "-foot", Pixmaps.outline((PixmapRegion)Core.atlas.getPixmap(type.footRegion), (Color)color, (int)type.outlineRadius));
            }
            if (type.legBaseRegion.found()) {
                packer.add(MultiPacker.PageType.main, type.name + "-leg-base", Pixmaps.outline((PixmapRegion)Core.atlas.getPixmap(type.legBaseRegion), (Color)color, (int)type.outlineRadius));
            }
            if (type.baseRegion.found()) {
                packer.add(MultiPacker.PageType.main, type.name + "-base", Pixmaps.outline((PixmapRegion)Core.atlas.getPixmap(type.baseRegion), (Color)color, (int)type.outlineRadius));
            }
        }
    }

    public static void createIcons(MultiPacker packer, UnitType type) {
        if (!Vars.headless && NHPixmap.isDebugging()) {
            TextureAtlas.AtlasRegion t = (TextureAtlas.AtlasRegion)type.region;
            PixmapRegion r = Core.atlas.getPixmap(Core.atlas.find(type.name));
            Pixmap base = new Pixmap(type.region.width, type.region.height);
            if (type.constructor.get() instanceof Tankc) {
                base.draw(Core.atlas.getPixmap(type.treadRegion));
            }
            base.draw(NHPixmap.replaceColor(r.crop(), type.outlineColor, Color.clear), true);
            base.draw(NHPixmap.replaceColor(Core.atlas.getPixmap(type.cellRegion), (ObjectMap<Boolf<Color>, Color>)ObjectMap.of((Object[])new Object[]{c -> c.equals((Object)Color.white), Color.valueOf((String)"ffa664"), c -> c.equals((Object)Color.valueOf((String)"dcc6c6")), Color.valueOf((String)"dc804e")})), 0, 0, true);
            for (Weapon w : type.weapons) {
                if (w.top) continue;
                NHPixmap.drawWeaponPixmap(base, w, false, type.outlineColor, type.outlineRadius);
            }
            base = Pixmaps.outline((PixmapRegion)new PixmapRegion(base), (Color)type.outlineColor, (int)type.outlineRadius);
            for (Weapon w : type.weapons) {
                if (!w.top) continue;
                NHPixmap.drawWeaponPixmap(base, w, true, type.outlineColor, type.outlineRadius);
            }
            if (Core.settings.getBool("linear")) {
                Pixmaps.bleed((Pixmap)base);
            }
            NHPixmap.packAndAdd(packer, type.name + "-full", base);
        }
    }

    public static Pixmap replaceColor(Pixmap pixmap, Color from, Color to) {
        int f = from.rgba8888();
        int t = to.rgba8888();
        for (int y = 0; y < pixmap.height; ++y) {
            for (int x = 0; x < pixmap.width; ++x) {
                int c = pixmap.get(x, y);
                if (c != f) continue;
                pixmap.set(x, y, t);
            }
        }
        return pixmap;
    }

    public static Pixmap replaceColor(PixmapRegion pixmap, ObjectMap<Boolf<Color>, Color> map) {
        Pixmap base = new Pixmap(pixmap.width, pixmap.height);
        Color color = new Color();
        for (int y = 0; y < pixmap.height; ++y) {
            block1: for (int x = 0; x < pixmap.width; ++x) {
                pixmap.get(x, y, color);
                if (Mathf.zero((float)color.a)) continue;
                for (Boolf filter : map.keys()) {
                    if (!filter.get((Object)color)) continue;
                    base.set(x, y, (Color)map.get((Object)filter));
                    continue block1;
                }
            }
        }
        return base;
    }

    public static Pixmap fillColor(PixmapRegion pixmap, Color replaceColor) {
        Pixmap base = new Pixmap(pixmap.width, pixmap.height);
        Color color = new Color();
        if (color.a < 1.0f) {
            for (int y = 0; y < pixmap.height; ++y) {
                for (int x = 0; x < pixmap.width; ++x) {
                    pixmap.get(x, y, color);
                    base.set(pixmap.width - x, y, color.mul(replaceColor));
                }
            }
        }
        return base;
    }

    public static void mulColor(Pixmap pixmap, Color color) {
        Color c = new Color();
        for (int y = 0; y < pixmap.height; ++y) {
            for (int x = 0; x < pixmap.width; ++x) {
                c.set(pixmap.get(x, y));
                pixmap.set(x, y, c.mul(color));
            }
        }
    }

    @Deprecated
    public static void drawWeaponPixmap(Pixmap base, Weapon w, boolean outline, Color outlineColor, int radius) {
        TextureRegion region = Core.atlas.find(w.name + "-preview", w.region);
        if (region != null && region.found() && region instanceof TextureAtlas.AtlasRegion) {
            Pixmap wRegion;
            TextureAtlas.AtlasRegion t = (TextureAtlas.AtlasRegion)region;
            if (!t.found()) {
                return;
            }
            Pixmap pixmap = wRegion = region != w.region ? Pixmaps.outline((PixmapRegion)Core.atlas.getPixmap(t), (Color)outlineColor, (int)radius) : Core.atlas.getPixmap(t).crop();
            if (w.mirror) {
                Pixmap wRegion2 = wRegion.flipX();
                base.draw(wRegion, NHPixmap.getCenter(base, wRegion, true, outline) + (int)(w.x * 4.0f), NHPixmap.getCenter(base, wRegion, false, outline) - (int)(w.y * 4.0f), true);
                base.draw(wRegion2, NHPixmap.getCenter(base, wRegion2, true, outline) - (int)(w.x * 4.0f), NHPixmap.getCenter(base, wRegion2, false, outline) - (int)(w.y * 4.0f), true);
            } else {
                base.draw(wRegion, NHPixmap.getCenter(base, wRegion, true, outline) + (int)(w.x * 4.0f), NHPixmap.getCenter(base, wRegion, false, outline) - (int)(w.y * 4.0f), true);
            }
        }
    }

    public static int getCenter(Pixmap base, Pixmap above, boolean WorH, boolean outline) {
        return WorH ? (base.getWidth() - above.getWidth()) / 2 : (base.getHeight() - above.getHeight()) / 2;
    }

    public static String rootPath() {
        return OS.env((String)"MDT_SPRITE_HOME");
    }

    public static String path(String p) {
        return NHPixmap.rootPath() + p;
    }

    public static Fi processedDir() {
        Fi dic = new Fi(NHPixmap.path("/pre-processed"));
        if (!dic.exists()) {
            dic.mkdirs();
        }
        return dic;
    }

    public static Fi processedPng(String fileName, String suffix) {
        return new Fi(NHPixmap.rootPath() + "/pre-processed/" + fileName.replaceAll("new-horizon-", "") + suffix + ".png");
    }

    public static void saveUnitPixmap(Pixmap pixmap, UnitType type) {
        Fi dic = new Fi(NHPixmap.rootPath() + "/pre-processed");
        if (!dic.exists()) {
            dic.mkdirs();
        }
        if (dic.exists()) {
            Fi n = NHPixmap.processedPng(type.name, "-full");
            if (n.exists()) {
                return;
            }
            if (!n.exists()) {
                try {
                    n.file().createNewFile();
                }
                catch (IOException e) {
                    Log.err((Throwable)e);
                }
            }
            PixmapIO.writePng((Fi)n, (Pixmap)pixmap);
            Log.info((Object)("Created Icon: " + type.localizedName));
        }
    }

    public static void saveAddProcessed() {
        NHPixmap.processedDir();
        for (ObjectMap.Entry entry : processed.entries()) {
            Fi n = NHPixmap.processedPng((String)entry.key, "");
            PixmapIO.writePng((Fi)n, (Pixmap)((Pixmap)entry.value));
            Log.info((Object)("Created Icon: " + (String)entry.key));
        }
    }
}

