/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.func;

import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.util.Time;
import mindustry.gen.Posc;

public class MathUtil {
    private static final Vec2 tmp0 = new Vec2();
    private static final Vec2 tmp1 = new Vec2();
    private static final Vec2 tmp2 = new Vec2();

    public static float timeValue(float min, float max) {
        return MathUtil.timeValue(min, max, 1.0f, 0.0f);
    }

    public static float timeValue(float min, float max, float period) {
        return MathUtil.timeValue(min, max, period, 0.0f);
    }

    public static float timeValue(float min, float max, float period, float angle) {
        float time = Time.time / (period / 6.0f) + angle;
        float sin = Mathf.sinDeg((float)time);
        float scale = (max - min) / 2.0f;
        float start = (max + min) / 2.0f;
        return sin * scale + start;
    }

    public static float dst(Posc a, Posc b) {
        return Mathf.dst((float)a.x(), (float)a.y(), (float)b.x(), (float)b.y());
    }

    public static float dst(Point2 a, Point2 b) {
        return Mathf.dst((float)a.x, (float)a.y, (float)b.x, (float)b.y);
    }

    public static float dst(Vec2 a, Vec2 b) {
        return Mathf.dst((float)a.x, (float)a.y, (float)b.x, (float)b.y);
    }

    public static float angle(Posc start, Posc end) {
        return Angles.angle((float)start.x(), (float)start.y(), (float)end.x(), (float)end.y());
    }

    public static float angle(Point2 start, Point2 end) {
        return Angles.angle((float)start.x, (float)start.y, (float)end.x, (float)end.y);
    }

    public static float angle(Vec2 start, Vec2 end) {
        return Angles.angle((float)start.x, (float)start.y, (float)end.x, (float)end.y);
    }

    public static float angleBisector(float a, float b) {
        float delta = Math.abs((a = Mathf.mod((float)a, (float)360.0f)) - (b = Mathf.mod((float)b, (float)360.0f)));
        return (delta > 180.0f ? (a + b) / 2.0f + 180.0f : (a + b) / 2.0f) % 360.0f;
    }

    public static float angelDistance(float start, float end) {
        start = Mathf.mod((float)start, (float)360.0f);
        end = Mathf.mod((float)end, (float)360.0f);
        return (end + 360.0f - start) % 360.0f;
    }

    public static float angleRot(float start, float end, float progress) {
        tmp0.trns(start, 1.0f);
        tmp1.trns(end, 1.0f);
        return tmp2.set(tmp0).lerp(tmp1, progress).angle();
    }
}

