/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.func;

import arc.Core;
import arc.graphics.Pixmap;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.IntSeq;
import arc.struct.ObjectMap;
import mindustry.Vars;
import mindustry.type.UnitType;
import newhorizon.util.struct.GridData;

public class GridUtil {
    public static final int GRID_LEN = 16;
    public static final int PX_LEN = 4;
    public static final Point2[] samplingPixels = new Point2[]{new Point2(2, 2), new Point2(2, 13), new Point2(13, 13), new Point2(13, 2)};
    public static ObjectMap<String, GridData> unitGridsMap;

    public static void init() {
        if (Vars.headless) {
            return;
        }
        unitGridsMap = new ObjectMap(Vars.content.units().size);
        for (UnitType unit : Vars.content.units()) {
            unitGridsMap.put((Object)unit.name, (Object)GridUtil.getGridData(unit.fullIcon));
        }
    }

    public static GridData getGridData(TextureRegion region) {
        int widthStep = Mathf.ceil((float)((float)region.width / 16.0f));
        int heightStep = Mathf.ceil((float)((float)region.height / 16.0f));
        int width = widthStep * 16;
        int height = heightStep * 16;
        Pixmap pixmap = Core.atlas.getPixmap(region).crop();
        float padLeft = (float)(width - pixmap.width) / 2.0f;
        float padBot = (float)(height - pixmap.height) / 2.0f;
        int startLeft = -((int)padLeft);
        int startBot = -((int)padBot);
        IntSeq tmpPoints = new IntSeq();
        tmpPoints.setSize(width * height);
        for (int x = 0; x < widthStep; ++x) {
            for (int y = 0; y < heightStep; ++y) {
                int xCoord = startLeft + x * 16;
                int yCoord = startBot + y * 16;
                int sampleCount = 0;
                for (Point2 point2 : samplingPixels) {
                    int pixel = pixmap.get(xCoord + point2.x, yCoord + point2.y);
                    if ((pixel & 0xFF) != 0) continue;
                    ++sampleCount;
                }
                if (sampleCount == 4) {
                    tmpPoints.set(y * widthStep + x, 0);
                    continue;
                }
                tmpPoints.set(y * widthStep + x, 1);
            }
        }
        pixmap.dispose();
        return new GridData(tmpPoints, widthStep, heightStep, padLeft, padBot);
    }
}

