/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.feature;

import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.FloatSeq;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Healthc;
import newhorizon.NHSetting;
import newhorizon.content.NHFx;
import newhorizon.expand.bullets.EffectBulletType;
import newhorizon.util.struct.Vec2Seq;

public class PosLightning {
    public static final BulletType hitter = new EffectBulletType(5.0f){
        {
            this.absorbable = true;
            this.collidesTiles = true;
            this.collidesGround = true;
            this.collidesAir = true;
            this.collides = true;
            this.status = StatusEffects.shocked;
            this.statusDuration = 10.0f;
            this.hittable = false;
        }
    };
    public static final Cons<Position> none = p -> {};
    public static final float lifetime = Fx.chainLightning.lifetime;
    public static final float WIDTH = 2.5f;
    public static final float RANGE_RAND = 5.0f;
    public static final float ROT_DST = 4.8f;
    public static final Effect posLightning = new Effect(lifetime, 1200.0f, e -> {
        if (!(e.data instanceof Vec2Seq)) {
            return;
        }
        Vec2Seq lines = (Vec2Seq)e.data();
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.6f));
        Lines.stroke((float)(e.rotation * e.fout()));
        Fill.circle((float)lines.firstTmp().x, (float)lines.firstTmp().y, (float)(Lines.getStroke() / 2.0f));
        for (int i = 0; i < lines.size() - 1; ++i) {
            Vec2 cur = lines.setVec2(i, Tmp.v1);
            Vec2 next = lines.setVec2(i + 1, Tmp.v2);
            Lines.line((float)cur.x, (float)cur.y, (float)next.x, (float)next.y, (boolean)false);
            Fill.circle((float)next.x, (float)next.y, (float)(Lines.getStroke() / 2.0f));
        }
    }).layer(109.999f);
    private static final Rect rect = new Rect();
    private static final Rand rand = new Rand();
    private static final FloatSeq floatSeq = new FloatSeq();
    private static final Vec2 tmp1 = new Vec2();
    private static final Vec2 tmp2 = new Vec2();
    private static final Vec2 tmp3 = new Vec2();
    public static float trueHitChance = 1.0f;
    private static Building furthest;

    public static void setHitChance(float f) {
        trueHitChance = f;
    }

    public static void setHitChanceDef() {
        trueHitChance = 1.0f;
    }

    private static float getBoltRandomRange() {
        return Mathf.random((float)1.0f, (float)7.0f);
    }

    public static void createRange(Bullet owner, float range, int maxHit, Color color, boolean createSubLightning, float width, int lightningNum, Cons<Position> hitPointMovement) {
        PosLightning.createRange(owner, (Position)owner, owner.team, range, maxHit, color, createSubLightning, 0.0f, 0, width, lightningNum, hitPointMovement);
    }

    public static void createRange(Bullet owner, boolean hitAir, boolean hitGround, Position from, Team team, float range, int maxHit, Color color, boolean createSubLightning, float damage, int subLightningLength, float width, int lightningNum, Cons<Position> hitPointMovement) {
        Seq entities = new Seq();
        PosLightning.whetherAdd((Seq<Healthc>)entities, team, rect.setSize(range * 2.0f).setCenter(from.getX(), from.getY()), maxHit, hitGround, hitAir);
        for (Healthc p : entities) {
            PosLightning.create((Entityc)owner, team, from, (Position)p, color, createSubLightning, damage, subLightningLength, width, lightningNum, hitPointMovement);
        }
    }

    public static void createRange(Bullet owner, Position from, Team team, float range, int maxHit, Color color, boolean createSubLightning, float damage, int subLightningLength, float width, int lightningNum, Cons<Position> hitPointMovement) {
        PosLightning.createRange(owner, owner == null || owner.type.collidesAir, owner == null || owner.type.collidesGround, from, team, range, maxHit, color, createSubLightning, damage, subLightningLength, width, lightningNum, hitPointMovement);
    }

    public static void createLength(Bullet owner, Team team, Position from, float length, float angle, Color color, boolean createSubLightning, float damage, int subLightningLength, float width, int lightningNum, Cons<Position> hitPointMovement) {
        PosLightning.create((Entityc)owner, team, from, (Position)tmp2.trns(angle, length).add(from), color, createSubLightning, damage, subLightningLength, width, lightningNum, hitPointMovement);
    }

    public static void create(Entityc owner, Team team, Position from, Position target, Color color, boolean createSubLightning, float damage, int subLightningLength, float lightningWidth, int lightningNum, Cons<Position> hitPointMovement) {
        if (!Mathf.chance((double)trueHitChance)) {
            return;
        }
        Position sureTarget = PosLightning.findInterceptedPoint(from, target, team);
        hitPointMovement.get((Object)sureTarget);
        if (damage > 0.0f) {
            if (createSubLightning) {
                if (owner instanceof Bullet) {
                    Bullet b = (Bullet)owner;
                    for (int i = 0; i < b.type.lightning; ++i) {
                        Lightning.create((Bullet)b, (Color)color, (float)(b.type.lightningDamage < 0.0f ? b.damage : b.type.lightningDamage), (float)sureTarget.getX(), (float)sureTarget.getY(), (float)(b.rotation() + Mathf.range((float)(b.type.lightningCone / 2.0f)) + b.type.lightningAngle), (int)(b.type.lightningLength + Mathf.random((int)b.type.lightningLengthRand)));
                    }
                } else {
                    for (int i = 0; i < 3; ++i) {
                        Lightning.create((Team)team, (Color)color, (float)damage, (float)sureTarget.getX(), (float)sureTarget.getY(), (float)Mathf.random((float)360.0f), (int)subLightningLength);
                    }
                }
            }
            hitter.create(owner, team, sureTarget.getX(), sureTarget.getY(), 1.0f).damage(damage);
        }
        PosLightning.createEffect(from, sureTarget, color, lightningNum, lightningWidth);
    }

    public static void createRandom(Bullet owner, Team team, Position from, float rand, Color color, boolean createSubLightning, float damage, int subLightningLength, float width, int lightningNum, Cons<Position> hitPointMovement) {
        PosLightning.create((Entityc)owner, team, from, (Position)tmp2.rnd(rand).scl(Mathf.random((float)1.0f)).add(from), color, createSubLightning, damage, subLightningLength, width, lightningNum, hitPointMovement);
    }

    public static void createRandom(Team team, Position from, float rand, Color color, boolean createSubLightning, float damage, int subLightningLength, float width, int lightningNum, Cons<Position> hitPointMovement) {
        PosLightning.createRandom(null, team, from, rand, color, createSubLightning, damage, subLightningLength, width, lightningNum, hitPointMovement);
    }

    public static void createRandomRange(Team team, Position from, float rand, Color color, boolean createSubLightning, float damage, int subLightningLength, float width, int lightningNum, int generateNum, Cons<Position> hitPointMovement) {
        PosLightning.createRandomRange(null, team, from, rand, color, createSubLightning, damage, subLightningLength, width, lightningNum, generateNum, hitPointMovement);
    }

    public static void createRandomRange(Bullet owner, float rand, Color color, boolean createSubLightning, float damage, float width, int lightningNum, int generateNum, Cons<Position> hitPointMovement) {
        PosLightning.createRandomRange(owner, owner.team, (Position)owner, rand, color, createSubLightning, damage, owner.type.lightningLength + Mathf.random((int)owner.type.lightningLengthRand), width, lightningNum, generateNum, hitPointMovement);
    }

    public static void createRandomRange(Bullet owner, Team team, Position from, float rand, Color color, boolean createSubLightning, float damage, int subLightningLength, float width, int lightningNum, int generateNum, Cons<Position> hitPointMovement) {
        for (int i = 0; i < generateNum; ++i) {
            PosLightning.createRandom(owner, team, from, rand, color, createSubLightning, damage, subLightningLength, width, lightningNum, hitPointMovement);
        }
    }

    public static void createEffect(Position from, float length, float angle, Color color, int lightningNum, float width) {
        if (Vars.headless) {
            return;
        }
        PosLightning.createEffect(from, (Position)tmp2.trns(angle, length).add(from), color, lightningNum, width);
    }

    public static void createEffect(Position from, Position to, Color color, int lightningNum, float width) {
        if (Vars.headless) {
            return;
        }
        if (lightningNum < 1) {
            Fx.chainLightning.at(from.getX(), from.getY(), 0.0f, color, (Object)new Vec2().set(to));
        } else {
            float dst = from.dst(to);
            for (int i = 0; i < lightningNum; ++i) {
                float len = PosLightning.getBoltRandomRange();
                float randRange = len * 5.0f;
                floatSeq.clear();
                FloatSeq randomArray = floatSeq;
                int num = 0;
                while ((float)num < dst / (4.8f * len) + 1.0f) {
                    randomArray.add(Mathf.range((float)randRange) / ((float)num * 0.025f + 1.0f));
                    ++num;
                }
                PosLightning.createBoltEffect(color, width, PosLightning.computeVectors(randomArray, from, to));
            }
        }
    }

    public static Position findInterceptedPoint(Position from, Position target, Team fromTeam) {
        furthest = null;
        return Geometry.raycast((int)World.toTile((float)from.getX()), (int)World.toTile((float)from.getY()), (int)World.toTile((float)target.getX()), (int)World.toTile((float)target.getY()), (x, y) -> {
            furthest = Vars.world.build(x, y);
            return furthest != null && furthest.team() != fromTeam && PosLightning.furthest.block.insulated;
        }) && furthest != null ? furthest : target;
    }

    private static void whetherAdd(Seq<Healthc> points, Team team, Rect selectRect, int maxHit, boolean targetGround, boolean targetAir) {
        Units.nearbyEnemies((Team)team, (Rect)selectRect, unit -> {
            if (unit.checkTarget(targetAir, targetGround)) {
                points.add(unit);
            }
        });
        if (targetGround) {
            selectRect.getCenter(tmp3);
            Units.nearbyBuildings((float)PosLightning.tmp3.x, (float)PosLightning.tmp3.y, (float)(selectRect.getHeight() / 2.0f), b -> {
                if (b.team != team && b.isValid()) {
                    points.add(b);
                }
            });
        }
        points.shuffle();
        points.truncate(maxHit);
    }

    public static void createBoltEffect(Color color, float width, Vec2Seq vets) {
        if (NHSetting.enableDetails()) {
            vets.each((x, y) -> {
                if (Mathf.chance((double)0.0855)) {
                    NHFx.lightningSpark.at(x, y, rand.random(2.0f + width, 4.0f + width), color);
                }
            });
        }
        posLightning.at((vets.firstTmp().x + vets.peekTmp().x) / 2.0f, (vets.firstTmp().y + vets.peekTmp().y) / 2.0f, width, color, (Object)vets);
    }

    private static Vec2Seq computeVectors(FloatSeq randomVec, Position from, Position to) {
        int param = randomVec.size;
        float angle = from.angleTo(to);
        Vec2Seq lines = new Vec2Seq(param);
        tmp1.trns(angle, from.dst(to) / (float)(param - 1));
        lines.add(from);
        for (int i = 1; i < param - 2; ++i) {
            lines.add(tmp3.trns(angle - 90.0f, randomVec.get(i)).add(tmp1, (float)i).add(from.getX(), from.getY()));
        }
        lines.add(to);
        return lines;
    }
}

