/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.feature;

import arc.math.Mathf;
import arc.struct.FloatSeq;

public class ManhattanVoronoi {
    public FloatSeq points = new FloatSeq();
    public FloatSeq distance = new FloatSeq();
    public int width;
    public int height;

    public ManhattanVoronoi(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean addPoint(float x, float y, float threshold) {
        float t = threshold / ((float)(this.width + this.height) / 2.0f);
        for (int i = 0; i < this.points.size; i += 2) {
            if (!(Mathf.dstm((float)this.points.get(i), (float)this.points.get(i + 1), (float)x, (float)y) <= t)) continue;
            return false;
        }
        this.points.add(x, y);
        return true;
    }

    public void clear() {
        this.points.clear();
        this.distance.clear();
    }

    public float getPoint(int x, int y) {
        float rx = (float)(Mathf.clamp((int)x, (int)0, (int)(this.width - 1)) + 1) / (float)this.width;
        float ry = (float)(Mathf.clamp((int)y, (int)0, (int)(this.height - 1)) + 1) / (float)this.height;
        return this.getTopTwoDistanceDiff(rx, ry);
    }

    public float getPointPercent(int x, int y) {
        float rx = (float)(Mathf.clamp((int)x, (int)0, (int)(this.width - 1)) + 1) / (float)this.width;
        float ry = (float)(Mathf.clamp((int)y, (int)0, (int)(this.height - 1)) + 1) / (float)this.height;
        return this.getTopTwoDistancePercent(rx, ry);
    }

    public boolean getPointInThreshold(int x, int y, float threshold) {
        float t = threshold / ((float)(this.width + this.height) / 2.0f);
        float dst = this.getPoint(x, y);
        return dst <= t;
    }

    public boolean getPointInPercentThreshold(int x, int y, float threshold) {
        float dst = this.getPointPercent(x, y);
        return dst <= threshold;
    }

    public float getTopTwoDistanceDiff(float x, float y) {
        this.distance.clear();
        for (int i = 0; i < this.points.size; i += 2) {
            this.distance.add(Mathf.dstm((float)this.points.get(i), (float)this.points.get(i + 1), (float)x, (float)y));
        }
        this.distance.sort();
        if (this.distance.size < 2) {
            return 0.0f;
        }
        return this.distance.get(1) - this.distance.get(0);
    }

    public float getTopTwoDistancePercent(float x, float y) {
        this.distance.clear();
        for (int i = 0; i < this.points.size; i += 2) {
            this.distance.add(Mathf.dstm((float)this.points.get(i), (float)this.points.get(i + 1), (float)x, (float)y));
        }
        this.distance.sort();
        if (this.distance.size < 2) {
            return 0.0f;
        }
        return this.distance.get(1) - this.distance.get(0) / ((this.distance.get(1) + this.distance.get(0)) / 2.0f);
    }

    public boolean jointOfRectNodes(float x, float y) {
        this.distance.clear();
        for (int i = 0; i < this.points.size; i += 2) {
            this.distance.add(Mathf.dstm((float)this.points.get(i), (float)this.points.get(i + 1), (float)x, (float)y));
        }
        this.distance.sort();
        if (this.distance.size < 4) {
            return false;
        }
        return this.distance.get(0) + this.distance.get(1) - this.distance.get(2) - this.distance.get(3) < 1.0f;
    }
}

