/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util;

import arc.Core;
import arc.files.Fi;
import arc.func.Cons2;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.PixmapIO;
import arc.graphics.Pixmaps;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.math.Interp;
import arc.math.Rand;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Scaling;
import arc.util.Tmp;
import arc.util.io.PropertiesUtils;
import java.io.Reader;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.mod.Mods;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import newhorizon.NewHorizon;
import newhorizon.content.NHColor;
import newhorizon.util.func.NHPixmap;

public class Tool_Internal {
    private static Fi toProcess;
    private static Color tmpColor;

    public static void showTexture(final Texture texture) {
        new BaseDialog("Debug"){
            {
                super(arg0);
                this.cont.image(Draw.wrap((Texture)texture)).scaling(Scaling.fit).center();
                this.addCloseButton();
            }
        }.show();
    }

    public static void patchBundle() {
        new BaseDialog(""){
            {
                this.cont.fill(t -> {
                    Mods.LoadedMod mod = Vars.mods.getMod(NewHorizon.class);
                    StringMap bundleEN = new StringMap();
                    StringMap bundleTG = new StringMap();
                    Seq toStorage = new Seq();
                    ObjectMap original = new ObjectMap();
                    ObjectMap preview = new ObjectMap();
                    PropertiesUtils.load((ObjectMap)bundleEN, (Reader)mod.root.child("bundles").child("bundle.properties").reader());
                    Table ori = new Table(Tex.pane);
                    Table pre = new Table(Tex.pane);
                    t.button("Select Target File", (Drawable)Icon.list, Styles.cleart, () -> {
                        bundleTG.clear();
                        toStorage.clear();
                        original.clear();
                        preview.clear();
                        Vars.platform.showMultiFileChooser(fi -> Vars.ui.loadAnd("[accent]Loading Bundle", () -> {
                            toProcess = fi;
                            PropertiesUtils.load((ObjectMap)bundleTG, (Reader)toProcess.reader());
                            bundleEN.each((k, v) -> {
                                if (bundleTG.containsKey(k)) {
                                    toStorage.add((Object)(k + " = " + (String)bundleTG.get(k)));
                                    preview.put((Object)(k + " = " + (String)bundleTG.get(k)), (Object)Color.white);
                                } else {
                                    preview.put((Object)(k + " = " + v), (Object)Pal.heal);
                                    original.put((Object)(k + " = " + v), (Object)new Color().set(Color.lightGray).a(0.0f));
                                    toStorage.add((Object)(k + " =TODO " + v));
                                }
                            });
                            bundleTG.each((k, v) -> {
                                if (bundleEN.containsKey(k)) {
                                    original.put((Object)(k + " = " + v), (Object)Color.white);
                                } else {
                                    original.put((Object)(k + " = " + v), (Object)Pal.redderDust);
                                    preview.put((Object)(k + " = " + v), (Object)new Color().set(Color.lightGray).a(0.0f));
                                }
                            });
                            Cons2 func = (kvs, table) -> {
                                table.clearChildren();
                                int[] missing = new int[1];
                                kvs.keys().toSeq().sortComparing(c -> c.split(" = ")[0]).each(k -> {
                                    Color v = (Color)kvs.get(k);
                                    float[] h = new float[1];
                                    table.table(v.equals((Object)Color.white) ? Tex.clear : ((TextureRegionDrawable)Tex.whiteui).tint(v.r, v.g, v.b, 0.35f), c -> {
                                        if (v.a == 0.0f) {
                                            missing[0] = missing[0] + 1;
                                        }
                                        c.align(10);
                                        Label ln = (Label)c.add((CharSequence)(v.a == 0.0f ? "" : table.getRows() - missing[0] + 1 + "")).top().width(60.0f).get();
                                        ln.setFontScale(0.825f);
                                        ln.setColor(v.r, v.g, v.b, 1.0f);
                                        ((Image)c.image().growY().get()).setColor(v.r, v.g, v.b, 1.0f);
                                        Label l = (Label)c.add((CharSequence)k).pad(18.0f).get();
                                        l.setFontScale(0.825f);
                                        l.setColor(1.0f, 1.0f, 1.0f, v.a);
                                        h[0] = l.getPrefHeight();
                                    }).fillX().height(h[0]).row();
                                });
                            };
                            toStorage.sortComparing(c -> c.split(" = ")[0]);
                            func.get((Object)original, (Object)ori);
                            func.get((Object)preview, (Object)pre);
                        }), new String[]{"properties"});
                    }).growX().height(60.0f).pad(12.0f).row();
                    t.button("Storage", (Drawable)Icon.download, Styles.cleart, () -> {
                        int before = toProcess.readString().hashCode();
                        StringBuilder stringBuilder = new StringBuilder();
                        toStorage.each(s -> stringBuilder.append(s.replaceAll("\n", "\\\\n")).append("\n"));
                        String s2 = stringBuilder.toString();
                        toProcess.writeString(s2, false);
                        if (before != s2.hashCode()) {
                            Vars.ui.showText("Success Successfully", before + " -> " + s2.hashCode());
                        }
                    }).disabled(c -> toStorage.isEmpty() || toProcess == null || !toProcess.exists()).growX().height(60.0f).pad(12.0f).row();
                    t.pane(t1 -> {
                        t1.add((Element)ori).fill();
                        t1.image().color(Pal.accent).width(3.0f).pad(6.0f).growY();
                        t1.add((Element)pre).fill();
                    }).grow();
                });
                this.addCloseButton();
            }
        }.show();
    }

    public static void fireAnime() {
        Vars.ui.loadfrag.show();
        Vars.ui.loadAnd("[accent]Generating", () -> {
            Color from = NHColor.lightSkyFront;
            Color to = Color.darkGray;
            Fi root = NHPixmap.processedDir();
            Fi fireRoot = root.child("ult-fire");
            if (!fireRoot.exists()) {
                fireRoot.mkdirs();
            }
            Rand rand = new Rand();
            long id = rand.nextLong();
            int num = 13;
            int total = 40;
            String name = NewHorizon.name("square");
            String outPut = "ult-fire-";
            int size = 160;
            float step = 1.9f;
            rand.setSeed(id);
            Pixmap square = Core.atlas.getPixmap(name).crop();
            for (int fIndex = 0; fIndex < total; ++fIndex) {
                Pixmap base = new Pixmap(size, size);
                for (int i = 0; i < num; ++i) {
                    float fin = (float)((fIndex + rand.random(total + i)) % total) / (float)total;
                    float fout = 1.0f - fin * 0.95f;
                    float fslope = Math.max(0.515f - Math.abs(fin - 0.5f), 0.005f) * 2.0f;
                    Vec2 vec2 = new Vec2().setToRandomDirection(rand).scl((float)rand.random(3, 6) + (float)rand.random(4, 32) * Interp.circleOut.apply(fin) * step);
                    Tmp.c1.set(from).lerp(to, rand.range(0.2f) + Interp.swingIn.apply(fin) * 0.8f * rand.random(0.75f, 1.25f));
                    Pixmap pixmap = Pixmaps.scale((Pixmap)square, (float)(fslope * rand.random(0.15f, 0.8f) + 0.075f));
                    NHPixmap.mulColor(pixmap, Tmp.c1);
                    base.draw(pixmap, (base.width - pixmap.width) / 2 + (int)vec2.x, (base.height - pixmap.height) / 2 + (int)vec2.y, true);
                }
                rand.setSeed(id);
                PixmapIO.writePng((Fi)fireRoot.child(outPut + fIndex + ".png"), (Pixmap)base);
                Vars.ui.loadfrag.setProgress((float)fIndex / (float)total);
            }
            Vars.ui.loadfrag.hide();
        });
    }

    public static void textureLerp() {
        toProcess = new Fi("");
        if (toProcess.exists()) {
            Pixmap pixmap = PixmapIO.readPNG((Fi)toProcess);
            pixmap.each((x, y) -> {
                tmpColor = new Color().rgba8888(pixmap.get(x, y));
                tmpColor.a(Tool_Internal.tmpColor.r);
                Tool_Internal.tmpColor.b = 1.0f;
                Tool_Internal.tmpColor.g = 1.0f;
                Tool_Internal.tmpColor.r = 1.0f;
                tmpColor.clamp();
                pixmap.set(x, y, tmpColor);
            });
            PixmapIO.writePng((Fi)toProcess, (Pixmap)pixmap);
        }
    }

    public static void texturePick() {
        toProcess = new Fi("");
        if (toProcess.exists()) {
            Pixmap pixmap = PixmapIO.readPNG((Fi)toProcess);
            pixmap.each((x, y) -> {
                tmpColor = new Color().rgba8888(pixmap.get(x, y));
                if (Tool_Internal.tmpColor.r > 0.007843138f || Tool_Internal.tmpColor.g > 0.007843138f || Tool_Internal.tmpColor.b > 0.007843138f) {
                    tmpColor.set(Color.clear);
                    pixmap.set(x, y, tmpColor);
                }
            });
            PixmapIO.writePng((Fi)toProcess, (Pixmap)pixmap);
        }
    }

    public static void fixSaves() {
    }
}

