/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units.unitType.content;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.abilities.RepairFieldAbility;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.RailBulletType;
import mindustry.entities.pattern.ShootPattern;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Weapon;
import mindustry.world.meta.BlockFlag;
import newhorizon.NewHorizon;
import newhorizon.content.NHFx;
import newhorizon.content.NHSounds;
import newhorizon.content.NHStatusEffects;
import newhorizon.expand.ability.passive.AccumulateAccelerate;
import newhorizon.expand.units.ai.SniperAI;
import newhorizon.expand.units.unitType.NHUnitType;

public class Destruction
extends NHUnitType {
    public BulletType gauss = new RailBulletType(){
        {
            this.length = 360.0f;
            this.damage = 300.0f;
            this.hitColor = Pal.techBlue;
            this.hitEffect = this.endEffect = Fx.hitBulletColor;
            this.pierceDamageFactor = 0.4f;
            this.status = NHStatusEffects.emp1;
            this.statusDuration = 180.0f;
            this.smokeEffect = Fx.colorSpark;
            this.endEffect = new Effect(16.0f, e -> {
                Draw.color((Color)e.color);
                Drawf.tri((float)e.x, (float)e.y, (float)(e.fout() * 1.5f), (float)6.0f, (float)e.rotation);
            });
            this.shootEffect = new Effect(16.0f, e -> {
                Draw.color((Color)e.color);
                float w = 1.2f + 4.0f * e.fout();
                Drawf.tri((float)e.x, (float)e.y, (float)w, (float)(30.0f * e.fout()), (float)e.rotation);
                Draw.color((Color)e.color);
                for (int i : Mathf.signs) {
                    Drawf.tri((float)e.x, (float)e.y, (float)(w * 0.9f), (float)(22.0f * e.fout()), (float)(e.rotation + (float)i * 60.0f));
                }
                Drawf.tri((float)e.x, (float)e.y, (float)w, (float)(4.0f * e.fout()), (float)(e.rotation + 180.0f));
            });
            this.lineEffect = new Effect(25.0f, 1200.0f, e -> {
                if (!(e.data instanceof Vec2)) {
                    return;
                }
                Vec2 v = (Vec2)e.data;
                Draw.color((Color)e.color);
                Lines.stroke((float)((e.fout() + 0.5f) * 2.0f));
                Fx.rand.setSeed((long)e.id);
                for (int i = 0; i < 40; ++i) {
                    Fx.v.trns(e.rotation, Fx.rand.random(8.0f, v.dst(e.x, e.y) - 8.0f));
                    Lines.lineAngleCenter((float)(e.x + Fx.v.x), (float)(e.y + Fx.v.y), (float)(e.rotation + e.finpow()), (float)(e.foutpowdown() * 20.0f * Fx.rand.random(0.5f, 1.0f) + 0.3f));
                }
                e.scaled(16.0f, b -> {
                    Lines.stroke((float)(b.fout() * 3.0f));
                    Draw.color((Color)e.color);
                    Lines.line((float)e.x, (float)e.y, (float)v.x, (float)v.y);
                });
            });
        }

        public void hitTile(Bullet b, Building build, float x, float y, float initialHealth, boolean direct) {
            super.hitTile(b, build, x, y, initialHealth, direct);
            build.applySlowdown(0.25f, 180.0f);
        }
    };

    public Destruction() {
        super("destruction");
        this.outlineColor = OColor;
        this.aiController = SniperAI::new;
        this.weapons.addAll((Object[])new Weapon[]{new Weapon(NewHorizon.name("gauss-cannon")){
            {
                this.rotate = true;
                this.top = true;
                this.mirror = true;
                this.alternate = true;
                this.rotationLimit = 10.0f;
                this.x = 15.0f;
                this.y = 2.0f;
                this.recoil = 3.0f;
                this.shootCone = 20.0f;
                this.reload = 25.0f;
                this.shoot = new ShootPattern();
                this.inaccuracy = 6.0f;
                this.shake = 5.0f;
                this.shootY = 5.0f;
                this.ejectEffect = Fx.none;
                this.predictTarget = false;
                this.bullet = Destruction.this.gauss;
                this.shootSound = NHSounds.coil1;
            }
        }, new Weapon(NewHorizon.name("gauss-cannon")){
            {
                this.rotate = true;
                this.top = true;
                this.mirror = true;
                this.alternate = true;
                this.rotationLimit = 30.0f;
                this.x = 30.0f;
                this.y = -5.0f;
                this.recoil = 3.0f;
                this.shootCone = 15.0f;
                this.reload = 25.0f;
                this.inaccuracy = 6.0f;
                this.shake = 5.0f;
                this.shootY = 5.0f;
                this.ejectEffect = Fx.none;
                this.predictTarget = false;
                this.bullet = Destruction.this.gauss;
                this.shootSound = NHSounds.laser3;
            }
        }});
        this.armor = 15.0f;
        this.health = 15000.0f;
        this.speed = 3.0f;
        this.rotateSpeed = 1.0f;
        this.accel = 0.04f;
        this.drag = 0.02f;
        this.engineOffset = 13.0f;
        this.engineSize = 9.0f;
        this.hitSize = 36.0f;
        this.buildBeamOffset = 15.0f;
        this.ammoCapacity = 800;
        this.flying = true;
        this.drawShields = false;
        this.lowAltitude = true;
        this.singleTarget = false;
        this.abilities.add((Object)new RepairFieldAbility(500.0f, 160.0f, 240.0f){
            {
                this.healEffect = NHFx.healEffectSky;
                this.activeEffect = NHFx.activeEffectSky;
            }
        }, (Object)new AccumulateAccelerate());
        this.trailLength = 30;
        this.trailScl = 0.8f;
        this.targetFlags = new BlockFlag[]{BlockFlag.turret, BlockFlag.factory, BlockFlag.reactor, BlockFlag.generator, BlockFlag.core, null};
    }
}

