/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units.unitEntity;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.ObjectSet;
import arc.util.Interval;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.audio.SoundLoop;
import mindustry.entities.units.UnitController;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.UnitEntity;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.type.UnitType;
import newhorizon.expand.entities.EntityRegister;
import newhorizon.util.func.NHFunc;
import newhorizon.util.func.NHMath;
import newhorizon.util.graphic.DrawFunc;

public class ProbeEntity
extends UnitEntity {
    protected static final Vec2 tmpVec = new Vec2();
    public final float SCAN_WARMUP_SPEED = 0.0075f;
    public final float SCAN_COOL_SPEED = 0.015f;
    public final float SCAN_SHIFT_SPEED = 0.0875f;
    public final float SCAN_SPEED = 0.0075f;
    public final float UNSCAN_CLOAK_RELOAD = 180.0f;
    public ObjectSet<Building> scanned = new ObjectSet();
    public int scannedSize = 0;
    public Team targetTeam = null;
    public float scanRange = 240.0f;
    public Color scanColor = Pal.techBlue;
    public float scanRotateScl = 180.0f;
    public int scanMatWidth = 10;
    public float scanMatSpacing = 6.0f;
    public Vec2 scanPos = new Vec2();
    public Building scanTarget = null;
    public boolean scanning = false;
    public float scanWarmup = 0.0f;
    public float lastSize = 0.0f;
    public int leastScan = 14;
    public int minComplexSize = 16;
    public float scanSourceX = 0.5f;
    public float scanSourceY = 3.0f;
    public float unscanCloakReload = 0.0f;
    public Interval timer = new Interval(2);
    public SoundLoop scanSound = new SoundLoop(Sounds.loopBio, 0.9f);
    public float scanProgress = 0.0f;

    public int classId() {
        return EntityRegister.getID(ProbeEntity.class);
    }

    public void afterRead() {
        super.afterRead();
        this.scanPos.set(this.x, this.y);
        if (this.targetTeam == null) {
            this.targetTeam = Vars.state.rules.defaultTeam;
        }
    }

    public void setType(UnitType type) {
        super.setType(type);
        this.scanRange = type.maxRange + 160.0f;
        if (this.targetTeam == null) {
            this.targetTeam = Vars.state.rules.defaultTeam;
        }
    }

    public float clipSize() {
        return this.scanWarmup < 0.45f ? super.clipSize() : this.scanRange * 2.0f;
    }

    public void add() {
        super.add();
        this.scanPos.set(this.x, this.y);
        this.scanRange = this.type.maxRange + 160.0f;
    }

    public float scanSpeedScl() {
        return this.scanTarget.block.hasPower ? 1.5f / (float)this.scanTarget.block.size * (1.0f + this.scanTarget.power.status) / 2.0f * this.reloadMultiplier : 2.0f;
    }

    public boolean checkTarget(boolean targetAir, boolean targetGround) {
        return super.checkTarget(targetAir, targetGround) && (this.scanning || this.unscanCloakReload >= 180.0f);
    }

    public void updateJudging() {
    }

    public boolean scanOver() {
        return false;
    }

    public void updateScan() {
        if (this.team == this.targetTeam) {
            return;
        }
        if (this.timer.get(1, this.scanTarget != null && this.scanTarget.isValid() ? 600.0f : 45.0f)) {
            this.scanTarget = Vars.indexer.findTile(this.targetTeam, this.x, this.y, this.scanRange, b -> !this.scanned.contains(b));
        }
        boolean bl = this.scanning = this.scanTarget != null && !this.scanOver();
        if (this.scanning) {
            this.unscanCloakReload = 0.0f;
            this.scanWarmup = Mathf.lerpDelta((float)this.scanWarmup, (float)1.0f, (float)0.0075f);
            if (this.scanWarmup > 0.995f) {
                this.scanWarmup = 1.0f;
            }
            this.scanSound.update(this.x, this.y, true, this.scanWarmup);
            this.lastSize = Mathf.lerpDelta((float)this.lastSize, (float)((float)(this.scanTarget.block.size * 4) * Mathf.sqrt2), (float)(this.scanWarmup * 0.0075f));
            this.scanPos.lerp((Position)this.scanTarget, 0.0875f * Time.delta);
            if (this.scanTarget.within((Position)this.scanPos, this.lastSize / 1.5f)) {
                this.scanProgress = Mathf.approachDelta((float)this.scanProgress, (float)1.005f, (float)(0.0075f * this.scanSpeedScl()));
            }
            if (this.scanProgress >= 1.0f) {
                this.scanProgress = 0.0f;
                this.scanned.add((Object)this.scanTarget);
                this.scannedSize += this.scanTarget.block.size;
            }
        } else {
            this.scanSound.update(this.x, this.y, false, this.scanWarmup);
            this.unscanCloakReload += Time.delta;
            this.scanProgress = Mathf.approachDelta((float)this.scanProgress, (float)0.0f, (float)0.037499998f);
            this.scanWarmup = Mathf.lerpDelta((float)this.scanWarmup, (float)0.0f, (float)0.015f);
            if (this.scanWarmup < 0.005f) {
                this.scanWarmup = 0.0f;
                this.scanPos.set(this.x, this.y);
            }
            this.scanPos.lerp((Position)this, 0.0875f * Time.delta);
        }
        this.updateJudging();
    }

    public void update() {
        super.update();
        this.updateScan();
    }

    public void draw() {
        float z = Draw.z();
        super.draw();
        this.drawScan();
        if (!this.scanning) {
            Draw.z((float)122.0f);
            Tmp.c1.set(this.scanColor).lerp(Color.white, Mathf.absin((float)5.0f, (float)0.325f));
            Fill.light((float)this.x, (float)this.y, (int)((int)((float)Lines.circleVertices((float)this.hitSize) * 0.75f)), (float)(this.hitSize * 2.0f), (Color)Tmp.c1.a((0.925f + Mathf.absin((float)4.0f, (float)0.07f)) * (1.0f - this.scanWarmup) * Mathf.curve((float)(this.unscanCloakReload / 180.0f), (float)0.9f, (float)1.0f)), (Color)Color.clear);
        }
        Draw.z((float)z);
    }

    public void drawScan() {
        if (this.scanWarmup < 0.425f) {
            return;
        }
        float z = Draw.z();
        Draw.z((float)110.0f);
        float rWarmup = Mathf.curve((float)this.scanWarmup, (float)0.425f, (float)0.95f);
        Vec2 drawScanPos = Tmp.v6.set(this.scanPos).add(Tmp.v1.trns(Time.time * 1.35f, (rWarmup + Mathf.absin((float)8.0f, (float)(rWarmup * 0.65f))) * this.lastSize / 2.0f));
        float dst = this.dst((Position)drawScanPos);
        float drawSize = this.lastSize * rWarmup;
        float ang = NHMath.acosRad(drawSize / dst) * 57.295776f;
        float angTo = this.angleTo((Position)drawScanPos);
        float residualAngles = 90.0f - ang;
        Lines.stroke((float)(rWarmup * 1.25f));
        Tmp.c1.set(this.scanColor).lerp(Color.white, Mathf.absin((float)5.0f, (float)0.325f));
        Draw.color((Color)Tmp.c1);
        Tmp.v1.trns(angTo + ang, drawSize);
        Tmp.v2.trns(angTo - ang, drawSize);
        Vec2[] verts = new Vec2[]{Tmp.v1, Tmp.v2};
        Tmp.v3.trns(this.rotation, this.scanSourceY, this.scanSourceX).add(this.x, this.y);
        float rot = this.scanProgress * this.scanRotateScl + Time.time / 4.0f;
        Lines.circle((float)drawScanPos.x, (float)drawScanPos.y, (float)drawSize);
        DrawFunc.circlePercent(drawScanPos.x, drawScanPos.y, drawSize + 5.0f, this.scanProgress, rot + DrawFunc.rotator_360() + Time.time);
        Drawf.light((float)drawScanPos.x, (float)drawScanPos.y, (float)(drawSize * 1.5f), (Color)Tmp.c1, (float)(rWarmup * 0.75f));
        for (int i = 0; i < verts.length; ++i) {
            Vec2 vert = verts[i];
            Lines.line((float)Tmp.v3.x, (float)Tmp.v3.y, (float)(vert.x + drawScanPos.x), (float)(vert.y + drawScanPos.y), (boolean)true);
            DrawFunc.lineAngleLerp(vert.x + drawScanPos.x, vert.y + drawScanPos.y, (float)(-Mathf.signs[i]) * residualAngles + angTo, drawSize * 6.0f, true, Tmp.c1, Color.clear);
        }
        float maxMatDst = Mathf.sqrt2 * this.scanMatSpacing * (float)(this.scanMatWidth / 2) * 0.55f;
        Rand rand = NHFunc.rand;
        Lines.stroke((float)(rWarmup * 0.75f));
        for (int sx = -this.scanMatWidth / 2; sx <= this.scanMatWidth / 2; ++sx) {
            for (int sy = -this.scanMatWidth / 2; sy <= this.scanMatWidth / 2; ++sy) {
                NHFunc.rand.setSeed((long)sx + 8L << sy);
                float dstMat = Mathf.dst((float)sx, (float)sy);
                float scl = Mathf.maxZero((float)(1.0f - dstMat / maxMatDst));
                Draw.mixcol((Color)Color.white, (float)Mathf.absin((float)rand.random(2, 8), (float)rand.random(0.025f, 0.35f)));
                Draw.alpha((float)(scl * rand.random(scl * 0.25f, scl * 1.125f) * (0.5f + Mathf.absin((float)rand.random(2, 5), (float)rand.random(0.125f, 0.65f)))));
                tmpVec.set((float)sx * this.scanMatSpacing, (float)sy * this.scanMatSpacing).rotate(rot).add(drawScanPos);
                Lines.lineAngleCenter((float)ProbeEntity.tmpVec.x, (float)ProbeEntity.tmpVec.y, (float)rot, (float)(this.scanMatSpacing * 0.8f));
                Lines.lineAngleCenter((float)ProbeEntity.tmpVec.x, (float)ProbeEntity.tmpVec.y, (float)(rot - 90.0f), (float)(this.scanMatSpacing * 0.8f));
            }
        }
        Draw.mixcol();
        Draw.z((float)122.0f);
        Fill.light((float)drawScanPos.x, (float)drawScanPos.y, (int)((int)((float)Lines.circleVertices((float)drawSize) * 0.75f)), (float)(drawSize * 1.25f), (Color)Tmp.c1.a((0.85f + Mathf.absin((float)4.0f, (float)0.15f)) * rWarmup), (Color)Color.clear);
        Draw.z((float)z);
    }

    public boolean isCommandable() {
        return false;
    }

    public void readSync(Reads read) {
        this.targetTeam = TypeIO.readTeam((Reads)read);
        super.readSync(read);
    }

    public void read(Reads read) {
        this.targetTeam = TypeIO.readTeam((Reads)read);
        super.read(read);
    }

    public void write(Writes write) {
        TypeIO.writeTeam((Writes)write, (Team)this.targetTeam);
        super.write(write);
    }

    public void writeSync(Writes write) {
        TypeIO.writeTeam((Writes)write, (Team)this.targetTeam);
        super.writeSync(write);
    }

    public void setProp(LAccess prop, Object value) {
        switch (prop) {
            case team: {
                if (!(value instanceof Team)) break;
                Team t = (Team)value;
                if (Vars.net.client()) break;
                UnitController var9 = this.controller;
                if (var9 instanceof Player) {
                    Player p = (Player)var9;
                    p.team(t);
                }
                this.team = t;
                break;
            }
            case payloadType: {
                if (!(value instanceof Team)) break;
                this.targetTeam = (Team)value;
            }
        }
    }
}

