/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units.unitEntity;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.gen.UnitEntity;
import newhorizon.content.NHContent;
import newhorizon.content.NHUnitTypes;
import newhorizon.expand.entities.EntityRegister;
import newhorizon.util.func.NHFunc;
import newhorizon.util.graphic.DrawFunc;

public class NucleoidEntity
extends UnitEntity {
    public static final float MaxDamagedPerSec = 30000.0f;
    public static final float RecentDamageResume = 500.0f;
    public static float maxOnceDamage = 3000.0f;
    public static float REINFORCEMENTS_SPACING = 7200.0f;
    public float recentDamage = 30000.0f;
    public float reinforcementsReload = REINFORCEMENTS_SPACING;

    public int classId() {
        return EntityRegister.getID(NucleoidEntity.class);
    }

    public float mass() {
        return 8000000.0f;
    }

    public void update() {
        super.update();
        this.recentDamage += 500.0f * Time.delta;
        if (this.recentDamage >= 30000.0f) {
            this.recentDamage = 30000.0f;
        }
        this.reinforcementsReload += Time.delta;
        if (this.healthf() < 0.3f && this.reinforcementsReload >= REINFORCEMENTS_SPACING) {
            this.reinforcementsReload = 0.0f;
            for (int i : Mathf.signs) {
                Tmp.v1.trns(this.rotation + (float)(60 * i), -this.hitSize * 1.85f).add(this.x, this.y);
                NHFunc.spawnUnit(this.team, Tmp.v1.x, Tmp.v1.y, this.rotation, 8.0f, 120.0f, 0.0f, NHUnitTypes.pester, 1);
            }
        }
    }

    public void draw() {
        super.draw();
        float z = Draw.z();
        Draw.z((float)100.0f);
        Tmp.c1.set(this.team.color).lerp(Color.white, Mathf.absin((float)4.0f, (float)0.15f));
        Draw.color((Color)Tmp.c1);
        Lines.stroke((float)3.0f);
        DrawFunc.circlePercent(this.x, this.y, this.hitSize * 1.15f, this.reinforcementsReload / REINFORCEMENTS_SPACING, 0.0f);
        float scl = Interp.pow3Out.apply(Mathf.curve((float)(this.reinforcementsReload / REINFORCEMENTS_SPACING), (float)0.96f, (float)1.0f));
        TextureRegion arrowRegion = NHContent.arrowRegion;
        for (int l : Mathf.signs) {
            float angle = 90 + 90 * l;
            for (int i = 0; i < 4; ++i) {
                Tmp.v1.trns(angle, (float)(i * 50) + this.hitSize * 1.32f);
                float f = (100.0f - (Time.time + (float)(25 * i)) % 100.0f) / 100.0f;
                Draw.rect((TextureRegion)arrowRegion, (float)(this.x + Tmp.v1.x), (float)(this.y + Tmp.v1.y), (float)((float)arrowRegion.width * f * scl), (float)((float)arrowRegion.height * f * scl), (float)(angle + 90.0f));
            }
        }
        Draw.z((float)z);
    }

    public void rawDamage(float amount) {
        boolean hadShields;
        boolean bl = hadShields = this.shield > 1.0E-4f;
        if (hadShields) {
            this.shieldAlpha = 1.0f;
        }
        amount = Math.min(amount, maxOnceDamage);
        float shieldDamage = Math.min(Math.max(this.shield, 0.0f), amount);
        this.shield -= shieldDamage;
        this.hitTime = 1.0f;
        amount -= shieldDamage;
        amount = Math.min(this.recentDamage / this.healthMultiplier, amount);
        this.recentDamage -= amount * 1.5f * this.healthMultiplier;
        if (amount > 0.0f && this.type.killable) {
            this.health -= amount;
            if (this.health <= 0.0f && !this.dead) {
                this.kill();
            }
            if (hadShields && this.shield <= 1.0E-4f) {
                Fx.unitShieldBreak.at(this.x, this.y, 0.0f, this.team.color, (Object)this);
            }
        }
    }

    public void read(Reads read) {
        this.reinforcementsReload = read.f();
        super.read(read);
    }

    public void write(Writes write) {
        write.f(this.reinforcementsReload);
        super.write(write);
    }

    public void readSync(Reads read) {
        super.readSync(read);
        if (!this.isLocal()) {
            this.reinforcementsReload = read.f();
        } else {
            read.f();
        }
    }

    public void writeSync(Writes write) {
        super.writeSync(write);
        write.f(this.reinforcementsReload);
    }
}

