/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units.ablility;

import arc.audio.Sound;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.ui.Bar;

public class TurretShield
extends Ability {
    private static Unit paramUnit;
    private static TurretShield paramField;
    private static final Vec2 paramPos;
    private static float paramRot;
    private static final Cons<Bullet> shieldConsumer;
    protected static final Cons<Unit> unitConsumer;
    public int weaponIndex = 0;
    public float radius = 60.0f;
    public float regen = 0.1f;
    public float max = 200.0f;
    public float cooldown = 300.0f;
    public float angle = 80.0f;
    public float angleOffset = 0.0f;
    public float x = 0.0f;
    public float y = 0.0f;
    public boolean whenShooting = true;
    public float width = 6.0f;
    public float drawWidth;
    public float chanceDeflect = -1.0f;
    public Sound deflectSound = Sounds.none;
    public float missileUnitMultiplier = 2.0f;
    public boolean drawArc = true;
    @Nullable
    public String region;
    @Nullable
    public Color color;
    public boolean offsetRegion = false;
    protected float widthScale;
    protected float alpha;
    protected WeaponMount turret;

    public void addStats(Table t) {
        super.addStats(t);
        t.add((CharSequence)this.abilityStat("shield", new Object[]{Strings.autoFixed((float)this.max, (int)2)}));
        t.row();
        t.add((CharSequence)this.abilityStat("repairspeed", new Object[]{Strings.autoFixed((float)(this.regen * 60.0f), (int)2)}));
        t.row();
        t.add((CharSequence)this.abilityStat("cooldown", new Object[]{Strings.autoFixed((float)(this.cooldown / 60.0f), (int)2)}));
        t.row();
        t.add((CharSequence)this.abilityStat("deflectchance", new Object[]{Strings.autoFixed((float)(this.chanceDeflect * 100.0f), (int)2)}));
    }

    public void update(Unit unit) {
        WeaponMount mount = unit.mounts[this.weaponIndex];
        if (this.data < this.max) {
            this.data += Time.delta * this.regen;
        }
        boolean active = this.data > 0.0f && (unit.isShooting || !this.whenShooting);
        this.alpha = Math.max(this.alpha - Time.delta / 10.0f, 0.0f);
        if (active) {
            this.widthScale = Mathf.lerpDelta((float)this.widthScale, (float)1.0f, (float)0.06f);
            paramRot = mount.rotation + unit.rotation;
            paramUnit = unit;
            paramField = this;
            paramPos.set(this.x, this.y).rotate(mount.rotation + unit.rotation).add((Position)unit);
            float reach = this.radius + this.width;
            Groups.bullet.intersect(TurretShield.paramPos.x - reach, TurretShield.paramPos.y - reach, reach * 2.0f, reach * 2.0f, shieldConsumer);
            Units.nearbyEnemies((Team)TurretShield.paramUnit.team, (float)(TurretShield.paramPos.x - reach), (float)(TurretShield.paramPos.y - reach), (float)(reach * 2.0f), (float)(reach * 2.0f), unitConsumer);
        } else {
            this.widthScale = Mathf.lerpDelta((float)this.widthScale, (float)0.0f, (float)0.11f);
        }
    }

    public void init(UnitType type) {
        this.data = this.max;
        if (this.weaponIndex >= type.weapons.size) {
            throw new ArrayIndexOutOfBoundsException("Weapon index " + this.weaponIndex + " exceeds available weapons count: " + type.weapons.size);
        }
    }

    public void draw(Unit unit) {
        if (this.widthScale > 0.001f) {
            WeaponMount mount = unit.mounts[this.weaponIndex];
            Draw.z((float)125.0f);
            Draw.color((Color)(this.color == null ? unit.team.color : this.color), (Color)Color.white, (float)Mathf.clamp((float)this.alpha));
            Vec2 pos = paramPos.set(this.x, this.y).rotate(mount.rotation + unit.rotation).add((Position)unit);
            if (!Vars.renderer.animateShields) {
                Draw.alpha((float)0.4f);
            }
            if (this.region != null) {
                Vec2 rp = this.offsetRegion ? pos : Tmp.v1.set((Position)unit);
                Draw.yscl = this.widthScale;
                Draw.rect((String)this.region, (float)rp.x, (float)rp.y, (float)(mount.rotation + unit.rotation));
                Draw.yscl = 1.0f;
            }
            if (this.drawArc) {
                float strokeWidth = (this.drawWidth > 0.0f ? this.drawWidth : this.width) * this.widthScale;
                Lines.stroke((float)strokeWidth);
                Lines.arc((float)pos.x, (float)pos.y, (float)(this.radius + Math.max(0.0f, (this.width - strokeWidth) / 2.0f)), (float)(this.angle / 360.0f), (float)(mount.rotation + unit.rotation + this.angleOffset - this.angle / 2.0f));
            }
            Draw.reset();
        }
    }

    public void displayBars(Unit unit, Table bars) {
        bars.add((Element)new Bar("stat.shieldhealth", Pal.accent, () -> this.data / this.max)).row();
    }

    static {
        paramPos = new Vec2();
        shieldConsumer = b -> {
            if (b.team != TurretShield.paramUnit.team && b.type.absorbable && TurretShield.paramField.data > 0.0f && (paramPos.within((Position)b, TurretShield.paramField.radius + TurretShield.paramField.width / 2.0f) || Tmp.v1.set((Position)b).add(b.vel).within((Position)paramPos, TurretShield.paramField.radius + TurretShield.paramField.width / 2.0f)) && Angles.within((float)paramPos.angleTo((Position)b), (float)(paramRot + TurretShield.paramField.angleOffset), (float)(TurretShield.paramField.angle / 2.0f))) {
                if (TurretShield.paramField.chanceDeflect > 0.0f && b.vel.len() >= 0.1f && b.type.reflectable && Mathf.chance((double)TurretShield.paramField.chanceDeflect)) {
                    TurretShield.paramField.deflectSound.at((Position)paramPos, Mathf.random((float)0.9f, (float)1.1f));
                    b.trns(-b.vel.x, -b.vel.y);
                    float penX = Math.abs(TurretShield.paramPos.x - b.x);
                    float penY = Math.abs(TurretShield.paramPos.y - b.y);
                    if (penX > penY) {
                        b.vel.x *= -1.0f;
                    } else {
                        b.vel.y *= -1.0f;
                    }
                    b.owner = paramUnit;
                    b.team = TurretShield.paramUnit.team;
                    b.time += 1.0f;
                } else {
                    b.absorb();
                    Fx.absorb.at((Position)b);
                }
                if (TurretShield.paramField.data <= b.damage()) {
                    TurretShield.paramField.data -= TurretShield.paramField.cooldown * TurretShield.paramField.regen;
                    Fx.arcShieldBreak.at(TurretShield.paramPos.x, TurretShield.paramPos.y, 0.0f, TurretShield.paramField.color == null ? TurretShield.paramUnit.type.shieldColor(paramUnit) : TurretShield.paramField.color, (Object)paramUnit);
                }
                TurretShield.paramField.data -= b.type.shieldDamage(b);
                TurretShield.paramField.alpha = 1.0f;
            }
        };
        unitConsumer = unit -> {
            if (TurretShield.paramField.data > 0.0f && unit.targetable(TurretShield.paramUnit.team) && (!unit.within((Position)paramPos, TurretShield.paramField.radius - TurretShield.paramField.width) || !paramPos.within(unit.x - unit.deltaX, unit.y - unit.deltaY, TurretShield.paramField.radius - TurretShield.paramField.width)) && (Tmp.v1.set((Position)unit).add(unit.deltaX, unit.deltaY).within((Position)paramPos, TurretShield.paramField.radius + TurretShield.paramField.width) || unit.within((Position)paramPos, TurretShield.paramField.radius + TurretShield.paramField.width)) && (Angles.within((float)paramPos.angleTo((Position)unit), (float)(paramRot + TurretShield.paramField.angleOffset), (float)(TurretShield.paramField.angle / 2.0f)) || Angles.within((float)paramPos.angleTo(unit.x + unit.deltaX, unit.y + unit.deltaY), (float)(paramRot + TurretShield.paramField.angleOffset), (float)(TurretShield.paramField.angle / 2.0f)))) {
                if (unit.isMissile() && unit.killable() && TurretShield.paramField.missileUnitMultiplier >= 0.0f) {
                    unit.remove();
                    unit.type.deathSound.at((Position)unit);
                    unit.type.deathExplosionEffect.at((Position)unit);
                    Fx.absorb.at((Position)unit);
                    Fx.circleColorSpark.at(unit.x, unit.y, TurretShield.paramUnit.team.color);
                    TurretShield.paramField.data -= unit.health() * TurretShield.paramField.missileUnitMultiplier * Vars.state.rules.unitDamage(unit.team);
                    TurretShield.paramField.alpha = 1.0f;
                } else {
                    float reach = TurretShield.paramField.radius + TurretShield.paramField.width;
                    float overlapDst = reach - unit.dst(TurretShield.paramPos.x, TurretShield.paramPos.y);
                    if (overlapDst > 0.0f) {
                        unit.vel.setZero();
                        unit.move(Tmp.v1.set((Position)unit).sub((Position)paramUnit).setLength(overlapDst + 0.01f));
                        if (Mathf.chanceDelta((double)(0.5f * Time.delta))) {
                            Fx.circleColorSpark.at(unit.x, unit.y, TurretShield.paramUnit.team.color);
                        }
                    }
                }
            }
        };
    }
}

