/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units.ablility;

import arc.audio.Sound;
import arc.func.Cons;
import arc.func.Cons2;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.ObjectFloatMap;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import newhorizon.content.NHColor;
import newhorizon.content.NHFx;
import newhorizon.content.NHSounds;
import newhorizon.util.feature.PosLightning;

public class ShockWaveAbility
extends Ability {
    protected static final Seq<Unit> all = new Seq();
    public ObjectFloatMap<StatusEffect> status = new ObjectFloatMap();
    public boolean targetGround = true;
    public boolean targetAir = true;
    public float x;
    public float y;
    public float reload = 500.0f;
    public float range = 400.0f;
    public float damage = 400.0f;
    public float knockback = 20.0f;
    public float rotKnock = 10.0f;
    public Color hitColor = NHColor.ancientLightMid;
    public Sound shootSound = NHSounds.shock;
    public Effect shootEffect = NHFx.circleOut;
    public Effect hitEffect = NHFx.hitSparkLarge;
    public float maxSpeed = -1.0f;
    public int boltNum = 2;
    public float boltWidth = 2.0f;
    public Cons2<Position, Position> effect = (from, to) -> PosLightning.createEffect(from, to, this.hitColor, this.boltNum, this.boltWidth);
    protected float timer = 0.0f;

    public ShockWaveAbility(float reload, float range, float damage, Color hitColor) {
        this.reload = reload;
        this.range = range;
        this.damage = damage;
        this.hitColor = hitColor;
    }

    public ShockWaveAbility modify(Cons<ShockWaveAbility> m) {
        m.get((Object)this);
        return this;
    }

    public ShockWaveAbility status(Object ... values) {
        for (int i = 0; i < values.length / 2; ++i) {
            this.status.put((Object)((StatusEffect)values[i * 2]), ((Float)values[i * 2 + 1]).floatValue());
        }
        return this;
    }

    public void init(UnitType type) {
        super.init(type);
        if (this.maxSpeed > 0.0f) {
            this.maxSpeed *= this.maxSpeed;
        }
    }

    public void update(Unit unit) {
        if (unit.disarmed) {
            return;
        }
        this.timer += Time.delta * unit.reloadMultiplier;
        if (this.maxSpeed > 0.0f && unit.vel().len2() > this.maxSpeed) {
            this.timer = 0.0f;
        } else if (this.timer > this.reload) {
            all.clear();
            Tmp.v1.trns(unit.rotation - 90.0f, this.x, this.y).add(unit.x, unit.y);
            float rx = Tmp.v1.x;
            float ry = Tmp.v1.y;
            Units.nearby(null, (float)rx, (float)ry, (float)this.range, other -> {
                if (other.team != unit.team && other.checkTarget(this.targetAir, this.targetGround) && other.targetable(unit.team)) {
                    all.add(other);
                }
            });
            if (all.any()) {
                this.timer = 0.0f;
                this.shootSound.at(rx, ry, 1.0f + Mathf.range((float)0.15f), 3.0f);
                this.shootEffect.at(rx, ry, this.range, this.hitColor);
                for (Unit u : all) {
                    for (ObjectFloatMap.Entry s : this.status.entries()) {
                        u.apply((StatusEffect)s.key, s.value);
                    }
                    Tmp.v3.set((Position)unit).sub(Tmp.v1).nor().scl(this.knockback * 80.0f);
                    u.impulse(Tmp.v3);
                    u.damage(this.damage);
                    this.hitEffect.at(u.x, u.y, this.hitColor);
                    this.effect.get((Object)Tmp.v1, (Object)u);
                }
            }
        }
    }

    public void draw(Unit unit) {
        super.draw(unit);
    }

    public String localized() {
        return super.localized();
    }
}

