/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units.ablility;

import arc.func.Cons;
import arc.graphics.Color;
import arc.util.Time;
import mindustry.entities.Units;
import mindustry.entities.abilities.RepairFieldAbility;
import mindustry.game.Team;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import newhorizon.content.NHFx;

public class AdaptedHealAbility
extends RepairFieldAbility {
    public Color applyColor = Pal.heal;
    public boolean ignoreHealthMultiplier = true;
    public float selfHealAmount = 5.0E-4f;
    public float selfHealReloadTime = -1.0f;
    protected float lastHealth = 0.0f;
    protected float selfHealReload = 0.0f;

    public AdaptedHealAbility(float amount, float reload, float range, Color applyColor) {
        this(amount, reload, range);
        this.applyColor = applyColor;
    }

    public AdaptedHealAbility(float amount, float reload, float range) {
        super(amount, reload, range);
        this.healEffect = NHFx.healReceiveCircle;
        this.activeEffect = NHFx.healSendCircle;
    }

    public AdaptedHealAbility modify(Cons<AdaptedHealAbility> modifier) {
        modifier.get((Object)this);
        return this;
    }

    public void update(Unit unit) {
        this.timer += Time.delta;
        if (this.timer >= this.reload) {
            this.wasHealed = false;
            Units.nearby((Team)unit.team, (float)unit.x, (float)unit.y, (float)this.range, other -> {
                if (other.damaged()) {
                    this.healEffect.at(other.x, other.y, 0.0f, this.applyColor, this.parentizeEffects ? other : null);
                    this.wasHealed = true;
                }
                other.heal(this.amount);
            });
            if (this.wasHealed) {
                this.activeEffect.at(unit.x, unit.y, this.range, this.applyColor);
            }
            this.timer = 0.0f;
        }
        if (this.selfHealReloadTime < 0.0f) {
            return;
        }
        if (this.lastHealth <= unit.health && unit.damaged()) {
            this.selfHealReload += Time.delta;
            if (this.selfHealReload > this.selfHealReloadTime) {
                unit.healFract(this.selfHealAmount * (this.ignoreHealthMultiplier ? 1.0f : 1.0f / unit.healthMultiplier));
            }
        } else {
            this.selfHealReload = 0.0f;
        }
        this.lastHealth = unit.health;
    }
}

