/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.gen.Sounds;
import mindustry.gen.TimedKillc;
import mindustry.gen.Unit;
import mindustry.graphics.Trail;
import mindustry.type.unit.MissileUnitType;
import newhorizon.expand.units.AdaptedTimedKillUnit;

public class AdaptedMissileUnitType
extends MissileUnitType {
    public float trailAppearDelay = 0.0f;

    public AdaptedMissileUnitType(String name) {
        super(name);
        this.constructor = AdaptedTimedKillUnit::new;
        this.deathSound = Sounds.explosion;
    }

    public void drawEngines(Unit unit) {
    }

    public void drawTrail(Unit unit) {
        if (((TimedKillc)unit).time() > this.trailAppearDelay) {
            if (unit.trail == null) {
                unit.trail = new Trail(this.trailLength);
            }
            Trail trail = unit.trail;
            Color color = this.trailColor == null ? unit.team.color : this.trailColor;
            float width = (this.engineSize + Mathf.absin((float)Time.time, (float)2.0f, (float)(this.engineSize / 4.0f)) * (this.useEngineElevation ? unit.elevation : 1.0f)) * this.trailScl;
            trail.draw(color, width);
            trail.drawCap(color, width);
        }
    }
}

