/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.rules;

import arc.Core;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import mindustry.gen.Icon;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class AscensionRuleDialog
extends BaseDialog {
    private final Table all = new Table();
    public float enemyHealthModifier = 1.0f;
    public float enemyDamageModifier = 1.0f;

    public AscensionRuleDialog() {
        super("Ascension Rules");
        this.shouldPause = true;
        this.addCloseButton();
        this.shown(this::rebuild);
        this.onResize(this::rebuild);
        this.all.margin(20.0f);
        this.cont.pane((Element)this.all).scrollX(false);
    }

    void rebuild() {
        this.all.table(t -> {
            t.label(() -> "Enemy Health Modifier: " + Strings.fixed((float)this.enemyHealthModifier, (int)2)).growX().padTop(10.0f).padBottom(10.0f).row();
            t.table(s -> {
                s.button((Drawable)Icon.left, Styles.grayi, () -> {
                    this.enemyHealthModifier = Mathf.clamp((float)(this.enemyHealthModifier - 0.1f), (float)1.0f, (float)3.0f);
                }).size(40.0f);
                s.slider(1.0f, 3.0f, 0.01f, 1.0f, f -> {
                    this.enemyHealthModifier = f;
                }).size(0.0f, 40.0f).padLeft(20.0f).padRight(20.0f).update(slider -> slider.setValue(this.enemyHealthModifier)).growX();
                s.button((Drawable)Icon.right, Styles.grayi, () -> {
                    this.enemyHealthModifier = Mathf.clamp((float)(this.enemyHealthModifier + 0.1f), (float)1.0f, (float)3.0f);
                }).size(40.0f);
            }).growX().row();
            t.label(() -> "Enemy Damage Modifier: " + Strings.fixed((float)this.enemyDamageModifier, (int)2)).growX().padTop(10.0f).padBottom(10.0f).row();
            t.table(s -> {
                s.button((Drawable)Icon.left, Styles.grayi, () -> {
                    this.enemyDamageModifier = Mathf.clamp((float)(this.enemyDamageModifier - 0.1f), (float)1.0f, (float)3.0f);
                }).size(40.0f);
                s.slider(1.0f, 5.0f, 0.01f, 1.0f, f -> {
                    this.enemyDamageModifier = f;
                }).size(0.0f, 40.0f).padLeft(20.0f).padRight(20.0f).update(slider -> slider.setValue(this.enemyDamageModifier)).growX();
                s.button((Drawable)Icon.right, Styles.grayi, () -> {
                    this.enemyDamageModifier = Mathf.clamp((float)(this.enemyDamageModifier + 0.1f), (float)1.0f, (float)3.0f);
                }).size(40.0f);
            }).growX().row();
        }).width(Math.min((float)Core.graphics.getWidth() / 1.5f, 600.0f)).expandX();
    }
}

