/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.net;

import arc.audio.Sound;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import mindustry.Vars;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import newhorizon.content.NHContent;
import newhorizon.content.NHSounds;
import newhorizon.expand.ability.active.ActiveAbility;
import newhorizon.expand.logic.DefaultRaid;
import newhorizon.expand.net.packet.ActiveAbilityTriggerPacket;
import newhorizon.expand.net.packet.AlertToastPacket;
import newhorizon.expand.net.packet.WarnHUDPacket;
import newhorizon.util.ui.NHUIFunc;

public class NHCall {
    public static void triggerActiveAbility(Unit unit, int abilityId) {
        Ability ability;
        if ((Vars.net.server() || !Vars.net.active()) && unit != null && unit.abilities.length > abilityId && (ability = unit.abilities[abilityId]) instanceof ActiveAbility) {
            ((ActiveAbility)ability).trigger(unit);
        }
        if (Vars.net.server() || Vars.net.client()) {
            ActiveAbilityTriggerPacket packet = new ActiveAbilityTriggerPacket();
            packet.unit = unit;
            packet.abilityId = abilityId;
            Vars.net.send((Object)packet, true);
        }
    }

    public static void warnHudPacket(String timerName, float time, float range, float sx, float sy, float tx, float ty) {
        if (Vars.net.server() || !Vars.net.active()) {
            DefaultRaid.clientAlertHud(timerName, time, range, sx, sy, tx, ty);
        }
        if (Vars.net.server()) {
            WarnHUDPacket packet = new WarnHUDPacket();
            packet.name = timerName;
            packet.time = time;
            packet.range = range;
            packet.sourceX = sx;
            packet.sourceY = sy;
            packet.targetX = tx;
            packet.targetY = ty;
            Vars.net.send((Object)packet, false);
        }
    }

    public static void alertToastTable(int iconID, int soundID, String text) {
        if (Vars.net.server() || !Vars.net.active()) {
            if (Vars.headless) {
                return;
            }
            NHUIFunc.showToast(NHCall.getDrawable(iconID), text, NHCall.getSound(soundID));
        }
        if (Vars.net.server()) {
            AlertToastPacket packet = new AlertToastPacket();
            packet.text = text;
            packet.iconID = iconID;
            packet.soundID = soundID;
            Vars.net.send((Object)packet, false);
        }
    }

    public static Drawable getDrawable(int id) {
        TextureRegionDrawable textureRegionDrawable;
        switch (id) {
            case 1: {
                textureRegionDrawable = new TextureRegionDrawable(NHContent.raid);
                break;
            }
            case 2: {
                textureRegionDrawable = new TextureRegionDrawable(NHContent.fleet);
                break;
            }
            case 3: {
                textureRegionDrawable = new TextureRegionDrawable(NHContent.icon);
                break;
            }
            case 4: {
                textureRegionDrawable = new TextureRegionDrawable(NHContent.capture);
                break;
            }
            default: {
                textureRegionDrawable = new TextureRegionDrawable(NHContent.objective);
            }
        }
        return textureRegionDrawable;
    }

    public static Sound getSound(int id) {
        if (id == 0) {
            return Sounds.uiUnlock;
        }
        if (id == 1) {
            return NHSounds.alert2;
        }
        return NHSounds.alarm;
    }
}

