/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.map;

import arc.math.geom.Point2;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.io.Reads;
import arc.util.io.Streams;
import arc.util.io.Writes;
import arc.util.serialization.Base64Coder;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.Schematic;
import mindustry.game.Team;
import mindustry.io.TypeIO;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import newhorizon.expand.map.TerrainSchematic;

public class SchematicUtil {
    public static final byte[] header = new byte[]{110, 104, 115, 115};
    private static final Streams.OptimizedByteArrayOutputStream out = new Streams.OptimizedByteArrayOutputStream(1024);

    public static String writeBase64(TerrainSchematic schematic) {
        try {
            out.reset();
            SchematicUtil.write(schematic, (OutputStream)out);
            return new String(Base64Coder.encode((byte[])out.getBuffer(), (int)out.size()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static TerrainSchematic readBase64(String schematic) {
        try {
            return SchematicUtil.read(new ByteArrayInputStream(Base64Coder.decode((String)schematic.trim())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(TerrainSchematic schematic, OutputStream output) throws IOException {
        output.write(header);
        try (DataOutputStream stream = new DataOutputStream(new DeflaterOutputStream(output));){
            stream.writeShort(schematic.width);
            stream.writeShort(schematic.height);
            stream.writeInt(schematic.tileData.size);
            for (TerrainSchematic.SData data : schematic.tileData) {
                stream.writeByte(data.data);
                stream.writeInt(Point2.pack((int)data.x, (int)data.y));
            }
            stream.writeInt(schematic.floor.size);
            for (Schematic.Stile floor : schematic.floor) {
                stream.writeUTF(floor.block.name);
                stream.writeInt(Point2.pack((int)floor.x, (int)floor.y));
            }
            stream.writeInt(schematic.overlay.size);
            for (Schematic.Stile overlay : schematic.overlay) {
                stream.writeUTF(overlay.block.name);
                stream.writeInt(Point2.pack((int)overlay.x, (int)overlay.y));
            }
            stream.writeInt(schematic.block.size);
            for (Schematic.Stile block : schematic.block) {
                stream.writeUTF(block.block.name);
                stream.writeInt(Point2.pack((int)block.x, (int)block.y));
                TypeIO.writeObject((Writes)Writes.get((DataOutput)stream), (Object)block.config);
                stream.writeByte(block.rotation);
            }
        }
    }

    public static TerrainSchematic read(InputStream input) throws IOException {
        TerrainSchematic terrainSchematic;
        for (byte b : header) {
            if (input.read() == b) continue;
            throw new IOException("Not New Horizon Schematic Save!");
        }
        DataInputStream stream = new DataInputStream(new InflaterInputStream(input));
        try {
            short width = stream.readShort();
            short height = stream.readShort();
            int tileDataSize = stream.readInt();
            Seq tileDataAll = new Seq(tileDataSize);
            for (int i = 0; i < tileDataSize; ++i) {
                byte data = stream.readByte();
                int posPack = stream.readInt();
                TerrainSchematic.SData tileData = new TerrainSchematic.SData(data, Point2.x((int)posPack), Point2.y((int)posPack));
                tileDataAll.add((Object)tileData);
            }
            int floorSize = stream.readInt();
            Seq floorAll = new Seq(floorSize);
            for (int i = 0; i < floorSize; ++i) {
                String name = stream.readUTF();
                int posPack = stream.readInt();
                Schematic.Stile floor = new Schematic.Stile(Vars.content.block(name), (int)Point2.x((int)posPack), (int)Point2.y((int)posPack), null, 0);
                floorAll.add((Object)floor);
            }
            int overlaySize = stream.readInt();
            Seq overlayAll = new Seq(floorSize);
            for (int i = 0; i < overlaySize; ++i) {
                String name = stream.readUTF();
                int posPack = stream.readInt();
                Schematic.Stile floor = new Schematic.Stile(Vars.content.block(name), (int)Point2.x((int)posPack), (int)Point2.y((int)posPack), null, 0);
                overlayAll.add((Object)floor);
            }
            int blockSize = stream.readInt();
            Seq blockAll = new Seq(floorSize);
            for (int i = 0; i < blockSize; ++i) {
                String name = stream.readUTF();
                int posPack = stream.readInt();
                Object config = TypeIO.readObject((Reads)Reads.get((DataInput)stream));
                byte rotation = stream.readByte();
                Schematic.Stile floor = new Schematic.Stile(Vars.content.block(name), (int)Point2.x((int)posPack), (int)Point2.y((int)posPack), config, rotation);
                blockAll.add((Object)floor);
            }
            terrainSchematic = new TerrainSchematic((Seq<TerrainSchematic.SData>)tileDataAll, (Seq<Schematic.Stile>)floorAll, (Seq<Schematic.Stile>)overlayAll, (Seq<Schematic.Stile>)blockAll, width, height);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Log.info((Object)e);
                return null;
            }
        }
        stream.close();
        return terrainSchematic;
    }

    public static void placeTerrainOrigin(TerrainSchematic schem, int originX, int originY) {
        int ox = originX - schem.width / 2;
        int oy = originY - schem.height / 2;
        SchematicUtil.placeTerrain(schem, ox, oy, 0, 0, schem.width, schem.height);
    }

    public static void placeTerrainLB(TerrainSchematic schem, int worldX, int worldY) {
        SchematicUtil.placeTerrain(schem, worldX, worldY, 0, 0, schem.width, schem.height);
    }

    public static void placeTerrainLB(TerrainSchematic schem, int worldX, int worldY, int startX, int startY, int width, int height) {
        SchematicUtil.placeTerrain(schem, worldX, worldY, startX, startY, width, height);
    }

    public static void placeBuildLB(Schematic schem, int startX, int startY, Team team) {
        schem.tiles.each(st -> {
            if (st.block == Blocks.stone) {
                return;
            }
            Tile tile = Vars.world.tile(st.x + startX, st.y + startY);
            if (tile == null) {
                return;
            }
            if (st.block instanceof Floor) {
                tile.setFloor(st.block.asFloor());
                return;
            }
            tile.setBlock(st.block, team, (int)st.rotation);
            Object config = st.config;
            if (tile.build != null) {
                tile.build.configureAny(config);
            }
        });
    }

    public static void placeTerrain(TerrainSchematic schem, int worldX, int worldY, int startX, int startY, int width, int height) {
        int endX = startX + width - 1;
        int endY = startY + height - 1;
        schem.tileData.each(st -> {
            if (st.x < startX || st.y < startY || st.x > endX || st.y > endY) {
                return;
            }
            Tile tile = Vars.world.tile(st.x + worldX - startX, st.y + worldY - startY);
            if (tile != null) {
                tile.data = st.data;
            }
        });
        schem.floor.each(st -> {
            if (st.x < startX || st.y < startY || st.x > endX || st.y > endY) {
                return;
            }
            Tile tile = Vars.world.tile(st.x + worldX - startX, st.y + worldY - startY);
            if (tile != null) {
                tile.setFloor((Floor)st.block);
            }
        });
        schem.overlay.each(st -> {
            if (st.x < startX || st.y < startY || st.x > endX || st.y > endY) {
                return;
            }
            Tile tile = Vars.world.tile(st.x + worldX - startX, st.y + worldY - startY);
            if (tile != null) {
                tile.setOverlay(st.block);
            }
        });
        schem.block.each(st -> {
            if (st.x < startX || st.y < startY || st.x > endX || st.y > endY) {
                return;
            }
            Tile tile = Vars.world.tile(st.x + worldX - startX, st.y + worldY - startY);
            if (tile != null) {
                tile.setBlock(st.block);
            }
        });
    }
}

