/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.map;

import arc.graphics.Color;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec3;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.HexMesher;
import mindustry.graphics.g3d.MeshBuilder;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.graphics.g3d.PlanetMesh;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.type.Planet;
import newhorizon.content.NHColor;

public class DysonSphereMesh
extends PlanetMesh {
    static Mat3D mat = new Mat3D();
    public static final PlanetGrid grid = PlanetGrid.create((int)0);
    public static final Vec3[] corners = new Vec3[DysonSphereMesh.grid.tiles.length];
    public static final int[][] edges = new int[DysonSphereMesh.grid.edges.length][2];
    public float speed = 0.32f;

    public DysonSphereMesh(Planet planet, float radius) {
        super(planet, MeshBuilder.buildHex((HexMesher)new HexMesher(){

            public float getHeight(Vec3 position) {
                return 1.0f;
            }

            public void getColor(Vec3 position, Color out) {
                if (this.cornerRange(position, 3.0f)) {
                    out.set(NHColor.darkEnrFront);
                } else if (this.cornerRange(position, 5.0f, 9.0f)) {
                    out.set(Pal.darkerMetal);
                } else if (!this.cornerRange(position, 9.0f)) {
                    if (this.edgeRange(position, 3.0f)) {
                        out.set(NHColor.darkEnrFront);
                    } else if (this.edgeRange(position, 5.0f)) {
                        out.set(Pal.darkerMetal);
                    } else {
                        out.a(0.0f);
                    }
                } else {
                    out.a(0.0f);
                }
            }

            public boolean skip(Vec3 position) {
                this.getColor(position, Tmp.c1);
                return Tmp.c1.a == 0.0f;
            }

            public boolean cornerRange(Vec3 vec, float deg) {
                return this.cornerRange(vec, 0.0f, deg);
            }

            public boolean cornerRange(Vec3 vec, float min, float max) {
                Tmp.v31.set(vec);
                for (Vec3 v : corners) {
                    if (!(Tmp.v31.angle(v) > min) || !(Tmp.v31.angle(v) < max)) continue;
                    return true;
                }
                return false;
            }

            public boolean edgeRange(Vec3 vec, float max) {
                return this.edgeRange(vec, 0.0f, max);
            }

            public boolean edgeRange(Vec3 vec, float min, float max) {
                Tmp.v31.set(vec);
                for (int[] edge : edges) {
                    Tmp.v32.set(corners[edge[0]]).nor();
                    Tmp.v33.set(corners[edge[1]]).nor();
                    if (!this.isOnArcNear(Tmp.v31, Tmp.v32, Tmp.v33, (float)Math.PI / 180 * min / 2.0f, (float)Math.PI / 180 * max / 2.0f)) continue;
                    return true;
                }
                return false;
            }

            public float arcDistance(Vec3 p, Vec3 a, Vec3 b) {
                boolean between;
                Vec3 n = a.cpy().crs(b);
                if (n.isZero()) {
                    return a.angleRad(p);
                }
                boolean bl = between = a.cpy().crs(p).dot(n) >= 0.0f && p.cpy().crs(b).dot(n) >= 0.0f;
                if (between) {
                    Vec3 pProj = p.cpy().sub(n.cpy().scl(p.dot(n))).nor();
                    return (float)Math.acos(Math.min(Math.max(p.dot(pProj), -1.0f), 1.0f));
                }
                return Math.min(a.angleRad(p), b.angleRad(p));
            }

            public boolean isOnArcNear(Vec3 p, Vec3 a, Vec3 b, float min, float max) {
                return this.arcDistance(p, a, b) <= max && this.arcDistance(p, b, a) >= min;
            }
        }, (int)6, (float)planet.radius, (float)radius), (Shader)Shaders.clouds);
    }

    public DysonSphereMesh() {
    }

    public float relRot() {
        return Time.globalTime * this.speed / 40.0f;
    }

    public void render(PlanetParams params, Mat3D projection, Mat3D transform) {
        if (params.planet == this.planet && Mathf.zero((float)(1.0f - params.uiAlpha), (float)0.01f)) {
            return;
        }
        this.preRender(params);
        this.shader.bind();
        this.shader.setUniformMatrix4("u_proj", projection.val);
        this.shader.setUniformMatrix4("u_trans", DysonSphereMesh.mat.setToTranslation((Vec3)this.planet.position).rotate((Vec3)Vec3.Y, (float)(this.planet.getRotation() + this.relRot())).val);
        this.shader.apply();
        this.mesh.render(this.shader, 4);
    }

    public void preRender(PlanetParams params) {
        Shaders.clouds.planet = this.planet;
        Shaders.clouds.lightDir.set(this.planet.solarSystem.position).sub(this.planet.position).rotate(Vec3.Y, this.planet.getRotation() + this.relRot()).nor();
        Shaders.clouds.ambientColor.set(this.planet.solarSystem.lightColor);
        Shaders.clouds.alpha = params.planet == this.planet ? 1.0f - params.uiAlpha : 1.0f;
    }

    static {
        for (PlanetGrid.Ptile ptile : DysonSphereMesh.grid.tiles) {
            DysonSphereMesh.corners[ptile.id] = ptile.v;
        }
        for (PlanetGrid.Ptile ptile : DysonSphereMesh.grid.edges) {
            DysonSphereMesh.edges[ptile.id][0] = ptile.tiles[0].id;
            DysonSphereMesh.edges[ptile.id][1] = ptile.tiles[1].id;
        }
    }
}

